/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.parser;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.appwork.utils.IO;

public class SourceParser {
    private static final Pattern PATTERN_REMOVE_COMENTS1 = Pattern.compile("\\/\\*.*?\\*\\/", 32);
    private static final Pattern PATTERN_REMOVE_COMENTS2 = Pattern.compile("//.*");
    private HashMap<File, String[]> map = new HashMap();
    private final File sourceFolder;
    private FilenameFilter filter;

    public SourceParser(File file) throws IOException {
        this.sourceFolder = file;
        this.filter = null;
    }

    public HashMap<File, String> findOccurancesOf(Field field) {
        HashMap<File, String> hashMap = new HashMap<File, String>();
        for (Map.Entry<File, String[]> entry : this.map.entrySet()) {
            for (String string : entry.getValue()) {
                if (!string.contains(field.getName())) continue;
                if (string.contains("//") || string.contains("/*")) {
                    // empty if block
                }
                hashMap.put(entry.getKey(), string);
            }
        }
        return hashMap;
    }

    public File getSource() {
        return this.sourceFolder;
    }

    private void getSourceFiles(File file) throws IOException {
        for (File file2 : file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return !(SourceParser.this.filter != null && !SourceParser.this.filter.accept(file, string) || !string.endsWith(".java") && !new File(file, string).isDirectory());
            }
        })) {
            if (file2.isDirectory()) {
                this.getSourceFiles(file2);
                continue;
            }
            String string = IO.readFileToString(file2);
            string = PATTERN_REMOVE_COMENTS1.matcher(string).replaceAll("/*comment*/");
            string = PATTERN_REMOVE_COMENTS2.matcher(string).replaceAll("//comment");
            this.map.put(file2, string.split("[\\{\\}\\;]"));
        }
    }

    public void scan() throws IOException {
        this.map = new HashMap();
        this.getSourceFiles(this.sourceFolder);
    }

    public void setFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
    }
}

