/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import org.appwork.exceptions.WTFException;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;
import org.appwork.utils.os.mime.Mime;
import org.appwork.utils.os.mime.MimeDefault;
import org.appwork.utils.os.mime.MimeLinux;
import org.appwork.utils.os.mime.MimeWindows;

public class CrossSystem {
    public static final byte OS_LINUX_OTHER = 6;
    public static final byte OS_MAC_OTHER = 5;
    public static final byte OS_WINDOWS_OTHER = 4;
    public static final byte OS_WINDOWS_NT = 3;
    public static final byte OS_WINDOWS_2000 = 2;
    public static final byte OS_WINDOWS_XP = 0;
    public static final byte OS_WINDOWS_2003 = 7;
    public static final byte OS_WINDOWS_VISTA = 1;
    public static final byte OS_WINDOWS_7 = 8;
    public static final byte OS_WINDOWS_SERVER_2008 = 9;
    private static Boolean openURLSupport = null;
    private static Boolean openFILESupport = null;
    private static String JAVAINT = null;
    private static final String OS_STRING = System.getProperty("os.name");
    private static final byte OS_ID;
    private static final Mime MIME;

    private static boolean _isOpenBrowserSupported() {
        if (CrossSystem.isWindows()) {
            return true;
        }
        try {
            if (!Desktop.isDesktopSupported()) {
                return false;
            }
            Desktop desktop = Desktop.getDesktop();
            return desktop.isSupported(Desktop.Action.BROWSE);
        }
        catch (Throwable throwable) {
            Log.exception(Level.WARNING, throwable);
            return false;
        }
    }

    private static boolean _isOpenFileSupported() {
        if (CrossSystem.isWindows()) {
            return true;
        }
        try {
            if (!Desktop.isDesktopSupported()) {
                return false;
            }
            Desktop desktop = Desktop.getDesktop();
            return desktop.isSupported(Desktop.Action.OPEN);
        }
        catch (Throwable throwable) {
            Log.exception(Level.WARNING, throwable);
            return false;
        }
    }

    private static void _openFILE(File file) throws IOException {
        if (CrossSystem.isWindows()) {
            Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", file.getAbsolutePath()});
        } else {
            Desktop desktop = Desktop.getDesktop();
            URI uRI = file.getCanonicalFile().toURI();
            desktop.open(new File(uRI));
        }
    }

    private static void _openURL(String string) throws IOException, URISyntaxException {
        URL uRL = new URL(string);
        if (CrossSystem.isWindows()) {
            Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", string});
        } else {
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(uRL.toURI());
        }
    }

    public static byte getID() {
        return OS_ID;
    }

    public static String getJavaBinary() {
        String string;
        if (JAVAINT != null) {
            return JAVAINT;
        }
        String string2 = "java";
        if (CrossSystem.isWindows()) {
            string2 = "javaw.exe";
        }
        if ((string = System.getProperty("java.home")) != null) {
            File file = new File(new File(string), "/bin/" + string2);
            if (file.exists() && file.isFile()) {
                JAVAINT = file.getAbsolutePath();
            }
        } else {
            JAVAINT = string2;
        }
        return JAVAINT;
    }

    public static Mime getMime() {
        return MIME;
    }

    public static String getOSString() {
        return OS_STRING;
    }

    public static boolean isLinux() {
        return OS_ID == 6;
    }

    public static boolean isMac() {
        return OS_ID == 5;
    }

    public static boolean isOpenBrowserSupported() {
        if (openURLSupport != null) {
            return openURLSupport;
        }
        openURLSupport = CrossSystem._isOpenBrowserSupported();
        return openURLSupport;
    }

    public static boolean isOpenFileSupported() {
        if (openFILESupport != null) {
            return openFILESupport;
        }
        openFILESupport = CrossSystem._isOpenFileSupported();
        return openFILESupport;
    }

    public static boolean isWindows() {
        switch (OS_ID) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static void openFile(File file) {
        try {
            CrossSystem._openFILE(file);
        }
        catch (Throwable throwable) {
            Log.exception(Level.WARNING, throwable);
        }
    }

    public static void openURL(String string) {
        try {
            CrossSystem._openURL(string);
        }
        catch (Throwable throwable) {
            Log.exception(Level.WARNING, throwable);
        }
    }

    public static void openURL(URL uRL) {
        CrossSystem.openURL(uRL.toString());
    }

    public static void openURLOrShowMessage(String string) {
    }

    public static void restartApplication(Class<?> clazz, String ... stringArray) {
        try {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            File file = null;
            if (CrossSystem.isMac()) {
                HashSet<String[]> hashSet = new HashSet<String[]>();
                for (object = Application.getRootByClass(clazz, null); object != null && hashSet.add((String[])object) && !((File)object).getName().endsWith(".app"); object = ((File)object).getParentFile()) {
                }
                if (((File)object).getName().endsWith(".app")) {
                    arrayList.add("open");
                    arrayList.add("-n");
                    arrayList.add(((File)object).getAbsolutePath());
                    file = ((File)object).getParentFile();
                }
            }
            if (arrayList.isEmpty()) {
                object = clazz.getClassLoader().getResource(clazz.getName().replace(".", "/") + ".class");
                int n = ((URL)object).getPath().indexOf("!");
                if (n <= 0 || !"jar".equalsIgnoreCase(((URL)object).getProtocol())) {
                    throw new WTFException("REstart works only in Jared mode");
                }
                File file2 = new File(new URI(((URL)object).getPath().substring(0, n)));
                file = file2.getParentFile();
                if (CrossSystem.isWindows()) {
                    File object2 = new File(file2.getParentFile(), file2.getName().substring(0, file2.getName().length() - 4) + ".exe");
                    if (object2.exists()) {
                        arrayList.add(object2.getAbsolutePath());
                    } else {
                        arrayList.add(CrossSystem.getJavaBinary());
                        arrayList.add("-jar");
                        arrayList.add(file2.getAbsolutePath());
                    }
                } else {
                    arrayList.add(CrossSystem.getJavaBinary());
                    arrayList.add("-jar");
                    arrayList.add(file2.getAbsolutePath());
                }
            }
            if (stringArray != null) {
                for (String string : stringArray) {
                    arrayList.add(string);
                }
            }
            object = new ProcessBuilder(arrayList.toArray(new String[0]));
            System.out.println("Root: " + file);
            if (file != null) {
                ((ProcessBuilder)object).directory(file);
            }
            ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent((ProcessBuilder)object){
                final /* synthetic */ ProcessBuilder val$pb;
                {
                    this.val$pb = processBuilder;
                    this.setHookPriority(Integer.MIN_VALUE);
                }

                @Override
                public void run() {
                    try {
                        this.val$pb.start();
                    }
                    catch (IOException iOException) {
                        Log.exception(iOException);
                    }
                }
            });
            ShutdownController.getInstance().requestShutdown();
        }
        catch (Throwable throwable) {
            throw new WTFException(throwable);
        }
    }

    static {
        String string = OS_STRING.toLowerCase();
        OS_ID = string.contains("windows 7") ? (byte)8 : (string.contains("windows xp") ? (byte)0 : (string.contains("windows vista") ? (byte)1 : (string.contains("windows 2000") ? (byte)2 : (string.contains("windows 2003") ? (byte)7 : (string.contains("windows server 2008") ? (byte)9 : (string.contains("nt") ? (byte)3 : (string.contains("windows") ? (byte)4 : (string.contains("mac") ? (byte)5 : (byte)6))))))));
        MIME = CrossSystem.isWindows() ? new MimeWindows() : (CrossSystem.isLinux() ? new MimeLinux() : new MimeDefault());
    }
}

