/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.text.DateFormat;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.appwork.utils.Exceptions;

public class LogFormatter
extends SimpleFormatter {
    private final Date date = new Date();
    private int lastThreadID;
    private final DateFormat longTimestamp = DateFormat.getDateTimeInstance(3, 2);

    @Override
    public synchronized String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        this.date.setTime(logRecord.getMillis());
        String string = this.formatMessage(logRecord);
        int n = logRecord.getThreadID();
        if (n != this.lastThreadID) {
            stringBuilder.append("\r\n THREAD: ");
            stringBuilder.append(n);
            stringBuilder.append("\r\n");
        }
        this.lastThreadID = n;
        stringBuilder.append(logRecord.getThreadID());
        stringBuilder.append('|');
        stringBuilder.append(logRecord.getLoggerName());
        stringBuilder.append(' ');
        stringBuilder.append(this.longTimestamp.format(this.date));
        stringBuilder.append(" - ");
        stringBuilder.append(logRecord.getLevel().getName());
        stringBuilder.append(" [ ");
        if (logRecord.getSourceClassName() != null) {
            stringBuilder.append(logRecord.getSourceClassName());
        } else {
            stringBuilder.append(logRecord.getLoggerName());
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuilder.append('(');
            stringBuilder.append(logRecord.getSourceMethodName());
            stringBuilder.append(')');
        }
        stringBuilder.append(" ] ");
        stringBuilder.append("-> ");
        stringBuilder.append(string);
        stringBuilder.append("\r\n");
        if (logRecord.getThrown() != null) {
            stringBuilder.append(Exceptions.getStackTrace(logRecord.getThrown()));
        }
        return stringBuilder.toString();
    }
}

