/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.event;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import org.appwork.utils.IO;
import org.appwork.utils.event.DefaultEvent;

public abstract class Eventsender<ListenerType extends EventListener, EventType extends DefaultEvent> {
    protected volatile transient ArrayList<ListenerType> strongListeners = null;
    protected volatile transient ArrayList<WeakReference<ListenerType>> weakListener = null;
    private final Object LOCK = new Object();

    private static void create(String string, File file) throws IOException {
        String string2 = "";
        System.out.println("");
        File file2 = file;
        do {
            if (string2.length() > 0) {
                string2 = "." + string2;
            }
            string2 = file2.getName() + string2;
        } while ((file2 = file2.getParentFile()) != null && !file2.getName().equals("src"));
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string + "EventSender";
        String string4 = string + "Event";
        String string5 = string + "Listener";
        stringBuilder.append("package " + string2 + ";\r\n\r\n");
        stringBuilder.append("import org.appwork.utils.event.Eventsender;\r\n\r\n");
        stringBuilder.append("public class " + string3 + " extends Eventsender<" + string5 + ", " + string4 + "> {\r\n\r\n");
        stringBuilder.append("@Override\r\n");
        stringBuilder.append("protected void fireEvent(" + string5 + " listener, " + string4 + " event) {\r\nswitch (event.getType()) {\r\n//fill\r\ndefault: System.out.println(\"Unhandled Event: \"+event); \r\n}\r\n}");
        stringBuilder.append("}");
        new File(file, string3 + ".java").delete();
        IO.writeStringToFile(new File(file, string3 + ".java"), stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("package " + string2 + ";\r\n\r\n");
        stringBuilder.append("import java.util.EventListener;\r\n\r\n");
        stringBuilder.append("public interface " + string5 + " extends EventListener {\r\n\r\n}");
        new File(file, string5 + ".java").delete();
        IO.writeStringToFile(new File(file, string5 + ".java"), stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("package " + string2 + ";\r\n\r\n");
        stringBuilder.append("import org.appwork.utils.event.SimpleEvent;\r\n\r\n");
        stringBuilder.append("public class " + string4 + " extends SimpleEvent<Object, Object, " + string4 + ".Type> {\r\n\r\n");
        stringBuilder.append("public static enum Type{\r\n}\r\n");
        stringBuilder.append("public " + string4 + "(Object caller, Type type, Object... parameters) {\r\n");
        stringBuilder.append("super(caller, type, parameters);\r\n}\r\n");
        stringBuilder.append("}");
        new File(file, string4 + ".java").delete();
        IO.writeStringToFile(new File(file, string4 + ".java"), stringBuilder.toString());
    }

    public Eventsender() {
        this.strongListeners = new ArrayList();
        this.weakListener = new ArrayList();
    }

    public void addAllListener(ArrayList<ListenerType> arrayList) {
        this.addAllListener(arrayList, false);
    }

    public void addAllListener(ArrayList<ListenerType> arrayList, boolean bl) {
        for (EventListener eventListener : arrayList) {
            this.addListener(eventListener, bl);
        }
    }

    public void addListener(ListenerType ListenerType) {
        this.addListener(ListenerType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ListenerType ListenerType, boolean bl) {
        if (ListenerType == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            Object object2;
            boolean bl2 = false;
            if (!bl) {
                object2 = new ArrayList<ListenerType>(this.strongListeners);
                if (!((ArrayList)object2).contains(ListenerType)) {
                    ((ArrayList)object2).add(ListenerType);
                }
                this.strongListeners = object2;
            }
            object2 = null;
            ArrayList<WeakReference<ListenerType>> arrayList = new ArrayList<WeakReference<ListenerType>>(this.weakListener.size());
            for (WeakReference<ListenerType> weakReference : this.weakListener) {
                object2 = (EventListener)weakReference.get();
                if (object2 == null) continue;
                if (object2 == ListenerType) {
                    bl2 = true;
                    arrayList.add(weakReference);
                    continue;
                }
                arrayList.add(weakReference);
            }
            if (!bl2) {
                arrayList.add(new WeakReference<ListenerType>(ListenerType));
            }
            this.weakListener = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<WeakReference<ListenerType>> arrayList = new ArrayList<WeakReference<ListenerType>>(this.weakListener.size());
            for (WeakReference<ListenerType> weakReference : this.weakListener) {
                if (weakReference.get() == null) continue;
                arrayList.add(weakReference);
            }
            this.weakListener = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsListener(ListenerType ListenerType) {
        if (ListenerType == null) {
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            for (Object object2 : this.strongListeners) {
                if (object2 != ListenerType) continue;
                return true;
            }
            Object object3 = null;
            for (WeakReference weakReference : this.weakListener) {
                object3 = (EventListener)weakReference.get();
                if (object3 == null || object3 != ListenerType) continue;
                return true;
            }
            return false;
        }
    }

    public final void fireEvent(EventType EventType) {
        if (EventType == null) {
            return;
        }
        EventListener eventListener = null;
        boolean bl = false;
        ArrayList<WeakReference<ListenerType>> arrayList = this.weakListener;
        for (WeakReference<ListenerType> weakReference : arrayList) {
            eventListener = (EventListener)weakReference.get();
            if (eventListener == null) {
                bl = true;
                continue;
            }
            this.fireEvent(eventListener, EventType);
        }
        if (bl && arrayList.size() > 0) {
            this.cleanup();
        }
    }

    public final void fireEvent(int n, Object ... objectArray) {
        EventListener eventListener = null;
        boolean bl = false;
        ArrayList<WeakReference<ListenerType>> arrayList = this.weakListener;
        for (WeakReference<ListenerType> weakReference : arrayList) {
            eventListener = (EventListener)weakReference.get();
            if (eventListener == null) {
                bl = true;
                continue;
            }
            this.fireEvent(eventListener, n, objectArray);
        }
        if (bl && arrayList.size() > 0) {
            this.cleanup();
        }
    }

    protected abstract void fireEvent(ListenerType var1, EventType var2);

    protected void fireEvent(ListenerType ListenerType, int n, Object ... objectArray) {
        throw new RuntimeException("Not implemented. Overwrite org.appwork.utils.event.Eventsender.fireEvent(T, int, Object...) to use this");
    }

    public ArrayList<ListenerType> getListener() {
        ArrayList<WeakReference<ListenerType>> arrayList = this.weakListener;
        boolean bl = true;
        ArrayList<EventListener> arrayList2 = new ArrayList<EventListener>(arrayList.size());
        EventListener eventListener = null;
        for (WeakReference<ListenerType> weakReference : arrayList) {
            eventListener = (EventListener)weakReference.get();
            if (eventListener != null) {
                arrayList2.add(eventListener);
                continue;
            }
            bl = true;
        }
        if (bl && arrayList.size() > 0) {
            this.cleanup();
        }
        return arrayList2;
    }

    public boolean hasListener() {
        ArrayList<WeakReference<ListenerType>> arrayList = this.weakListener;
        for (WeakReference<ListenerType> weakReference : arrayList) {
            if (weakReference.get() == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ListenerType ListenerType) {
        if (ListenerType == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            EventListener eventListener = null;
            ArrayList<WeakReference<ListenerType>> arrayList = new ArrayList<WeakReference<ListenerType>>(this.weakListener.size());
            ArrayList<ListenerType> arrayList2 = new ArrayList<ListenerType>(this.strongListeners);
            for (WeakReference<ListenerType> weakReference : this.weakListener) {
                eventListener = (EventListener)weakReference.get();
                if (eventListener == null || eventListener == ListenerType) continue;
                arrayList.add(weakReference);
            }
            arrayList2.remove(ListenerType);
            this.weakListener = arrayList;
            this.strongListeners = arrayList2;
        }
    }
}

