/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.txtresource;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.appwork.storage.JSonStorage;
import org.appwork.txtresource.Default;
import org.appwork.txtresource.Defaults;
import org.appwork.txtresource.Description;
import org.appwork.txtresource.DynamicResourcePath;
import org.appwork.txtresource.TranslateData;
import org.appwork.txtresource.TranslateInterface;
import org.appwork.txtresource.TranslateResource;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;

public class TranslationHandler
implements InvocationHandler {
    private final Class<? extends TranslateInterface> tInterface;
    private ArrayList<TranslateResource> lookup;
    private final HashMap<Method, String> cache;
    private final Method[] methods;
    private final HashMap<String, TranslateResource> resourceCache;
    public static final String DEFAULT = "en";

    public TranslationHandler(Class<? extends TranslateInterface> clazz, String[] stringArray) {
        this.tInterface = clazz;
        this.methods = this.tInterface.getDeclaredMethods();
        this.cache = new HashMap();
        this.resourceCache = new HashMap();
        this.lookup = this.fillLookup(stringArray);
    }

    private boolean checkTypes(Method method, Class<?>[] classArray) {
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != classArray.length) {
            return false;
        }
        if (classArray.length == 0) {
            return true;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == classArray2[i]) continue;
            if (Number.class.isAssignableFrom(classArray[i])) {
                if (classArray2[i] == Integer.TYPE || classArray2[i] == Long.TYPE || classArray2[i] == Double.TYPE || classArray2[i] == Float.TYPE || classArray2[i] == Byte.TYPE || classArray2[i] == Character.TYPE) continue;
                return false;
            }
            return classArray[i] == Boolean.class && classArray2[i] == Boolean.TYPE;
        }
        return true;
    }

    public String createFile(String string, boolean bl) {
        TranslateData translateData = new TranslateData();
        this.cache.clear();
        this.lookup = this.fillLookup(string);
        for (Method method : this.tInterface.getDeclaredMethods()) {
            try {
                translateData.put(method.getName(), this.invoke(null, method, null).toString());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        Object object = JSonStorage.serializeToJson(translateData);
        if (bl) {
            for (Method method : this.tInterface.getDeclaredMethods()) {
                Default default_ = method.getAnnotation(Default.class);
                Description description = method.getAnnotation(Description.class);
                String string2 = "";
                if (description != null) {
                    String string3 = description.value().replaceAll("[\\\r\\\n]+", "\r\n//    ");
                    string2 = string2 + "\r\n// Description:\r\n//    " + string3;
                }
                if (default_ != null) {
                    string2 = string2 + "\r\n// Defaultvalue:\r\n//    " + default_.toString().replaceAll("[\\\r\\\n]+", "\r\n//    ");
                }
                if (string2.length() <= 0) continue;
                object = ((String)object).replace("\"" + method.getName() + "\" : \"", string2 + "\r\n\r\n     " + "\"" + method.getName() + "\" : \"");
            }
        }
        return object;
    }

    private TranslateResource createTranslationResource(String string) throws IOException, InstantiationException, IllegalAccessException {
        Defaults defaults;
        TranslateResource translateResource = this.resourceCache.get(string);
        if (translateResource != null) {
            return translateResource;
        }
        DynamicResourcePath dynamicResourcePath = this.tInterface.getAnnotation(DynamicResourcePath.class);
        String string2 = dynamicResourcePath != null ? dynamicResourcePath.value().newInstance().getPath() + "." + string + ".lng" : this.tInterface.getName().replace(".", "/") + "." + string + ".lng";
        URL uRL = Application.getRessourceURL(string2, false);
        if (uRL == null && (defaults = this.tInterface.getAnnotation(Defaults.class)) != null) {
            for (String string3 : defaults.lngs()) {
                if (!string3.equals(string)) continue;
                Log.L.info("Translation file missing:" + string2 + "Use Annotation Dev fallback");
                break;
            }
        }
        translateResource = new TranslateResource(uRL, string);
        this.resourceCache.put(string, translateResource);
        return translateResource;
    }

    private ArrayList<TranslateResource> fillLookup(String ... stringArray) {
        TranslateResource translateResource;
        ArrayList<TranslateResource> arrayList = new ArrayList<TranslateResource>();
        boolean bl = false;
        for (String string : stringArray) {
            try {
                if (DEFAULT.equals(string)) {
                    bl = true;
                }
                translateResource = this.createTranslationResource(string);
                arrayList.add(translateResource);
            }
            catch (NullPointerException nullPointerException) {
                Log.L.warning(nullPointerException.getMessage());
            }
            catch (Throwable throwable) {
                Log.exception(Level.WARNING, throwable);
            }
        }
        if (!bl) {
            try {
                translateResource = this.createTranslationResource(DEFAULT);
                arrayList.add(translateResource);
            }
            catch (Throwable throwable) {
                Log.exception(Level.WARNING, throwable);
            }
        }
        return arrayList;
    }

    private String format(String string, Object[] objectArray) {
        if (objectArray != null) {
            int n = 0;
            for (Object object : objectArray) {
                string = string.replace("%s" + ++n, object == null ? "null" : object.toString());
            }
        }
        return string;
    }

    public String getDefault(Method method) {
        TranslateResource translateResource = this.resourceCache.get(DEFAULT);
        return translateResource.readDefaults(method);
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public String getTranslation(Method method, Object ... objectArray) {
        return this.getValue(method, this.lookup);
    }

    public String getTranslation(String string, String string2, Object ... objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        for (Method method : this.methods) {
            if (!method.getName().equals(string2) || !this.checkTypes(method, classArray)) continue;
            String string3 = this.getValue(method, this.fillLookup(string));
            return this.format(string3, objectArray);
        }
        return null;
    }

    public String getValue(Method method, ArrayList<TranslateResource> arrayList) {
        String string = null;
        for (TranslateResource translateResource : arrayList) {
            try {
                string = translateResource.getEntry(method);
                if (string == null) continue;
                return string;
            }
            catch (Throwable throwable) {
                Log.L.warning("Exception in translation: " + this.tInterface.getName() + "." + translateResource.getName());
                Log.exception(Level.WARNING, throwable);
            }
        }
        if (string == null) {
            string = this.tInterface.getSimpleName() + "." + method.getName();
        }
        return string;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        ArrayList<TranslateResource> arrayList = this.lookup;
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, objectArray);
        }
        if (method.getName().equals("_getHandler")) {
            return this;
        }
        String string = this.cache.get(method);
        if (string == null && (string = this.getValue(method, arrayList)) != null) {
            this.cache.put(method, string);
        }
        return this.format(string, objectArray);
    }

    public void setLanguage(String string) {
        this.cache.clear();
        this.resourceCache.clear();
        this.lookup = this.fillLookup(string);
    }
}

