/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson.mapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import org.appwork.storage.simplejson.Ignore;
import org.appwork.storage.simplejson.Ignores;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.utils.logging.Log;

public class ClassCache {
    private static final HashMap<Class<?>, ClassCache> CACHE = new HashMap();
    private static final Object[] EMPTY_OBJECT = new Object[0];
    private static final Class<?>[] EMPTY_TYPES = new Class[0];
    protected Constructor<? extends Object> constructor;
    protected final Class<? extends Object> clazz;
    protected final ArrayList<Getter> getter;
    protected final ArrayList<Setter> setter;
    protected final HashMap<String, Getter> getterMap;
    protected final HashMap<String, Setter> setterMap;

    protected static ClassCache create(Class<? extends Object> clazz) throws SecurityException, NoSuchMethodException {
        Object object;
        ClassCache classCache = new ClassCache(clazz);
        Class<? extends Object> clazz2 = clazz;
        HashSet<Object> hashSet = new HashSet<Object>();
        do {
            if ((object = clazz2.getAnnotation(Ignores.class)) != null) {
                for (String securityException : object.value()) {
                    hashSet.add(securityException);
                }
            }
            Object[] objectArray = clazz2.getDeclaredMethods();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Getter getter;
                Object object2 = objectArray[i];
                if (((Method)object2).getAnnotation(Ignore.class) != null || hashSet.contains(((Method)object2).toString())) continue;
                if (((Method)object2).getName().startsWith("get") && ((Method)object2).getParameterTypes().length == 0 && ((Method)object2).getReturnType() != Void.TYPE) {
                    getter = new Getter(ClassCache.createKey(((Method)object2).getName().substring(3)), (Method)object2);
                    classCache.getter.add(getter);
                    classCache.getterMap.put(getter.getKey(), getter);
                    continue;
                }
                if (((Method)object2).getName().startsWith("is") && ((Method)object2).getParameterTypes().length == 0 && ((Method)object2).getReturnType() != Void.TYPE) {
                    getter = new Getter(ClassCache.createKey(((Method)object2).getName().substring(2)), (Method)object2);
                    classCache.getter.add(getter);
                    classCache.getterMap.put(getter.getKey(), getter);
                    continue;
                }
                if (!((Method)object2).getName().startsWith("set") || ((Method)object2).getParameterTypes().length != 1) continue;
                Setter setter = new Setter(ClassCache.createKey(((Method)object2).getName().substring(3)), (Method)object2);
                classCache.setter.add(setter);
                classCache.setterMap.put(setter.getKey(), setter);
            }
        } while ((clazz2 = clazz2.getSuperclass()) != null && clazz2 != Object.class);
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            try {
                constructor.setAccessible(true);
                classCache.constructor = constructor;
            }
            catch (SecurityException securityException) {
                Log.exception(Level.WARNING, securityException);
            }
            break;
        }
        if (classCache.constructor == null) {
            object = clazz.getPackage().getName();
            if (((String)object).startsWith("java") || ((String)object).startsWith("sun.")) {
                Log.L.warning("No Null Constructor in " + clazz + " found. De-Json-serial will fail");
            } else {
                throw new NoSuchMethodException(" Class " + clazz + " requires a null constructor. please add private " + clazz.getSimpleName() + "(){}");
            }
        }
        return classCache;
    }

    private static String createKey(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        boolean bl = true;
        for (int i = 0; i < cArray.length; ++i) {
            if (bl && Character.isUpperCase(cArray[i])) {
                stringBuilder.append(Character.toLowerCase(cArray[i]));
                continue;
            }
            bl = false;
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }

    public static ClassCache getClassCache(Class<? extends Object> clazz) throws SecurityException, NoSuchMethodException {
        ClassCache classCache = CACHE.get(clazz);
        if (classCache == null) {
            classCache = ClassCache.create(clazz);
            CACHE.put(clazz, classCache);
        }
        return classCache;
    }

    protected ClassCache(Class<? extends Object> clazz) {
        this.clazz = clazz;
        this.getter = new ArrayList();
        this.setter = new ArrayList();
        this.getterMap = new HashMap();
        this.setterMap = new HashMap();
    }

    public ArrayList<Getter> getGetter() {
        return this.getter;
    }

    public Getter getGetter(String string) {
        return this.getterMap.get(string);
    }

    public Object getInstance() throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.constructor.newInstance(EMPTY_OBJECT);
    }

    public ArrayList<Setter> getSetter() {
        return this.setter;
    }

    public Setter getSetter(String string) {
        return this.setterMap.get(string);
    }

    public static void put(Class<?> clazz, ClassCache classCache) {
        CACHE.put(clazz, classCache);
    }
}

