/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.JsonKeyValueStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.InterfaceParseException;
import org.appwork.storage.config.MethodHandler;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.AbstractValidator;
import org.appwork.storage.config.annotations.AllowStorage;
import org.appwork.storage.config.annotations.CryptedStorage;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultJsonObject;
import org.appwork.storage.config.annotations.Description;
import org.appwork.storage.config.annotations.PlainStorage;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.ValidatorFactory;
import org.appwork.storage.config.events.ConfigEvent;
import org.appwork.storage.config.events.ConfigEventSender;
import org.appwork.storage.config.handler.ListHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.reflection.Clazz;

public abstract class KeyHandler<RawClass> {
    private static final String ANNOTATION_PACKAGE_NAME = CryptedStorage.class.getPackage().getName();
    private static final String PACKAGE_NAME = PlainStorage.class.getPackage().getName();
    private final String key;
    private MethodHandler getter;
    protected MethodHandler setter;
    protected final StorageHandler<?> storageHandler;
    private boolean primitive;
    protected RawClass defaultValue;
    protected boolean crypted;
    protected byte[] cryptKey;
    protected JsonKeyValueStorage primitiveStorage;
    private ConfigEventSender<RawClass> eventSender;
    private AbstractValidator<RawClass> validatorFactory;

    protected KeyHandler(StorageHandler<?> storageHandler, String string) {
        this.storageHandler = storageHandler;
        this.key = string;
        this.crypted = storageHandler.isCrypted();
        this.cryptKey = storageHandler.getKey();
        this.primitiveStorage = storageHandler.primitiveStorage;
    }

    protected void checkBadAnnotations(Class<? extends Annotation> ... classArray) {
        int n = 0;
        if (this.getAnnotation(this.getDefaultAnnotation()) != null) {
            ++n;
        }
        if (this.getAnnotation(DefaultJsonObject.class) != null) {
            ++n;
        }
        if (this.getAnnotation(DefaultFactory.class) != null) {
            ++n;
        }
        if (n > 1) {
            throw new InterfaceParseException("Make sure that you use only one  of getDefaultAnnotation,DefaultObjectValue or DefaultValue ");
        }
        this.checkBadAnnotations(this.getter.getMethod(), classArray);
        if (this.setter != null) {
            this.checkBadAnnotations(this.setter.getMethod(), classArray);
        }
    }

    private void checkBadAnnotations(Method method, Class<? extends Annotation> ... classArray) {
        Class[] classArray2 = new Class[]{ValidatorFactory.class, DefaultJsonObject.class, DefaultFactory.class, AboutConfig.class, RequiresRestart.class, AllowStorage.class, Description.class, CryptedStorage.class, PlainStorage.class};
        Class[] classArray3 = new Class[classArray.length + classArray2.length];
        System.arraycopy(classArray, 0, classArray3, 0, classArray.length);
        System.arraycopy(classArray2, 0, classArray3, classArray.length, classArray2.length);
        block0: for (Annotation annotation : method.getAnnotations()) {
            String string;
            if (annotation == null || !(string = annotation.annotationType().getName()).startsWith(PACKAGE_NAME) || this.getDefaultAnnotation() != null && this.getDefaultAnnotation().isAssignableFrom(annotation.getClass())) continue;
            for (Class clazz : classArray3) {
                if (clazz.isAssignableFrom(annotation.getClass())) continue block0;
            }
            throw new InterfaceParseException("Bad Annotation: " + annotation + " for " + method);
        }
    }

    private void fireEvent(ConfigEvent.Types types, KeyHandler<?> keyHandler, Object object) {
        this.storageHandler.fireEvent(types, keyHandler, object);
        if (this.eventSender != null) {
            this.eventSender.fireEvent(new ConfigEvent(types, this, object));
        }
    }

    protected Class<? extends Annotation>[] getAllowedAnnotations() {
        return new Class[0];
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        T t = this.getter.getMethod().getAnnotation(clazz);
        if (t == null && this.setter != null) {
            t = this.setter.getMethod().getAnnotation(clazz);
        } else if (this.setter != null && this.setter.getMethod().getAnnotation(clazz) != null && ANNOTATION_PACKAGE_NAME.equals(clazz.getPackage().getName())) {
            throw new InterfaceParseException("Dupe Annotation in  " + this + " (" + clazz + ")");
        }
        return t;
    }

    public Class<?> getDeclaringClass() {
        if (this.getter != null) {
            return this.getter.getMethod().getDeclaringClass();
        }
        return this.setter.getMethod().getDeclaringClass();
    }

    protected Class<? extends Annotation> getDefaultAnnotation() {
        return null;
    }

    public RawClass getDefaultValue() {
        try {
            DefaultFactory defaultFactory = this.getAnnotation(DefaultFactory.class);
            if (defaultFactory != null) {
                return (RawClass)defaultFactory.value().newInstance().getDefaultValue();
            }
            DefaultJsonObject defaultJsonObject = this.getAnnotation(DefaultJsonObject.class);
            if (defaultJsonObject != null) {
                return JSonStorage.restoreFromString(defaultJsonObject.value(), new TypeRef<Object>(this.getRawClass()){}, null);
            }
            Annotation annotation = this.getAnnotation(this.getDefaultAnnotation());
            if (annotation != null) {
                return (RawClass)annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            return this.defaultValue;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public synchronized ConfigEventSender<RawClass> getEventSender() {
        if (this.eventSender == null) {
            this.eventSender = new ConfigEventSender();
        }
        return this.eventSender;
    }

    public MethodHandler getGetter() {
        return this.getter;
    }

    public String getKey() {
        return this.key;
    }

    public Class<RawClass> getRawClass() {
        return this.getter.getRawClass();
    }

    public MethodHandler getSetter() {
        return this.setter;
    }

    public StorageHandler<?> getStorageHandler() {
        return this.storageHandler;
    }

    public RawClass getValue() {
        if (this.primitiveStorage.hasProperty(this.getKey())) {
            return this.primitiveStorage.get(this.getKey(), this.defaultValue);
        }
        return this.primitiveStorage.get(this.getKey(), this.getDefaultValue());
    }

    protected void init() throws Throwable {
        PlainStorage plainStorage;
        this.primitive = JSonStorage.canStorePrimitive(this.getter.getMethod().getReturnType());
        CryptedStorage cryptedStorage = this.getAnnotation(CryptedStorage.class);
        this.crypted = this.storageHandler.isCrypted();
        this.cryptKey = this.storageHandler.getCryptKey();
        if (cryptedStorage != null) {
            if (this.storageHandler.isCrypted()) {
                throw new InterfaceParseException("No reason to mark " + this + " as @CryptedStorage. Parent is already CryptedStorage");
            }
            if (!(this instanceof ListHandler)) {
                throw new InterfaceParseException(this + " Cannot set @CryptedStorage on primitive fields. Use an object, or an extra plain config interface");
            }
            this.crypted = true;
            this.validateEncryptionKey(cryptedStorage.key());
            this.cryptKey = cryptedStorage.key();
        }
        if ((plainStorage = this.getAnnotation(PlainStorage.class)) != null) {
            if (cryptedStorage != null) {
                throw new InterfaceParseException("Cannot Set CryptStorage and PlainStorage Annotation in " + this);
            }
            if (!this.storageHandler.isCrypted()) {
                throw new InterfaceParseException("No reason to mark " + this + " as @PlainStorage. Parent is already Plain");
            }
            if (!(this instanceof ListHandler)) {
                throw new InterfaceParseException(this + " Cannot set @PlainStorage on primitive fields. Use an object, or an extra plain config interface");
            }
            this.crypted = false;
        }
        try {
            this.validatorFactory = this.getAnnotation(ValidatorFactory.class).value().newInstance();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.checkBadAnnotations(this.getAllowedAnnotations());
        this.initDefaults();
        this.initHandler();
    }

    protected void initDefaults() throws Throwable {
        this.defaultValue = null;
    }

    protected abstract void initHandler() throws Throwable;

    public boolean isChildOf(ConfigInterface configInterface) {
        return configInterface.getStorageHandler() == this.getStorageHandler();
    }

    protected boolean isCrypted() {
        return this.crypted;
    }

    protected boolean isGetter(Method method) {
        return method.equals(this.getter.getMethod());
    }

    protected boolean isPrimitive() {
        return this.primitive;
    }

    protected abstract void putValue(RawClass var1);

    public void setDefaultValue(RawClass RawClass) {
        this.defaultValue = RawClass;
    }

    protected void setGetter(MethodHandler methodHandler) {
        this.getter = methodHandler;
    }

    protected void setSetter(MethodHandler methodHandler) {
        this.setter = methodHandler;
    }

    public void setValue(RawClass RawClass) throws ValidationException {
        try {
            RawClass RawClass2 = this.getValue();
            if (RawClass2 == null && RawClass == null) {
                return;
            }
            boolean bl = false;
            if (RawClass != null && RawClass2 == null) {
                bl = true;
            } else if (RawClass2 != null && RawClass == null) {
                bl = true;
            } else if (!Clazz.isPrimitive(this.getRawClass())) {
                bl = true;
            } else if (!RawClass.equals(RawClass2)) {
                bl = true;
            }
            if (!bl) {
                return;
            }
            if (this.validatorFactory != null) {
                this.validatorFactory.validate(RawClass);
            }
            this.validateValue(RawClass);
            this.putValue(RawClass);
            this.fireEvent(ConfigEvent.Types.VALUE_UPDATED, this, RawClass);
        }
        catch (ValidationException validationException) {
            validationException.setValue(RawClass);
            this.fireEvent(ConfigEvent.Types.VALIDATOR_ERROR, this, validationException);
            throw validationException;
        }
        catch (Throwable throwable) {
            ValidationException validationException = new ValidationException(throwable);
            validationException.setValue(RawClass);
            this.fireEvent(ConfigEvent.Types.VALIDATOR_ERROR, this, validationException);
            throw validationException;
        }
    }

    public String toString() {
        RawClass RawClass = this.getValue();
        return RawClass == null ? null : RawClass.toString();
    }

    public void validateEncryptionKey(byte[] byArray) {
        if (byArray == null) {
            throw new InterfaceParseException("Key missing in " + this);
        }
        if (byArray.length != JSonStorage.KEY.length) {
            throw new InterfaceParseException("Crypt key for " + this + " is invalid. required length: " + JSonStorage.KEY.length);
        }
    }

    protected abstract void validateValue(RawClass var1) throws Throwable;
}

