/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.annotations.Description;
import org.appwork.storage.config.handler.KeyHandler;

public class ConfigUtils {
    public static void printStaticMappings(Class<? extends ConfigInterface> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        System.err.println(clazz);
        System.err.flush();
        stringBuilder.append("\r\n");
        stringBuilder.append("//Static Mappings for " + clazz);
        stringBuilder.append("\r\n");
        stringBuilder.append("public static final " + clazz.getSimpleName() + "                 CFG                               = JsonConfig.create(" + clazz.getSimpleName() + ".class);");
        stringBuilder.append("\r\n");
        stringBuilder.append("public static final StorageHandler<" + clazz.getSimpleName() + ">                 SH                               = (StorageHandler<" + clazz.getSimpleName() + ">) CFG.getStorageHandler();");
        stringBuilder.append("\r\n");
        stringBuilder.append("//let's do this mapping here. If we map all methods to static handlers, access is faster, and we get an error on init if mappings are wrong.");
        HashSet hashSet = new HashSet();
        HashMap<Method, KeyHandler<?>> hashMap = JsonConfig.create(clazz).getStorageHandler().getMap();
        for (KeyHandler<?> keyHandler : hashMap.values()) {
            if (!hashSet.add(keyHandler)) continue;
            stringBuilder.append("\r\n");
            stringBuilder.append("// " + keyHandler);
            String string = keyHandler.getGetter().getMethod().getName().startsWith("is") ? keyHandler.getGetter().getMethod().getName().substring(2) : keyHandler.getGetter().getMethod().getName().substring(3);
            StringBuilder stringBuilder2 = new StringBuilder();
            char c = ' ';
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (stringBuilder2.length() > 0 && Character.isUpperCase(c2) && Character.isLowerCase(c)) {
                    stringBuilder2.append('_');
                }
                stringBuilder2.append(Character.toUpperCase(c2));
                c = c2;
            }
            if (keyHandler.getAnnotation(Description.class) != null) {
                stringBuilder.append("\r\n");
                stringBuilder.append("/**");
                stringBuilder.append("\r\n");
                stringBuilder.append(" * " + keyHandler.getAnnotation(Description.class).value());
                stringBuilder.append("\r\n");
                stringBuilder.append("**/");
            }
            stringBuilder.append("\r\n");
            stringBuilder.append("public static final " + keyHandler.getClass().getSimpleName() + " " + stringBuilder2 + " = SH.getKeyHandler(\"" + string + "\", " + keyHandler.getClass().getSimpleName() + ".class);");
        }
        System.err.println("=======================");
        System.err.flush();
    }
}

