/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import org.appwork.storage.StorageEvent;
import org.appwork.storage.StorageException;
import org.appwork.utils.event.DefaultEventSender;

public abstract class Storage {
    private DefaultEventSender<StorageEvent<?>> eventSender;

    public abstract void clear() throws StorageException;

    public abstract void close();

    public abstract <E> E get(String var1, E var2) throws StorageException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultEventSender<StorageEvent<?>> getEventSender() {
        if (this.eventSender != null) {
            return this.eventSender;
        }
        Storage storage = this;
        synchronized (storage) {
            if (this.eventSender != null) {
                return this.eventSender;
            }
            this.eventSender = new DefaultEventSender();
        }
        return this.eventSender;
    }

    public abstract String getID();

    public boolean hasEventSender() {
        return this.eventSender != null;
    }

    public abstract boolean hasProperty(String var1);

    public abstract void put(String var1, Boolean var2) throws StorageException;

    public abstract void put(String var1, Byte var2) throws StorageException;

    public abstract void put(String var1, Double var2) throws StorageException;

    public abstract void put(String var1, Enum<?> var2) throws StorageException;

    public abstract void put(String var1, Float var2) throws StorageException;

    public abstract void put(String var1, Integer var2) throws StorageException;

    public abstract void put(String var1, Long var2) throws StorageException;

    public abstract void put(String var1, String var2) throws StorageException;

    public abstract Object remove(String var1);

    public abstract void save() throws StorageException;

    public abstract int size();
}

