/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.scheduler;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class DelayedRunnable
implements Runnable {
    private final ScheduledExecutorService service;
    private final long delayInMS;
    private long nextDelay;
    private volatile long lastRunRequest = 0L;
    private volatile long firstRunRequest = 0L;
    private ScheduledFuture<?> delayer;
    private final long maxInMS;

    public DelayedRunnable(ScheduledExecutorService scheduledExecutorService, long l) {
        this(scheduledExecutorService, l, -1L);
    }

    public DelayedRunnable(ScheduledExecutorService scheduledExecutorService, long l, long l2) {
        this.service = scheduledExecutorService;
        this.nextDelay = this.delayInMS = l;
        this.maxInMS = l2;
        if (this.delayInMS <= 0L) {
            throw new IllegalArgumentException("minDelay must be >=0");
        }
        if (this.maxInMS == 0L) {
            throw new IllegalArgumentException("maxDelay must be !=0");
        }
    }

    public abstract void delayedrun();

    public void resetAndStart() {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DelayedRunnable delayedRunnable = this;
        synchronized (delayedRunnable) {
            this.lastRunRequest = System.currentTimeMillis();
            if (this.delayer == null) {
                if (this.firstRunRequest == 0L) {
                    this.firstRunRequest = System.currentTimeMillis();
                }
                this.delayer = this.service.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean bl = false;
                        DelayedRunnable delayedRunnable = DelayedRunnable.this;
                        synchronized (delayedRunnable) {
                            boolean bl2;
                            long l = System.currentTimeMillis() - DelayedRunnable.this.lastRunRequest;
                            boolean bl3 = bl2 = l >= DelayedRunnable.this.nextDelay;
                            if (DelayedRunnable.this.maxInMS > 0L) {
                                if (System.currentTimeMillis() - DelayedRunnable.this.firstRunRequest > DelayedRunnable.this.maxInMS) {
                                    bl2 = true;
                                } else {
                                    DelayedRunnable.this.nextDelay = Math.max(DelayedRunnable.this.maxInMS - (System.currentTimeMillis() - DelayedRunnable.this.firstRunRequest), 10L);
                                }
                            }
                            DelayedRunnable.this.delayer = null;
                            if (bl2) {
                                bl = true;
                                DelayedRunnable.this.firstRunRequest = System.currentTimeMillis();
                                DelayedRunnable.this.nextDelay = DelayedRunnable.this.delayInMS;
                            } else {
                                DelayedRunnable.this.nextDelay = DelayedRunnable.this.delayInMS - l;
                                bl = false;
                                DelayedRunnable.this.run();
                            }
                        }
                        if (bl) {
                            DelayedRunnable.this.delayedrun();
                        } else {
                            DelayedRunnable.this.run();
                        }
                    }
                }, this.nextDelay, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        DelayedRunnable delayedRunnable = this;
        synchronized (delayedRunnable) {
            if (this.delayer != null) {
                this.delayer.cancel(false);
                this.delayer = null;
            }
        }
    }
}

