/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.util.HashMap;
import java.util.Map;
import jd.controlling.JDLogger;
import org.appwork.utils.Regex;

public class JDGeoCode {
    public static final HashMap<String, String[]> LANGUAGES = new HashMap();
    public static final HashMap<String, String> COUNTRIES;
    public static final HashMap<String, String> EXTENSIONS;

    public static String getCountryCode(String string) {
        for (Map.Entry<String, String> entry : COUNTRIES.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(string)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getExtensionCode(String string) {
        for (Map.Entry<String, String> entry : EXTENSIONS.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(string)) continue;
            return entry.getKey();
        }
        return string;
    }

    public static String getLanguageCode(String string) {
        for (Map.Entry<String, String[]> entry : LANGUAGES.entrySet()) {
            if (!entry.getValue()[0].equalsIgnoreCase(string) && !entry.getValue()[1].equalsIgnoreCase(string)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getNativeLanguage(String string) {
        String[] stringArray = LANGUAGES.get(string);
        return stringArray == null ? null : stringArray[1];
    }

    public static String longToShort(String string) {
        String[] stringArray = new Regex(string, "(.*?)\\[(.*)\\|(.*?)\\]").getRow(0);
        if (stringArray != null) {
            return JDGeoCode.getLanguageCode(stringArray[0].trim()) + "-" + JDGeoCode.getCountryCode(stringArray[1].trim()) + "-" + JDGeoCode.getExtensionCode(stringArray[2].trim());
        }
        stringArray = new Regex(string, "(.*?)\\[(.*)\\]").getRow(0);
        if (stringArray != null) {
            String string2 = JDGeoCode.getCountryCode(stringArray[1].trim());
            return JDGeoCode.getLanguageCode(stringArray[0].trim()) + "-" + (string2 != null ? string2 : JDGeoCode.getExtensionCode(stringArray[1].trim()));
        }
        return JDGeoCode.getLanguageCode(string.trim());
    }

    public static String[] parseLanguageCode(String string) {
        String[] stringArray = string.split("\\-");
        if (stringArray.length == 1) {
            String[] stringArray2;
            String string2 = string.toLowerCase().trim();
            if (string2.length() != 2) {
                stringArray2 = null;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = string;
                stringArray3[1] = null;
                stringArray2 = stringArray3;
                stringArray3[2] = null;
            }
            return stringArray2;
        }
        if (stringArray.length == 2) {
            boolean bl = COUNTRIES.containsKey(stringArray[1].toUpperCase());
            if (stringArray[0].trim().length() != 2) {
                return null;
            }
            return new String[]{stringArray[0].toLowerCase(), bl ? stringArray[1].toUpperCase() : null, bl ? null : stringArray[1]};
        }
        stringArray = string.split("\\-");
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        if (string3.trim().length() != 2) {
            return null;
        }
        if (string4.trim().length() != 2) {
            return null;
        }
        return new String[]{string3.toLowerCase(), string4.toUpperCase(), stringArray[2]};
    }

    public static String toLonger(String string) {
        String[] stringArray = JDGeoCode.parseLanguageCode(string);
        if (stringArray == null) {
            return null;
        }
        String string2 = LANGUAGES.get(stringArray[0])[0];
        String string3 = COUNTRIES.get(stringArray[1]);
        String string4 = EXTENSIONS.get(stringArray[2]);
        if (string4 == null) {
            string4 = stringArray[2];
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        if (string3 != null) {
            stringBuilder.append(" [" + string3);
            if (string4 != null) {
                stringBuilder.append(" | " + string4);
            }
            stringBuilder.append("]");
        } else if (string4 != null) {
            stringBuilder.append(" [" + string4 + "]");
        }
        return stringBuilder.toString();
    }

    public static String toLongerNative(String string) {
        String[] stringArray = JDGeoCode.parseLanguageCode(string);
        try {
            String string2 = LANGUAGES.get(stringArray[0])[1];
            String string3 = COUNTRIES.get(stringArray[1]);
            String string4 = EXTENSIONS.get(stringArray[2]);
            if (string4 == null) {
                string4 = stringArray[2];
            }
            StringBuilder stringBuilder = new StringBuilder(string2);
            if (string3 != null) {
                stringBuilder.append(" [" + string3);
                if (string4 != null) {
                    stringBuilder.append(" | " + string4);
                }
                stringBuilder.append("]");
            } else if (string4 != null) {
                stringBuilder.append(" [" + string4 + "]");
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            JDLogger.getLogger().severe("Bad languagecode: " + string);
            return JDGeoCode.toLongerNative("en");
        }
    }

    static {
        LANGUAGES.put("aa", new String[]{"Afar", "Afaraf"});
        LANGUAGES.put("ab", new String[]{"Abkhazian", "\u00d0\u0090\u00d2\u00a7\u00d1\u0081\u00d1\u0083\u00d0\u00b0"});
        LANGUAGES.put("ae", new String[]{"Avestan", "avesta"});
        LANGUAGES.put("af", new String[]{"Afrikaans", "Afrikaans"});
        LANGUAGES.put("ak", new String[]{"Akan", "Akan"});
        LANGUAGES.put("am", new String[]{"Amharic", "\u00e1\u008a\u00a0\u00e1\u0088\u009b\u00e1\u0088\u00ad\u00e1\u008a\u009b"});
        LANGUAGES.put("an", new String[]{"Aragonese", "Aragon\u00c3\u00a9s"});
        LANGUAGES.put("ar", new String[]{"Arabic", "\u00d8\u00a7\u00d9\u0084\u00d8\u00b9\u00d8\u00b1\u00d8\u00a8\u00d9\u008a\u00d8\u00a9"});
        LANGUAGES.put("av", new String[]{"Avaric", "\u00d0\u00b0\u00d0\u00b2\u00d0\u00b0\u00d1\u0080 \u00d0\u00bc\u00d0\u00b0\u00d1\u0086\u00d3\u0080; \u00d0\u00bc\u00d0\u00b0\u00d0\u00b3\u00d3\u0080\u00d0\u00b0\u00d1\u0080\u00d1\u0083\u00d0\u00bb \u00d0\u00bc\u00d0\u00b0\u00d1\u0086\u00d3\u0080"});
        LANGUAGES.put("ay", new String[]{"Aymara", "aymar aru"});
        LANGUAGES.put("az", new String[]{"Azerbaijani", "az\u00c9\u0099rbaycan dili"});
        LANGUAGES.put("ba", new String[]{"Bashkir", "\u00d0\u00b1\u00d0\u00b0\u00d1\u0088\u00d2\u00a1\u00d0\u00be\u00d1\u0080\u00d1\u0082 \u00d1\u0082\u00d0\u00b5\u00d0\u00bb\u00d0\u00b5"});
        LANGUAGES.put("be", new String[]{"Belarusian", "\u00d0\u0091\u00d0\u00b5\u00d0\u00bb\u00d0\u00b0\u00d1\u0080\u00d1\u0083\u00d1\u0081\u00d0\u00ba\u00d0\u00b0\u00d1\u008f"});
        LANGUAGES.put("bg", new String[]{"Bulgarian", "\u00d0\u00b1\u00d1\u008a\u00d0\u00bb\u00d0\u00b3\u00d0\u00b0\u00d1\u0080\u00d1\u0081\u00d0\u00ba\u00d0\u00b8 \u00d0\u00b5\u00d0\u00b7\u00d0\u00b8\u00d0\u00ba"});
        LANGUAGES.put("bh", new String[]{"Bihari", "\u00e0\u00a4\u00ad\u00e0\u00a5\u008b\u00e0\u00a4\u009c\u00e0\u00a4\u00aa\u00e0\u00a5\u0081\u00e0\u00a4\u00b0\u00e0\u00a5\u0080"});
        LANGUAGES.put("bm", new String[]{"Bambara", "bamanankan"});
        LANGUAGES.put("bn", new String[]{"Bengali", "\u00e0\u00a6\u00ac\u00e0\u00a6\u00be\u00e0\u00a6\u0082\u00e0\u00a6\u00b2\u00e0\u00a6\u00be"});
        LANGUAGES.put("bo", new String[]{"Tibetan", "\u00e0\u00bd\u0096\u00e0\u00bd\u00bc\u00e0\u00bd\u0091\u00e0\u00bc\u008b\u00e0\u00bd\u00a1\u00e0\u00bd\u00b2\u00e0\u00bd\u0082"});
        LANGUAGES.put("br", new String[]{"Breton", "brezhoneg"});
        LANGUAGES.put("bs", new String[]{"Bosnian", "bosanski jezik"});
        LANGUAGES.put("ca", new String[]{"Catalan", "Catal\u00c3\u00a0"});
        LANGUAGES.put("ch", new String[]{"Chamorro", "Chamoru"});
        LANGUAGES.put("co", new String[]{"Corsican", "corsu; lingua corsa"});
        LANGUAGES.put("cr", new String[]{"Cree", "\u00e1\u0093\u0080\u00e1\u0090\u00a6\u00e1\u0090\u0083\u00e1\u0094\u00ad\u00e1\u0090\u008d\u00e1\u0090\u008f\u00e1\u0090\u00a3"});
        LANGUAGES.put("cs", new String[]{"Czech", "\u00c4\u008desky; \u00c4\u008de\u00c5\u00a1tina"});
        LANGUAGES.put("cu", new String[]{"Church Slavic", "\u00d1\u00a9\u00d0\u00b7\u00d1\u008b\u00d0\u00ba\u00d1\u008a \u00d1\u0081\u00d0\u00bb\u00d0\u00be\u00d0\u00b2\u00d1\u00a3\u00d0\u00bd\u00d1\u008c\u00d1\u0081\u00d0\u00ba\u00d1\u008a"});
        LANGUAGES.put("cv", new String[]{"Chuvash", "\u00d1\u0087\u00d3\u0091\u00d0\u00b2\u00d0\u00b0\u00d1\u0088 \u00d1\u0087\u00d3\u0097\u00d0\u00bb\u00d1\u0085\u00d0\u00b8"});
        LANGUAGES.put("cy", new String[]{"Welsh", "Cymraeg"});
        LANGUAGES.put("da", new String[]{"Danish", "dansk"});
        LANGUAGES.put("de", new String[]{"German", "Deutsch"});
        LANGUAGES.put("dv", new String[]{"Divehi", "\u00de\u008b\u00de\u00a8\u00de\u0088\u00de\u00ac\u00de\u0080\u00de\u00a8"});
        LANGUAGES.put("dz", new String[]{"Dzongkha", "\u00e0\u00bd\u00a2\u00e0\u00be\u00ab\u00e0\u00bd\u00bc\u00e0\u00bd\u0084\u00e0\u00bc\u008b\u00e0\u00bd\u0081"});
        LANGUAGES.put("ee", new String[]{"Ewe", "\u00c6\u0090\u00ca\u008b\u00c9\u009bgb\u00c9\u009b"});
        LANGUAGES.put("el", new String[]{"Greek", "\u00ce\u0095\u00ce\u00bb\u00ce\u00bb\u00ce\u00b7\u00ce\u00bd\u00ce\u00b9\u00ce\u00ba\u00ce\u00ac"});
        LANGUAGES.put("en", new String[]{"English", "English"});
        LANGUAGES.put("eo", new String[]{"Esperanto", "Esperanto"});
        LANGUAGES.put("es", new String[]{"Spanish", "Espa\u00c3\u00b1ol"});
        LANGUAGES.put("et", new String[]{"Estonian", "eesti; eesti keel"});
        LANGUAGES.put("eu", new String[]{"Basque", "euskara; euskera"});
        LANGUAGES.put("fa", new String[]{"Persian", "\u00d9\u0081\u00d8\u00a7\u00d8\u00b1\u00d8\u00b3\u00db\u008c"});
        LANGUAGES.put("ff", new String[]{"Fulah", "Fulfulde"});
        LANGUAGES.put("fi", new String[]{"Finnish", "suomi; suomen kieli"});
        LANGUAGES.put("fj", new String[]{"Fijian", "vosa Vakaviti"});
        LANGUAGES.put("fo", new String[]{"Faroese", "F\u00c3\u00b8royskt"});
        LANGUAGES.put("fr", new String[]{"French", "Fran\u00c3\u00a7ais; langue fran\u00c3\u00a7aise"});
        LANGUAGES.put("fy", new String[]{"Western Frisian", "Frysk"});
        LANGUAGES.put("ga", new String[]{"Irish", "Gaeilge"});
        LANGUAGES.put("gd", new String[]{"Scottish Gaelic", "G\u00c3\u00a0idhlig"});
        LANGUAGES.put("gl", new String[]{"Galician", "Galego"});
        LANGUAGES.put("gn", new String[]{"Guaran\u00c3\u00ad", "Ava\u00c3\u00b1e'\u00e1\u00ba\u00bd"});
        LANGUAGES.put("gu", new String[]{"Gujarati", "\u00e0\u00aa\u0097\u00e0\u00ab\u0081\u00e0\u00aa\u009c\u00e0\u00aa\u00b0\u00e0\u00aa\u00be\u00e0\u00aa\u00a4\u00e0\u00ab\u0080"});
        LANGUAGES.put("gv", new String[]{"Manx", "Gaelg; Gailck"});
        LANGUAGES.put("ha", new String[]{"Hausa", "\u00d9\u0087\u00d9\u008e\u00d9\u0088\u00d9\u008f\u00d8\u00b3\u00d9\u008e"});
        LANGUAGES.put("he", new String[]{"Hebrew", "\u00d7\u00a2\u00d7\u0091\u00d7\u00a8\u00d7\u0099\u00d7\u00aa"});
        LANGUAGES.put("hi", new String[]{"Hindi", "\u00e0\u00a4\u00b9\u00e0\u00a4\u00bf\u00e0\u00a4\u00a8\u00e0\u00a5\u008d\u00e0\u00a4\u00a6\u00e0\u00a5\u0080; \u00e0\u00a4\u00b9\u00e0\u00a4\u00bf\u00e0\u00a4\u0082\u00e0\u00a4\u00a6\u00e0\u00a5\u0080"});
        LANGUAGES.put("ho", new String[]{"Hiri Motu", "Hiri Motu"});
        LANGUAGES.put("hr", new String[]{"Croatian", "Hrvatski"});
        LANGUAGES.put("ht", new String[]{"Haitian", "Krey\u00c3\u00b2l ayisyen"});
        LANGUAGES.put("hu", new String[]{"Hungarian", "Magyar"});
        LANGUAGES.put("hy", new String[]{"Armenian", "\u00d5\u0080\u00d5\u00a1\u00d5\u00b5\u00d5\u00a5\u00d6\u0080\u00d5\u00a5\u00d5\u00b6"});
        LANGUAGES.put("hz", new String[]{"Herero", "Otjiherero"});
        LANGUAGES.put("ia", new String[]{"Interlingua (International Auxiliary Language Association)", "Interlingua"});
        LANGUAGES.put("id", new String[]{"Indonesian", "Bahasa Indonesia"});
        LANGUAGES.put("ie", new String[]{"Interlingue", "Interlingue"});
        LANGUAGES.put("ig", new String[]{"Igbo", "Igbo"});
        LANGUAGES.put("ii", new String[]{"Sichuan Yi", "\u00ea\u0086\u0087\u00ea\u0089\u0099"});
        LANGUAGES.put("ik", new String[]{"Inupiaq", "I\u00c3\u00b1upiaq; I\u00c3\u00b1upiatun"});
        LANGUAGES.put("io", new String[]{"Ido", "Ido"});
        LANGUAGES.put("is", new String[]{"Icelandic", "\u00c3\u008dslenska"});
        LANGUAGES.put("it", new String[]{"Italian", "Italiano"});
        LANGUAGES.put("iu", new String[]{"Inuktitut", "\u00e1\u0090\u0083\u00e1\u0093\u0084\u00e1\u0092\u0083\u00e1\u0091\u008e\u00e1\u0091\u0090\u00e1\u0091\u00a6"});
        LANGUAGES.put("ja", new String[]{"Japanese", "Nihongo"});
        LANGUAGES.put("ka", new String[]{"Georgian", "\u00e1\u0083\u00a5\u00e1\u0083\u0090\u00e1\u0083\u00a0\u00e1\u0083\u0097\u00e1\u0083\u00a3\u00e1\u0083\u009a\u00e1\u0083\u0098"});
        LANGUAGES.put("kg", new String[]{"Kongo", "KiKongo"});
        LANGUAGES.put("ki", new String[]{"Kikuyu", "G\u00c4\u00a9k\u00c5\u00a9y\u00c5\u00a9"});
        LANGUAGES.put("kj", new String[]{"Kwanyama", "Kuanyama"});
        LANGUAGES.put("ku", new String[]{"Kurdish", "\u00d9\u0083\u00d9\u0088\u00d8\u00b1\u00d8\u00af\u00db\u008c"});
        LANGUAGES.put("kk", new String[]{"Kazakh", "\u00d2\u009a\u00d0\u00b0\u00d0\u00b7\u00d0\u00b0\u00d2\u009b \u00d1\u0082\u00d1\u0096\u00d0\u00bb\u00d1\u0096"});
        LANGUAGES.put("kl", new String[]{"Kalaallisut", "kalaallisut; kalaallit oqaasii"});
        LANGUAGES.put("km", new String[]{"Khmer", "\u00e1\u009e\u0097\u00e1\u009e\u00b6\u00e1\u009e\u009f\u00e1\u009e\u00b6\u00e1\u009e\u0081\u00e1\u009f\u0092\u00e1\u009e\u0098\u00e1\u009f\u0082\u00e1\u009e\u009a"});
        LANGUAGES.put("kn", new String[]{"Kannada", "\u00e0\u00b2\u0095\u00e0\u00b2\u00a8\u00e0\u00b3\u008d\u00e0\u00b2\u00a8\u00e0\u00b2\u00a1"});
        LANGUAGES.put("ko", new String[]{"Korean", "Kanuri"});
        LANGUAGES.put("ks", new String[]{"Kashmiri", "\u00d0\u00ba\u00d0\u00be\u00d0\u00bc\u00d0\u00b8 \u00d0\u00ba\u00d1\u008b\u00d0\u00b2"});
        LANGUAGES.put("kw", new String[]{"Cornish", "Kernewek"});
        LANGUAGES.put("ky", new String[]{"Kirghiz", "\u00d0\u00ba\u00d1\u008b\u00d1\u0080\u00d0\u00b3\u00d1\u008b\u00d0\u00b7 \u00d1\u0082\u00d0\u00b8\u00d0\u00bb\u00d0\u00b8"});
        LANGUAGES.put("la", new String[]{"Latin", "latine; lingua latina"});
        LANGUAGES.put("lb", new String[]{"Luxembourgish", "L\u00c3\u00abtzebuergesch"});
        LANGUAGES.put("lg", new String[]{"Ganda", "Luganda"});
        LANGUAGES.put("li", new String[]{"Limburgish", "Limburgs"});
        LANGUAGES.put("ln", new String[]{"Lingala", "Ling\u00c3\u00a1la"});
        LANGUAGES.put("lo", new String[]{"Lao", "\u00e0\u00ba\u009e\u00e0\u00ba\u00b2\u00e0\u00ba\u00aa\u00e0\u00ba\u00b2\u00e0\u00ba\u00a5\u00e0\u00ba\u00b2\u00e0\u00ba\u00a7"});
        LANGUAGES.put("lt", new String[]{"Lithuanian", "lietuvi\u00c5\u00b3 kalba"});
        LANGUAGES.put("lu", new String[]{"Luba-Katanga", "latvie\u00c5\u00a1u valoda"});
        LANGUAGES.put("mg", new String[]{"Malagasy", "Malagasy fiteny"});
        LANGUAGES.put("mh", new String[]{"Marshallese", "Kajin M\u00cc\u00a7aje\u00c4\u00bc"});
        LANGUAGES.put("mi", new String[]{"M\u00c4\u0081ori", "te reo M\u00c4\u0081ori"});
        LANGUAGES.put("mk", new String[]{"Macedonian", "\u00d0\u00bc\u00d0\u00b0\u00d0\u00ba\u00d0\u00b5\u00d0\u00b4\u00d0\u00be\u00d0\u00bd\u00d1\u0081\u00d0\u00ba\u00d0\u00b8 \u00d1\u0098\u00d0\u00b0\u00d0\u00b7\u00d0\u00b8\u00d0\u00ba"});
        LANGUAGES.put("ml", new String[]{"Malayalam", "\u00e0\u00b4\u00ae\u00e0\u00b4\u00b2\u00e0\u00b4\u00af\u00e0\u00b4\u00be\u00e0\u00b4\u00b3\u00e0\u00b4\u0082"});
        LANGUAGES.put("mn", new String[]{"Mongolian", "\u00d0\u009c\u00d0\u00be\u00d0\u00bd\u00d0\u00b3\u00d0\u00be\u00d0\u00bb"});
        LANGUAGES.put("mr", new String[]{"Marathi", "\u00e0\u00a4\u00ae\u00e0\u00a4\u00b0\u00e0\u00a4\u00be\u00e0\u00a4\u00a0\u00e0\u00a5\u0080"});
        LANGUAGES.put("mt", new String[]{"Maltese", "Malti"});
        LANGUAGES.put("ms", new String[]{"Malay", "\u00d8\u00a8\u00d9\u0087\u00d8\u00a7\u00d8\u00b3 \u00d9\u0085\u00d9\u0084\u00d8\u00a7\u00d9\u008a\u00d9\u0088"});
        LANGUAGES.put("my", new String[]{"Burmese", "\u00e1\u0080\u0097\u00e1\u0080\u0099\u00e1\u0080\u00ac\u00e1\u0080\u0085\u00e1\u0080\u00ac"});
        LANGUAGES.put("na", new String[]{"Nauru", "Ekakair\u00c5\u00a9 Naoero"});
        LANGUAGES.put("nb", new String[]{"Norwegian Bokm\u00c3\u00a5l", "Norsk bokm\u00c3\u00a5l"});
        LANGUAGES.put("nd", new String[]{"North Ndebele", "isiNdebele"});
        LANGUAGES.put("ne", new String[]{"Nepali", "\u00e0\u00a4\u00a8\u00e0\u00a5\u0087\u00e0\u00a4\u00aa\u00e0\u00a4\u00be\u00e0\u00a4\u00b2\u00e0\u00a5\u0080"});
        LANGUAGES.put("ng", new String[]{"Ndonga", "Owambo"});
        LANGUAGES.put("nl", new String[]{"Dutch", "Nederlands"});
        LANGUAGES.put("nn", new String[]{"Norwegian Nynorsk", "Norsk nynorsk"});
        LANGUAGES.put("no", new String[]{"Norwegian", "Norsk"});
        LANGUAGES.put("nr", new String[]{"South Ndebele", "isiNdebele"});
        LANGUAGES.put("nv", new String[]{"Navajo", "Din\u00c3\u00a9 bizaad; Din\u00c3\u00a9k\u00ca\u00bceh\u00c7\u00b0\u00c3\u00ad"});
        LANGUAGES.put("ny", new String[]{"Chichewa", "chiChe\u00c5\u00b5a; chinyanja"});
        LANGUAGES.put("oc", new String[]{"Occitan", "Occitan"});
        LANGUAGES.put("oj", new String[]{"Ojibwa", "\u00e1\u0090\u008a\u00e1\u0093\u0082\u00e1\u0094\u0091\u00e1\u0093\u0088\u00e1\u0090\u00af\u00e1\u0092\u00a7\u00e1\u0090\u008e\u00e1\u0093\u0090"});
        LANGUAGES.put("om", new String[]{"Oromo", "Afaan Oromoo"});
        LANGUAGES.put("or", new String[]{"Oriya", "\u00e0\u00ac\u0093\u00e0\u00ac\u00a1\u00e0\u00ac\u00bc\u00e0\u00ac\u00bf\u00e0\u00ac\u0086"});
        LANGUAGES.put("os", new String[]{"Ossetian", "\u00d0\u0098\u00d1\u0080\u00d0\u00be\u00d0\u00bd \u00c3\u00a6\u00d0\u00b2\u00d0\u00b7\u00d0\u00b0\u00d0\u00b3"});
        LANGUAGES.put("pa", new String[]{"Panjabi", "\u00e0\u00a4\u00aa\u00e0\u00a4\u00be\u00e0\u00a4\u00b4\u00e0\u00a4\u00bf"});
        LANGUAGES.put("pl", new String[]{"Polish", "polski"});
        LANGUAGES.put("ps", new String[]{"Pashto", "\u00d9\u00be\u00da\u009a\u00d8\u00aa\u00d9\u0088"});
        LANGUAGES.put("pt", new String[]{"Portuguese", "Portugu\u00c3\u00aas"});
        LANGUAGES.put("qu", new String[]{"Quechua", "Runa Simi; Kichwa"});
        LANGUAGES.put("rm", new String[]{"Raeto-Romance", "rumantsch grischun"});
        LANGUAGES.put("rn", new String[]{"Kirundi", "kiRundi"});
        LANGUAGES.put("ro", new String[]{"Romanian", "Rom\u00c3\u00a2n\u00c4\u0083"});
        LANGUAGES.put("ru", new String[]{"Russian", "\u00d1\u0080\u00d1\u0083\u00d1\u0081\u00d1\u0081\u00d0\u00ba\u00d0\u00b8\u00d0\u00b9 \u00d1\u008f\u00d0\u00b7\u00d1\u008b\u00d0\u00ba"});
        LANGUAGES.put("rw", new String[]{"Kinyarwanda", "Ikinyarwanda"});
        LANGUAGES.put("sa", new String[]{"Sanskrit", "\u00e0\u00a4\u00b8\u00e0\u00a4\u0082\u00e0\u00a4\u00b8\u00e0\u00a5\u008d\u00e0\u00a4\u0095\u00e0\u00a5\u0083\u00e0\u00a4\u00a4\u00e0\u00a4\u00ae\u00e0\u00a5\u008d"});
        LANGUAGES.put("sc", new String[]{"Sardinian", "sardu"});
        LANGUAGES.put("sd", new String[]{"Sindhi", "Davvis\u00c3\u00a1megiella"});
        LANGUAGES.put("sg", new String[]{"Sango", "y\u00c3\u00a2ng\u00c3\u00a2 t\u00c3\u00ae s\u00c3\u00a4ng\u00c3\u00b6"});
        LANGUAGES.put("si", new String[]{"Sinhala", "\u00e0\u00b7\u0083\u00e0\u00b7\u0092\u00e0\u00b6\u0082\u00e0\u00b7\u0084\u00e0\u00b6\u00bd"});
        LANGUAGES.put("sk", new String[]{"Slovak", "sloven\u00c4\u008dina"});
        LANGUAGES.put("sl", new String[]{"Slovenian", "sloven\u00c5\u00a1\u00c4\u008dina"});
        LANGUAGES.put("sm", new String[]{"Samoan", "gagana fa'a Samoa"});
        LANGUAGES.put("sn", new String[]{"Shona", "chiShona"});
        LANGUAGES.put("so", new String[]{"Somali", "Soomaaliga; af Soomaali"});
        LANGUAGES.put("sq", new String[]{"Albanian", "Shqip"});
        LANGUAGES.put("sr", new String[]{"Serbian", "\u00d1\u0081\u00d1\u0080\u00d0\u00bf\u00d1\u0081\u00d0\u00ba\u00d0\u00b8 \u00d1\u0098\u00d0\u00b5\u00d0\u00b7\u00d0\u00b8\u00d0\u00ba"});
        LANGUAGES.put("ss", new String[]{"Swati", "SiSwati"});
        LANGUAGES.put("st", new String[]{"Southern Sotho", "Sesotho"});
        LANGUAGES.put("su", new String[]{"Sundanese", "Basa Sunda"});
        LANGUAGES.put("sv", new String[]{"Swedish", "svenska"});
        LANGUAGES.put("sw", new String[]{"Swahili", "Kiswahili"});
        LANGUAGES.put("ta", new String[]{"Tamil", "\u00e0\u00ae\u00a4\u00e0\u00ae\u00ae\u00e0\u00ae\u00bf\u00e0\u00ae\u00b4\u00e0\u00af\u008d"});
        LANGUAGES.put("te", new String[]{"Telugu", "\u00e0\u00b0\u00a4\u00e0\u00b1\u0086\u00e0\u00b0\u00b2\u00e0\u00b1\u0081\u00e0\u00b0\u0097\u00e0\u00b1\u0081"});
        LANGUAGES.put("tg", new String[]{"Tajik", "\u00e0\u00b9\u0084\u00e0\u00b8\u0097\u00e0\u00b8\u00a2"});
        LANGUAGES.put("ti", new String[]{"Tigrinya", "\u00e1\u0089\u00b5\u00e1\u008c\u008d\u00e1\u0088\u00ad\u00e1\u008a\u009b"});
        LANGUAGES.put("tk", new String[]{"Turkmen", "T\u00c3\u00bcrkmen; \u00d0\u00a2\u00d2\u00af\u00d1\u0080\u00d0\u00ba\u00d0\u00bc\u00d0\u00b5\u00d0\u00bd"});
        LANGUAGES.put("tl", new String[]{"Tagalog", "Tagalog"});
        LANGUAGES.put("tn", new String[]{"Tswana", "Setswana"});
        LANGUAGES.put("to", new String[]{"Tonga", "faka Tonga"});
        LANGUAGES.put("tr", new String[]{"Turkish", "T\u00c3\u00bcrk\u00c3\u00a7e"});
        LANGUAGES.put("ts", new String[]{"Tsonga", "Xitsonga"});
        LANGUAGES.put("tt", new String[]{"Tatar", "Twi"});
        LANGUAGES.put("ty", new String[]{"Tahitian", "Reo M\u00c4\u0081`ohi"});
        LANGUAGES.put("ug", new String[]{"Uighur", "\u00d0\u00a3\u00d0\u00ba\u00d1\u0080\u00d0\u00b0\u00d1\u0097\u00d0\u00bd\u00d1\u0081\u00d1\u008c\u00d0\u00ba\u00d0\u00b0"});
        LANGUAGES.put("ur", new String[]{"Urdu", "\u00d8\u00a7\u00d8\u00b1\u00d8\u00af\u00d9\u0088"});
        LANGUAGES.put("uk", new String[]{"Ukrainian", "Ukra\u00c3\u00afna"});
        LANGUAGES.put("uz", new String[]{"Uzbek", "Tshiven\u00e1\u00b8\u0093a"});
        LANGUAGES.put("vi", new String[]{"Vietnamese", "Ti\u00e1\u00ba\u00bfng Vi\u00e1\u00bb\u0087t"});
        LANGUAGES.put("vo", new String[]{"Volap\u00c3\u00bck", "Volap\u00c3\u00bck"});
        LANGUAGES.put("wa", new String[]{"Walloon", "Walon"});
        LANGUAGES.put("wo", new String[]{"Wolof", "Wollof"});
        LANGUAGES.put("xh", new String[]{"Xhosa", "isiXhosa"});
        LANGUAGES.put("yi", new String[]{"Yiddish", "\u00d7\u0099\u00d7\u0099\u00d6\u00b4\u00d7\u0093\u00d7\u0099\u00d7\u00a9"});
        LANGUAGES.put("yo", new String[]{"Yoruba", "Yor\u00c3\u00b9b\u00c3\u00a1"});
        LANGUAGES.put("za", new String[]{"Zhuang", "Sa\u00c9\u00af cue\u00c5\u008b\u00c6\u0085; Saw cuengh"});
        LANGUAGES.put("zh", new String[]{"Chinese", "\u00e4\u00b8\u00ad\u00e6\u0096\u0087 (Zh\u00c5\u008dngw\u00c3\u00a9n), \u00e6\u00b1\u0089\u00e8\u00af\u00ad, \u00e6\u00bc\u00a2\u00e8\u00aa\u009e"});
        LANGUAGES.put("zu", new String[]{"Zulu", "isiZulu"});
        COUNTRIES = new HashMap();
        COUNTRIES.put("AD", "Andorra");
        COUNTRIES.put("AE", "United Arab Emirates");
        COUNTRIES.put("AF", "Afghanistan");
        COUNTRIES.put("AG", "Antigua And Barbuda");
        COUNTRIES.put("AI", "Anguilla");
        COUNTRIES.put("AL", "Albania");
        COUNTRIES.put("AM", "Armenia");
        COUNTRIES.put("AN", "Netherlands Antilles");
        COUNTRIES.put("AO", "Angola");
        COUNTRIES.put("AQ", "Antarctica");
        COUNTRIES.put("AR", "Argentina");
        COUNTRIES.put("AS", "American Samoa");
        COUNTRIES.put("AT", "Austria");
        COUNTRIES.put("AU", "Australia");
        COUNTRIES.put("AW", "Aruba");
        COUNTRIES.put("AZ", "Azerbaijan");
        COUNTRIES.put("BA", "Bosnia And Herzegowina");
        COUNTRIES.put("BB", "Barbados");
        COUNTRIES.put("BD", "Bangladesh");
        COUNTRIES.put("BE", "Belgium");
        COUNTRIES.put("BF", "Burkina Faso");
        COUNTRIES.put("BG", "Bulgaria");
        COUNTRIES.put("BH", "Bahrain");
        COUNTRIES.put("BI", "Burundi");
        COUNTRIES.put("BJ", "Benin");
        COUNTRIES.put("BM", "Bermuda");
        COUNTRIES.put("BN", "Brunei Darussalam");
        COUNTRIES.put("BO", "Bolivia");
        COUNTRIES.put("BR", "Brazil");
        COUNTRIES.put("BS", "Bahamas");
        COUNTRIES.put("BT", "Bhutan");
        COUNTRIES.put("BV", "Bouvet Island");
        COUNTRIES.put("BW", "Botswana");
        COUNTRIES.put("BY", "Belarus");
        COUNTRIES.put("BZ", "Belize");
        COUNTRIES.put("CA", "Canada");
        COUNTRIES.put("CC", "Cocos (Keeling) Islands");
        COUNTRIES.put("CF", "Central African Republic");
        COUNTRIES.put("CG", "Congo");
        COUNTRIES.put("CH", "Switzerland");
        COUNTRIES.put("CI", "Cote d'Ivoire");
        COUNTRIES.put("CK", "Cook Islands");
        COUNTRIES.put("CL", "Chile");
        COUNTRIES.put("CM", "Cameroon");
        COUNTRIES.put("CN", "China");
        COUNTRIES.put("CO", "Colombia");
        COUNTRIES.put("CR", "Costa Rica");
        COUNTRIES.put("CU", "Cuba");
        COUNTRIES.put("CV", "Cape Verde");
        COUNTRIES.put("CX", "Christmas Island");
        COUNTRIES.put("CY", "Cyprus");
        COUNTRIES.put("CZ", "Czech Republic");
        COUNTRIES.put("DE", "Germany");
        COUNTRIES.put("DJ", "Djibouti");
        COUNTRIES.put("DK", "Denmark");
        COUNTRIES.put("DM", "Dominica");
        COUNTRIES.put("DO", "Dominican Republic");
        COUNTRIES.put("DZ", "Algeria");
        COUNTRIES.put("EC", "Ecuador");
        COUNTRIES.put("EE", "Estonia");
        COUNTRIES.put("EG", "Egypt");
        COUNTRIES.put("EH", "Western Sahara");
        COUNTRIES.put("ER", "Eritrea");
        COUNTRIES.put("ES", "Spain");
        COUNTRIES.put("ET", "Ethiopia");
        COUNTRIES.put("EU", "Europe (SSGFI only)");
        COUNTRIES.put("FI", "Finland");
        COUNTRIES.put("FJ", "Fiji");
        COUNTRIES.put("FK", "Falkland Islands (Malvinas)");
        COUNTRIES.put("FM", "Micronesia, Federated States Of");
        COUNTRIES.put("FO", "Faroe Islands");
        COUNTRIES.put("FR", "France");
        COUNTRIES.put("FX", "France, Metropolitan");
        COUNTRIES.put("GA", "Gabon");
        COUNTRIES.put("GB", "United Kingdom (UK)");
        COUNTRIES.put("GD", "Grenada");
        COUNTRIES.put("GE", "Georgia");
        COUNTRIES.put("GF", "French Guiana");
        COUNTRIES.put("GH", "Ghana");
        COUNTRIES.put("GI", "Gibraltar");
        COUNTRIES.put("GL", "Greenland");
        COUNTRIES.put("GM", "Gambia");
        COUNTRIES.put("GN", "Guinea");
        COUNTRIES.put("GP", "Guadeloupe");
        COUNTRIES.put("GQ", "Equatorial Guinea");
        COUNTRIES.put("GR", "Greece");
        COUNTRIES.put("GS", "South Georgia And The South Sandwich Islands");
        COUNTRIES.put("GT", "Guatemala");
        COUNTRIES.put("GU", "Guam");
        COUNTRIES.put("GW", "Guinea-Bissau");
        COUNTRIES.put("GY", "Guyana");
        COUNTRIES.put("HK", "Hong Kong");
        COUNTRIES.put("HM", "Heard And Mc Donald Islands");
        COUNTRIES.put("HN", "Honduras");
        COUNTRIES.put("HR", "Croatia (local name: Hrvatska)");
        COUNTRIES.put("HT", "Haiti");
        COUNTRIES.put("HU", "Hungary");
        COUNTRIES.put("ID", "Indonesia");
        COUNTRIES.put("IE", "Ireland");
        COUNTRIES.put("II", "International (SSGFI only)");
        COUNTRIES.put("IL", "Israel");
        COUNTRIES.put("IN", "India");
        COUNTRIES.put("IO", "British Indian Ocean Territory");
        COUNTRIES.put("IQ", "Iraq");
        COUNTRIES.put("IR", "Iran (Islamic Republic Of)");
        COUNTRIES.put("IS", "Iceland");
        COUNTRIES.put("IT", "Italy");
        COUNTRIES.put("JM", "Jamaica");
        COUNTRIES.put("JO", "Jordan");
        COUNTRIES.put("JP", "Japan");
        COUNTRIES.put("KE", "Kenya");
        COUNTRIES.put("KG", "Kyrgyzstan");
        COUNTRIES.put("KH", "Cambodia");
        COUNTRIES.put("KI", "Kiribati");
        COUNTRIES.put("KM", "Comoros");
        COUNTRIES.put("KN", "Saint Kitts And Nevis");
        COUNTRIES.put("KP", "Korea, Democratic People's Republic Of");
        COUNTRIES.put("KR", "Korea, Republic Of");
        COUNTRIES.put("KW", "Kuwait");
        COUNTRIES.put("KY", "Cayman Islands");
        COUNTRIES.put("KZ", "Kazakhstan");
        COUNTRIES.put("LA", "Lao People's Democratic Republic");
        COUNTRIES.put("LB", "Lebanon");
        COUNTRIES.put("LC", "Saint Lucia");
        COUNTRIES.put("LI", "Liechtenstein");
        COUNTRIES.put("LK", "Sri Lanka");
        COUNTRIES.put("LR", "Liberia");
        COUNTRIES.put("LS", "Lesotho");
        COUNTRIES.put("LT", "Lithuania");
        COUNTRIES.put("LU", "Luxembourg");
        COUNTRIES.put("LV", "Latvia");
        COUNTRIES.put("LY", "Libyan Arab Jamahiriya");
        COUNTRIES.put("MA", "Morocco");
        COUNTRIES.put("MC", "Monaco");
        COUNTRIES.put("MD", "Moldova, Republic Of");
        COUNTRIES.put("MG", "Madagascar");
        COUNTRIES.put("MH", "Marshall Islands");
        COUNTRIES.put("MK", "Macedonia, The Former Yugoslav Republic Of");
        COUNTRIES.put("ML", "Mali");
        COUNTRIES.put("MM", "Myanmar");
        COUNTRIES.put("MN", "Mongolia");
        COUNTRIES.put("MO", "Macau");
        COUNTRIES.put("MP", "Northern Mariana Islands");
        COUNTRIES.put("MQ", "Martinique");
        COUNTRIES.put("MR", "Mauritania");
        COUNTRIES.put("MS", "Montserrat");
        COUNTRIES.put("MT", "Malta");
        COUNTRIES.put("MU", "Mauritius");
        COUNTRIES.put("MV", "Maldives");
        COUNTRIES.put("MW", "Malawi");
        COUNTRIES.put("MX", "Mexico");
        COUNTRIES.put("MY", "Malaysia");
        COUNTRIES.put("MZ", "Mozambique");
        COUNTRIES.put("NA", "Namibia");
        COUNTRIES.put("NC", "New Caledonia");
        COUNTRIES.put("NE", "Niger");
        COUNTRIES.put("NF", "Norfolk Island");
        COUNTRIES.put("NG", "Nigeria");
        COUNTRIES.put("NI", "Nicaragua");
        COUNTRIES.put("NL", "Netherlands");
        COUNTRIES.put("NO", "Norway");
        COUNTRIES.put("NP", "Nepal");
        COUNTRIES.put("NR", "Nauru");
        COUNTRIES.put("NU", "Niue");
        COUNTRIES.put("NZ", "New Zealand");
        COUNTRIES.put("OM", "Oman");
        COUNTRIES.put("PE", "Peru");
        COUNTRIES.put("PF", "French Polynesia");
        COUNTRIES.put("PG", "Papua New Guinea");
        COUNTRIES.put("PH", "Philippines");
        COUNTRIES.put("PK", "Pakistan");
        COUNTRIES.put("PL", "Poland");
        COUNTRIES.put("PM", "St. Pierre And Miquelon");
        COUNTRIES.put("PN", "Pitcairn");
        COUNTRIES.put("PR", "Puerto Rico");
        COUNTRIES.put("PT", "Portugal");
        COUNTRIES.put("PW", "Palau");
        COUNTRIES.put("PY", "Paraguay");
        COUNTRIES.put("QA", "Qatar");
        COUNTRIES.put("RE", "Reunion");
        COUNTRIES.put("RO", "Romania");
        COUNTRIES.put("RU", "Russian Federation");
        COUNTRIES.put("RW", "Rwanda");
        COUNTRIES.put("SA", "Saudi Arabia");
        COUNTRIES.put("SB", "Solomon Islands");
        COUNTRIES.put("SC", "Seychelles");
        COUNTRIES.put("SD", "Sudan");
        COUNTRIES.put("SE", "Sweden");
        COUNTRIES.put("SG", "Singapore");
        COUNTRIES.put("SH", "St. Helena");
        COUNTRIES.put("SI", "Slovenia");
        COUNTRIES.put("SJ", "Svalbard And Jan Mayen Islands");
        COUNTRIES.put("SK", "Slovakia (Slovak Republic)");
        COUNTRIES.put("SL", "Sierra Leone");
        COUNTRIES.put("SM", "San Marino");
        COUNTRIES.put("SN", "Senegal");
        COUNTRIES.put("SO", "Somalia");
        COUNTRIES.put("SR", "Suriname");
        COUNTRIES.put("ST", "Sao Tome And Principe");
        COUNTRIES.put("SV", "El Salvador");
        COUNTRIES.put("SY", "Syrian Arab Republic");
        COUNTRIES.put("SZ", "Swaziland");
        COUNTRIES.put("TC", "Turks And Caicos Islands");
        COUNTRIES.put("TD", "Chad");
        COUNTRIES.put("TF", "French Southern Territories");
        COUNTRIES.put("TG", "Togo");
        COUNTRIES.put("TH", "Thailand");
        COUNTRIES.put("TJ", "Tajikistan");
        COUNTRIES.put("TK", "Tokelau");
        COUNTRIES.put("TM", "Turkmenistan");
        COUNTRIES.put("TN", "Tunisia");
        COUNTRIES.put("TO", "Tonga");
        COUNTRIES.put("TP", "East Timor");
        COUNTRIES.put("TR", "Turkey");
        COUNTRIES.put("TT", "Trinidad And Tobago");
        COUNTRIES.put("TV", "Tuvalu");
        COUNTRIES.put("TW", "Taiwan");
        COUNTRIES.put("TZ", "Tanzania, United Republic Of");
        COUNTRIES.put("UA", "Ukraine");
        COUNTRIES.put("UG", "Uganda");
        COUNTRIES.put("UM", "United States Minor Outlying Islands");
        COUNTRIES.put("US", "United States");
        COUNTRIES.put("UY", "Uruguay");
        COUNTRIES.put("UZ", "Uzbekistan");
        COUNTRIES.put("VA", "Vatican City State (Holy See)");
        COUNTRIES.put("VC", "Saint Vincent And The Grenadines");
        COUNTRIES.put("VE", "Venezuela");
        COUNTRIES.put("VG", "Virgin Islands (British)");
        COUNTRIES.put("VI", "Virgin Islands (U.S.)");
        COUNTRIES.put("VN", "Viet Nam");
        COUNTRIES.put("VU", "Vanuatu");
        COUNTRIES.put("WF", "Wallis And Futuna Islands");
        COUNTRIES.put("WS", "Samoa");
        COUNTRIES.put("YE", "Yemen");
        COUNTRIES.put("YT", "Mayotte");
        COUNTRIES.put("YU", "Yugoslavia");
        COUNTRIES.put("ZA", "South Africa");
        COUNTRIES.put("ZM", "Zambia");
        COUNTRIES.put("ZR", "Zaire");
        COUNTRIES.put("ZW", "Zimbabwe");
        EXTENSIONS = new HashMap();
        EXTENSIONS.put("hans", "simplified");
        EXTENSIONS.put("hant", "traditional");
    }
}

