/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

public final class EditDistance {
    public static final int damerauLevenshteinDistance(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Letter must not be null");
        }
        int n = string.length();
        int n2 = string2.length();
        if (n == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        int n3 = n + 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int n4 = 0;
        for (n3 = 1; n3 <= n; ++n3) {
            nArray[n3] = n3;
        }
        for (int i = 1; i <= n2; ++i) {
            int n5 = i;
            int n6 = --n5;
            --n6;
            char c = string2.charAt(n5);
            nArray2[0] = i;
            for (n3 = 1; n3 <= n; ++n3) {
                int n7;
                int n8 = n3 - 1;
                n4 = string.charAt(n8) == c ? 0 : 1;
                nArray2[n3] = Math.min(nArray2[n8] + 1, Math.min(nArray[n3] + 1, nArray[n8] + n4));
                if (n3 <= 1 || i <= 1 || string.charAt(n8) != string2.charAt(n6) || string.charAt(n7 = n8 - 1) != string2.charAt(n5)) continue;
                nArray2[n3] = Math.min(nArray2[n3], nArray3[n7] + (n4 > 0 ? 1 : n4));
            }
            for (n3 = 0; n3 <= n; ++n3) {
                nArray3[n3] = nArray[n3];
            }
            int[] nArray4 = nArray;
            nArray = nArray2;
            nArray2 = nArray4;
        }
        return nArray[n];
    }

    public static int getLevenshteinDifference(String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return 0;
            }
            return string2.length();
        }
        int n = string.length();
        if (string2 == null) {
            return n;
        }
        if (string.equals(string2)) {
            return 0;
        }
        return 100 * EditDistance.getLevenshteinDistance(string, string2) / Math.max(n, string2.length());
    }

    public static int getLevenshteinDistance(String string, String string2) {
        int n;
        if (string == null) {
            if (string2 == null) {
                return 0;
            }
            return string2.length();
        }
        if (string2 == null) {
            return string.length();
        }
        int n2 = string.length();
        int n3 = string2.length();
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        int n4 = n2 + 1;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (n = 0; n <= n2; ++n) {
            nArray[n] = n;
        }
        for (int i = 1; i <= n3; ++i) {
            char c = string2.charAt(i - 1);
            nArray2[0] = i;
            for (n = 1; n <= n2; ++n) {
                int n5 = n - 1;
                nArray2[n] = Math.min(Math.min(nArray2[n5] + 1, nArray[n] + 1), nArray[n5] + (string.charAt(n5) == c ? 0 : 1));
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        return nArray[n2];
    }

    private EditDistance() {
    }
}

