/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Pattern;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkModifier;
import jd.nutils.Formatter;
import jd.nutils.encoding.Encoding;
import jd.plugins.ContainerStatus;
import jd.plugins.DownloadLink;
import jd.utils.JDUtilities;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Files;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.logging.Log;

public abstract class PluginsC {
    private Pattern pattern;
    private String name;
    private long version;
    private static final int STATUS_NOTEXTRACTED = 0;
    private static final int STATUS_ERROR_EXTRACTING = 1;
    protected ArrayList<CrawledLink> cls = new ArrayList();
    protected String md5;
    protected byte[] k;
    private int status = 0;

    public PluginsC(String string, String string2, String string3) {
        this.pattern = Pattern.compile(string2, 2);
        this.name = string;
        try {
            this.version = Formatter.getRevision(string3);
        }
        catch (Throwable throwable) {
            this.version = -1L;
        }
    }

    public abstract ContainerStatus callDecryption(File var1);

    public synchronized boolean canHandle(String string) {
        if (string == null) {
            return false;
        }
        String string2 = new Regex(string, this.getSupportedLinks()).getMatch(-1);
        return string2 != null && string2.equalsIgnoreCase(string);
    }

    public String createContainerString(ArrayList<DownloadLink> arrayList) {
        return null;
    }

    public Pattern getSupportedLinks() {
        return this.pattern;
    }

    public String getName() {
        return this.name;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean hideLinks() {
        return true;
    }

    private synchronized void doDecryption(String string) throws IOException {
        Log.L.info("DO STEP");
        String string2 = string;
        if (this.status == 1) {
            Log.L.severe("Expired JD Version. Could not extract links");
            return;
        }
        if (string2 == null) {
            Log.L.severe("Containerfile == null");
            return;
        }
        File file = JDUtilities.getResourceFile(string2);
        if (this.md5 == null) {
            this.md5 = Hash.getMD5(file);
        }
        String string3 = Files.getExtension(file.getAbsolutePath());
        if (file.exists()) {
            File file2 = JDUtilities.getResourceFile("container/" + this.md5 + "." + string3, true);
            if (!file2.exists()) {
                IO.copyFile(file, file2);
            }
            if (!file2.exists()) {
                Log.L.severe("Could not copy file to homedir");
            }
            this.callDecryption(file2);
        }
    }

    public abstract String[] encrypt(String var1);

    public synchronized String extractDownloadURL(DownloadLink downloadLink) {
        throw new WTFException("TODO: this should not happen at the moment");
    }

    public ArrayList<CrawledLink> getContainedDownloadlinks() {
        return this.cls == null ? new ArrayList<CrawledLink>() : this.cls;
    }

    public synchronized void initContainer(String string, byte[] byArray) throws IOException {
        if (string == null) {
            return;
        }
        File file = JDUtilities.getResourceFile(string);
        File file2 = new File(string);
        if (!file.exists() && file2.exists()) {
            String string2 = Files.getExtension(string);
            String string3 = Hash.getMD5(file2);
            File file3 = JDUtilities.getResourceFile("container/" + string3 + "." + string2, true);
            if (!file3.exists()) {
                IO.copyFile(file2, file3);
            }
            string = "container/" + string3 + "." + string2;
        }
        if (this.cls == null || this.cls.size() == 0) {
            Log.L.info("Init Container");
            if (byArray != null) {
                this.k = byArray;
            }
            try {
                this.doDecryption(string);
            }
            catch (Throwable throwable) {
                Log.L.severe(throwable.toString());
            }
        }
    }

    public ArrayList<CrawledLink> getContainerLinks(String string) {
        String[] stringArray = new Regex(string, this.getSupportedLinks()).setMemoryOptimized(false).getColumn(-1);
        ArrayList<CrawledLink> arrayList = null;
        arrayList = stringArray != null && stringArray.length > 0 ? new ArrayList(stringArray.length) : new ArrayList<CrawledLink>();
        if (stringArray != null && stringArray.length > 0) {
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                String string3 = string2 = stringArray2[i];
                string3 = string3.trim();
                while (string3.length() > 0 && string3.charAt(0) == '\"') {
                    string3 = string3.substring(1);
                }
                while (string3.length() > 0 && string3.charAt(string3.length() - 1) == '\"') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                string3 = string3.trim();
                CrawledLink crawledLink = new CrawledLink(string3);
                arrayList.add(crawledLink);
                crawledLink.setCustomCrawledLinkModifier(new CrawledLinkModifier(){

                    @Override
                    public void modifyCrawledLink(CrawledLink crawledLink) {
                        DownloadLink downloadLink;
                        if (PluginsC.this.hideLinks() && (downloadLink = crawledLink.getDownloadLink()) != null) {
                            downloadLink.setLinkType(1);
                        }
                    }
                });
                crawledLink.setcPlugin(this);
            }
        }
        return arrayList;
    }

    public ArrayList<CrawledLink> decryptContainer(CrawledLink crawledLink) {
        if (crawledLink.getURL() == null) {
            return null;
        }
        ArrayList<CrawledLink> arrayList = null;
        boolean bl = true;
        try {
            String string = new Regex(crawledLink.getURL(), "file://(.+)").getMatch(0);
            string = Encoding.urlDecode(string, false);
            if (string == null || !new File(string).exists()) {
                throw new Throwable("Invalid Container: " + crawledLink.getURL());
            }
            this.initContainer(string, null);
            arrayList = this.getContainedDownloadlinks();
        }
        catch (Throwable throwable) {
            Log.L.log(Level.SEVERE, "Exception", throwable);
        }
        if (arrayList == null && bl) {
            Log.L.severe("ContainerPlugin out of date: " + this + " :" + this.getVersion());
        }
        return arrayList;
    }
}

