/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Calendar;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import jd.PluginWrapper;
import jd.config.ConfigContainer;
import jd.config.SubConfiguration;
import jd.controlling.JDPluginLogger;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.encoding.Encoding;
import jd.plugins.CryptedLink;
import jd.plugins.DecrypterException;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.PluginUtils;
import jd.utils.JDUtilities;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.jdownloader.translate._JDT;

public abstract class Plugin
implements ActionListener {
    public static final String HTTP_LINKS_HOST = "http links";
    public static final String DIRECT_HTTP_HOST = "DirectHTTP";
    public static final String FTP_HOST = "ftp";
    protected JDPluginLogger logger = JDPluginLogger.Trash;
    private ConfigContainer config;
    protected Browser br = null;

    public static String extractFileNameFromURL(String string) {
        int n = string.indexOf("?");
        if (n > 0) {
            string = string.substring(0, n);
        }
        n = Math.max(string.lastIndexOf("/"), string.lastIndexOf("\\"));
        string = string.substring(n + 1);
        return Encoding.htmlDecode(string);
    }

    public static String getFileNameFromDispositionHeader(String string) {
        return HTTPConnectionUtils.getFileNameFromDispositionHeader(string);
    }

    public static String getFileNameFromHeader(URLConnectionAdapter uRLConnectionAdapter) {
        if (uRLConnectionAdapter.getHeaderField("Content-Disposition") == null || uRLConnectionAdapter.getHeaderField("Content-Disposition").indexOf("filename") < 0) {
            return Plugin.getFileNameFromURL(uRLConnectionAdapter.getURL());
        }
        return Plugin.getFileNameFromDispositionHeader(uRLConnectionAdapter.getHeaderField("Content-Disposition"));
    }

    public static String getFileNameFromURL(URL uRL) {
        return Plugin.extractFileNameFromURL(uRL.toExternalForm());
    }

    public static String getUserInput(String string, CryptedLink cryptedLink) throws DecrypterException {
        String string2 = PluginUtils.askPassword(string, cryptedLink);
        if (string2 == null) {
            throw new DecrypterException(DecrypterException.PASSWORD);
        }
        return string2;
    }

    public static String getUserInput(String string, DownloadLink downloadLink) throws PluginException {
        String string2 = PluginUtils.askPassword(string, downloadLink);
        if (string2 == null) {
            throw new PluginException(131072, _JDT._.plugins_errors_wrongpassword());
        }
        return string2;
    }

    public Plugin() {
    }

    @Deprecated
    public Plugin(PluginWrapper pluginWrapper) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public boolean canHandle(String string) {
        Matcher matcher;
        if (string == null) {
            return false;
        }
        Pattern pattern = this.getSupportedLinks();
        return pattern != null && (matcher = pattern.matcher(string)).find();
    }

    public void clean() {
        this.br = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigContainer getConfig() {
        if (this.config != null) {
            return this.config;
        }
        Plugin plugin = this;
        synchronized (plugin) {
            if (this.config != null) {
                return this.config;
            }
            this.config = new ConfigContainer(null){
                private static final long serialVersionUID = -30947319320765343L;

                @Override
                public ImageIcon getIcon() {
                    return null;
                }

                @Override
                public String getTitle() {
                    return Plugin.this.getHost();
                }
            };
        }
        return this.config;
    }

    public boolean hasConfig() {
        return this.config != null && this.config.getEntries() != null && this.config.getEntries().size() > 0;
    }

    public abstract String getHost();

    protected File getLocalCaptchaFile() {
        return this.getLocalCaptchaFile(".jpg");
    }

    protected File getLocalCaptchaFile(String string) {
        if (string == null) {
            string = ".jpg";
        }
        Calendar calendar = Calendar.getInstance();
        String string2 = String.format("%1$td.%1$tm.%1$tY_%1$tH.%1$tM.%1$tS.", calendar) + new Random().nextInt(999);
        File file = JDUtilities.getResourceFile("captchas/" + this.getHost() + "_" + string2 + string, true);
        file.deleteOnExit();
        return file;
    }

    public abstract SubConfiguration getPluginConfig();

    public abstract Pattern getSupportedLinks();

    public abstract long getVersion();

    public void init() {
    }

    public String getDescription() {
        return null;
    }
}

