/*
 * Decompiled with CFR 0.152.
 */
package jd.parser.html;

import java.io.File;
import java.util.HashMap;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;

public class InputField
extends HashMap<String, String> {
    private static final long serialVersionUID = 7859094911920903660L;
    private String key = null;
    private String value = null;
    private String type = null;

    public static InputField parse(String string) {
        String[][] stringArray = new Regex(string, "[\"' ](\\w+?)[ ]*=[ ]*[\"](.*?)[\"]").getMatches();
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new Regex(string, "[\"' ](\\w+?)[ ]*=[ ]*['](.*?)[']").getMatches();
        }
        String[][] stringArray2 = new Regex(string, "[\"' ](\\w+?)[ ]*=[ ]*([^>^ ^\"^']+)").getMatches();
        InputField inputField = new InputField();
        for (String[] stringArray3 : stringArray) {
            if (stringArray3[0].equalsIgnoreCase("type")) {
                inputField.setType(stringArray3[1]);
                continue;
            }
            if (stringArray3[0].equalsIgnoreCase("name")) {
                inputField.setKey(Encoding.formEncoding(stringArray3[1]));
                continue;
            }
            if (stringArray3[0].equalsIgnoreCase("value")) {
                inputField.setValue(Encoding.formEncoding(stringArray3[1]));
                continue;
            }
            inputField.put(Encoding.formEncoding(stringArray3[0]), Encoding.formEncoding(stringArray3[1]));
        }
        for (String[] stringArray3 : stringArray2) {
            if (stringArray3[0].equalsIgnoreCase("type")) {
                inputField.setType(stringArray3[1]);
                continue;
            }
            if (stringArray3[0].equalsIgnoreCase("name")) {
                inputField.setKey(Encoding.formEncoding(stringArray3[1]));
                continue;
            }
            if (stringArray3[0].equalsIgnoreCase("value")) {
                inputField.setValue(Encoding.formEncoding(stringArray3[1]));
                continue;
            }
            inputField.put(Encoding.formEncoding(stringArray3[0]), Encoding.formEncoding(stringArray3[1]));
        }
        return inputField;
    }

    public InputField() {
    }

    public InputField(String string, String string2) {
        this.key = string;
        this.value = string2;
    }

    public File getFileToPost() {
        if (!this.type.equalsIgnoreCase("file")) {
            throw new IllegalStateException("No file post field");
        }
        return new File(this.value);
    }

    public String getKey() {
        return this.key;
    }

    public String getProperty(String string, String string2) {
        String string3 = (String)this.get(string);
        return string3 == null ? string3 : string2;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setFileToPost(File file) {
        if (!this.type.equalsIgnoreCase("file")) {
            throw new IllegalStateException("No file post field");
        }
        this.value = file.getAbsolutePath();
    }

    public void setKey(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.key = string;
    }

    public void setType(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.type = string;
    }

    public void setValue(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.value = string;
    }

    @Override
    public String toString() {
        return "Field: " + this.key + "(" + this.type + ")" + " = " + this.value + " [" + super.toString() + "]";
    }
}

