/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.io;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import jd.controlling.JDLogger;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;

public final class JDIO {
    public static Vector<File> saveReadObject = new Vector();

    private JDIO() {
    }

    public static boolean writeLocalFile(File file, String string) {
        return JDIO.writeLocalFile(file, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeLocalFile(File file, String string, boolean bl) {
        boolean bl2;
        OutputStreamWriter outputStreamWriter = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (!bl && file.isFile() && !file.delete()) {
                System.err.println("Konnte Datei nicht l\u00c3\u00b6schen " + file);
                boolean bl3 = false;
                return bl3;
            }
            if (file.getParent() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!bl || !file.isFile()) {
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(file, bl);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(string);
            bufferedWriter.close();
            bl2 = true;
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (Throwable throwable) {}
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return bl2;
    }

    public static String validateFileandPathName(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("([\\\\|<|>|\\||\"|:|\\*|\\?|/|\\x00])+", "_");
    }

    public static boolean saveToFile(File file, byte[] byArray) {
        try {
            IO.writeToFile(file, byArray);
            return true;
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveObject(Object object, File file, boolean bl) {
        if (file == null || file.isDirectory()) {
            System.err.println("Schreibfehler: Wrong parameter (" + file + ")");
            return;
        }
        file.getParentFile().mkdirs();
        JDIO.waitOnObject(file);
        saveReadObject.add(file);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            if (bl) {
                XMLEncoder xMLEncoder = new XMLEncoder(bufferedOutputStream);
                xMLEncoder.writeObject(object);
                xMLEncoder.close();
            } else {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
            }
            bufferedOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
        saveReadObject.remove(file);
    }

    public static void waitOnObject(File file) {
        int n = 0;
        while (saveReadObject.contains(file)) {
            if (n++ > 1000) {
                return;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                JDLogger.exception(interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadObject(File file, boolean bl) {
        if (file == null || file.isDirectory()) {
            System.err.println("Schreibfehler: Wrong parameter (" + file + ")");
            return null;
        }
        Object object = null;
        JDIO.waitOnObject(file);
        saveReadObject.add(file);
        FileInputStream fileInputStream = null;
        try {
            Object object2;
            fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            if (bl) {
                object2 = new XMLDecoder(new BufferedInputStream(bufferedInputStream));
                object = ((XMLDecoder)object2).readObject();
                ((XMLDecoder)object2).close();
            } else {
                object2 = new ObjectInputStream(bufferedInputStream);
                object = ((ObjectInputStream)object2).readObject();
                ((ObjectInputStream)object2).close();
            }
            fileInputStream.close();
            bufferedInputStream.close();
            saveReadObject.remove(file);
            object2 = object;
            return object2;
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable) {}
        }
        saveReadObject.remove(file);
        return null;
    }

    public static String readFileToString(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return "";
        }
        try {
            return IO.readFileToString(file);
        }
        catch (IOException iOException) {
            JDLogger.exception(iOException);
            return "";
        }
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return null;
        }
        return JDIO.getFileExtension(file.getAbsolutePath());
    }

    public static String getFileExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileType(String string) {
        File file = null;
        try {
            file = File.createTempFile("icon", "." + string);
            String string2 = new JFileChooser().getTypeDescription(file);
            return string2;
        }
        catch (IOException iOException) {
            String string3 = "." + string;
            return string3;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public static boolean copyFile(File file, File file2) {
        if (!file.exists()) {
            return false;
        }
        try {
            IO.copyFile(file, file2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean removeDirectoryOrFile(File file) {
        if (file.isDirectory()) {
            String[] stringArray;
            for (String string : stringArray = file.list()) {
                boolean bl = JDIO.removeDirectoryOrFile(new File(file, string));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static ArrayList<File> listFiles(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                arrayList.addAll(JDIO.listFiles(file2));
                continue;
            }
            arrayList.add(file2);
        }
        return arrayList;
    }

    public static void removeByPattern(File file, final Pattern pattern) {
        JDIO.removeRekursive(file, new FileSelector(){

            @Override
            public boolean doIt(File file) {
                return Regex.matches((Object)file.getAbsolutePath(), pattern);
            }
        });
    }

    public static void removeRekursive(File file, FileSelector fileSelector) {
        if (file == null || !file.exists()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                JDIO.removeRekursive(file2, fileSelector);
            }
            if (!fileSelector.doIt(file2)) continue;
            file2.delete();
        }
    }

    public static abstract class FileSelector {
        public abstract boolean doIt(File var1);
    }
}

