/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.awt.Color;

public class Colors {
    public static Color getColor(Color color, int n) {
        n *= 255;
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n /= 100);
    }

    public static float[] rgb2cmyk(int n) {
        float f = n >> 16 & 0xFF;
        float f2 = n >> 8 & 0xFF;
        float f3 = n & 0xFF;
        float f4 = 1.0f - f / 255.0f;
        float f5 = 1.0f - f2 / 255.0f;
        float f6 = 1.0f - f3 / 255.0f;
        float f7 = 1.0f;
        if (f4 < f7) {
            f7 = f4;
        }
        if (f5 < f7) {
            f7 = f5;
        }
        if (f6 < f7) {
            f7 = f6;
        }
        f4 = (f4 - f7) / (1.0f - f7);
        f5 = (f5 - f7) / (1.0f - f7);
        f6 = (f6 - f7) / (1.0f - f7);
        return new float[]{f4 * 100.0f, f5 * 100.0f, f6 * 100.0f, f7 * 100.0f};
    }

    public static int[] rgb2lab(int n, int n2, int n3) {
        int[] nArray = new int[3];
        float f = 0.008856452f;
        float f2 = 903.2963f;
        float f3 = 0.964221f;
        float f4 = 1.0f;
        float f5 = 0.825211f;
        float f6 = (float)n / 255.0f;
        float f7 = (float)n2 / 255.0f;
        float f8 = (float)n3 / 255.0f;
        f6 = (double)f6 <= 0.04045 ? (f6 /= 12.0f) : (float)Math.pow(((double)f6 + 0.055) / 1.055, 2.4);
        f7 = (double)f7 <= 0.04045 ? (f7 /= 12.0f) : (float)Math.pow(((double)f7 + 0.055) / 1.055, 2.4);
        f8 = (double)f8 <= 0.04045 ? (f8 /= 12.0f) : (float)Math.pow(((double)f8 + 0.055) / 1.055, 2.4);
        float f9 = 0.43605202f * f6 + 0.3850816f * f7 + 0.14308742f * f8;
        float f10 = 0.22249159f * f6 + 0.71688604f * f7 + 0.060621485f * f8;
        float f11 = 0.013929122f * f6 + 0.097097f * f7 + 0.7141855f * f8;
        float f12 = f9 / f3;
        float f13 = f10 / f4;
        float f14 = f11 / f5;
        float f15 = f12 > f ? (float)Math.pow(f12, 0.3333333333333333) : (float)(((double)(f2 * f12) + 16.0) / 116.0);
        float f16 = f13 > f ? (float)Math.pow(f13, 0.3333333333333333) : (float)(((double)(f2 * f13) + 16.0) / 116.0);
        float f17 = f14 > f ? (float)Math.pow(f14, 0.3333333333333333) : (float)(((double)(f2 * f14) + 16.0) / 116.0);
        float f18 = 116.0f * f16 - 16.0f;
        float f19 = 500.0f * (f15 - f16);
        float f20 = 200.0f * (f16 - f17);
        nArray[0] = (int)(2.55 * (double)f18 + 0.5);
        nArray[1] = (int)((double)f19 + 0.5);
        nArray[2] = (int)((double)f20 + 0.5);
        return nArray;
    }

    public static float[] rgb2hsb(int n, int n2, int n3) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(n, n2, n3, fArray);
        return fArray;
    }

    public static float[] rgb2hsb(int n) {
        int[] nArray = Colors.hexToRgb(n);
        return Colors.rgb2hsb(nArray[0], nArray[1], nArray[2]);
    }

    public static int[] rgb2hsv(int n) {
        int[] nArray = Colors.hexToRgb(n);
        float[] fArray = Colors.rgb2hsb(nArray[0], nArray[1], nArray[2]);
        return new int[]{Math.round(fArray[0] * 360.0f), Math.round(fArray[1] * 100.0f), Math.round(fArray[2] * 100.0f)};
    }

    public static int rgbToHex(int[] nArray) {
        return (nArray[0] << 16) + (nArray[1] << 8) + nArray[2];
    }

    public static int mixColors(int n, int n2, int n3, int n4) {
        int[] nArray = Colors.hexToRgb(n);
        int[] nArray2 = Colors.hexToRgb(n2);
        int n5 = (nArray[0] * n3 + nArray2[0] * n4) / (n3 + n4);
        int n6 = (nArray[1] * n3 + nArray2[1] * n4) / (n3 + n4);
        int n7 = (nArray[2] * n3 + nArray2[2] * n4) / (n3 + n4);
        return Colors.rgbToHex(new int[]{n5, n6, n7});
    }

    public static int mixColors(int n, int n2) {
        int[] nArray = Colors.hexToRgb(n);
        int[] nArray2 = Colors.hexToRgb(n2);
        int[] nArray3 = new int[]{(int)((long)nArray[0] + (long)nArray2[0] >> 1), (int)((long)nArray[1] + (long)nArray2[1] >> 1), (int)((long)nArray[2] + (long)nArray2[2] >> 1)};
        return Colors.rgbToHex(nArray3);
    }

    public static int[] hexToRgb(int n) {
        return new int[]{n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, 0};
    }

    public static int[] getRGB(int n) {
        Color color = new Color(n);
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public static double getHueColorDifference(int n, int n2) {
        if (n == n2) {
            return 0.0;
        }
        return Colors.getHueColorDifference(Colors.getRGB(n), Colors.getRGB(n2));
    }

    public static double getHueColorDifference(int[] nArray, int[] nArray2) {
        float f = Colors.rgb2hsb(nArray[0], nArray[1], nArray[2])[0] * 100.0f;
        float f2 = Colors.rgb2hsb(nArray2[0], nArray2[1], nArray2[2])[0] * 100.0f;
        double d = Math.abs((double)(f - f2));
        return d;
    }

    public static double getHueColorDifference360(int n, int n2) {
        if (n == n2) {
            return 0.0;
        }
        return Colors.getHueColorDifference360(Colors.getRGB(n), Colors.getRGB(n2));
    }

    public static double getHueColorDifference360(int[] nArray, int[] nArray2) {
        float f = Colors.rgb2hsb(nArray[0], nArray[1], nArray[2])[0] * 360.0f;
        float f2 = Colors.rgb2hsb(nArray2[0], nArray2[1], nArray2[2])[0] * 360.0f;
        double d = Math.abs((double)(f - f2));
        return d;
    }

    public static double getSaturationColorDifference(int n, int n2) {
        if (n == n2) {
            return 0.0;
        }
        return Colors.getSaturationColorDifference(Colors.getRGB(n), Colors.getRGB(n2));
    }

    public static double getSaturationColorDifference(int[] nArray, int[] nArray2) {
        float f = Colors.rgb2hsb(nArray[0], nArray[1], nArray[2])[1] * 100.0f;
        float f2 = Colors.rgb2hsb(nArray2[0], nArray2[1], nArray2[2])[1] * 100.0f;
        double d = Math.abs((double)(f - f2));
        return d;
    }

    public static double getBrightnessColorDifference(int n, int n2) {
        if (n == n2) {
            return 0.0;
        }
        return Colors.getBrightnessColorDifference(Colors.getRGB(n), Colors.getRGB(n2));
    }

    public static double getBrightnessColorDifference(int[] nArray, int[] nArray2) {
        float f = Colors.rgb2hsb(nArray[0], nArray[1], nArray[2])[2] * 100.0f;
        float f2 = Colors.rgb2hsb(nArray2[0], nArray2[1], nArray2[2])[2] * 100.0f;
        double d = Math.abs((double)(f - f2));
        return d;
    }

    public static double getColorDifference(int[] nArray, int[] nArray2) {
        int[] nArray3 = Colors.rgb2lab(nArray[0], nArray[1], nArray[2]);
        int[] nArray4 = Colors.rgb2lab(nArray2[0], nArray2[1], nArray2[2]);
        int n = nArray3[0] - nArray4[0];
        int n2 = nArray3[1] - nArray4[1];
        int n3 = nArray3[2] - nArray4[2];
        return Math.sqrt(n * n + n2 * n2 + n3 * n3);
    }

    public static double getColorDifference(int n, int n2) {
        if (n == n2) {
            return 0.0;
        }
        return Colors.getColorDifference(Colors.getRGB(n), Colors.getRGB(n2));
    }

    public static int getRGBDistance(int n) {
        Color color = new Color(n);
        int n2 = Math.abs(color.getBlue() - color.getRed());
        int n3 = Math.abs(color.getBlue() - color.getGreen());
        int n4 = Math.abs(color.getGreen() - color.getRed());
        return (n2 + n3 + n4) / 3;
    }

    public static double getRGBColorDifference2(int n, int n2) {
        if (n == n2) {
            return 0.0;
        }
        Color color = new Color(n);
        Color color2 = new Color(n2);
        int n3 = color.getRed() - color2.getRed();
        int n4 = color.getGreen() - color2.getGreen();
        int n5 = color.getBlue() - color2.getBlue();
        return (Math.abs(n3) + Math.abs(n4) + Math.abs(n5)) / 3;
    }

    public static double getRGBColorDifference3(int n, int n2) {
        if (n == n2) {
            return 0.0;
        }
        Color color = new Color(n);
        Color color2 = new Color(n2);
        int n3 = color.getRed() - color2.getRed();
        int n4 = color.getGreen() - color2.getGreen();
        int n5 = color.getBlue() - color2.getBlue();
        return Math.max(Math.abs(n3), Math.max(Math.abs(n4), Math.abs(n5)));
    }

    public static double getRGBColorDifference1(int n, int n2) {
        if (n == n2) {
            return 0.0;
        }
        Color color = new Color(n);
        Color color2 = new Color(n2);
        int n3 = color.getRed() - color2.getRed();
        int n4 = color.getGreen() - color2.getGreen();
        int n5 = color.getBlue() - color2.getBlue();
        return Math.sqrt(n3 * n3 + n4 * n4 + n5 * n5);
    }

    public static double getCMYKColorDifference1(int n, int n2) {
        if (n == n2) {
            return 0.0;
        }
        float[] fArray = Colors.rgb2cmyk(n);
        float[] fArray2 = Colors.rgb2cmyk(n2);
        double d = fArray[0] - fArray2[0];
        double d2 = fArray[1] - fArray2[1];
        double d3 = fArray[2] - fArray2[2];
        double d4 = fArray[3] - fArray2[3];
        return Math.sqrt(d * d + d2 * d2 + d3 * d3 + d4 * d4);
    }
}

