/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.util.Date;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging.Log;

public class Cookie {
    private String path;
    private String host;
    private String value;
    private String key;
    private String domain;
    private long hostTime = -1L;
    private long creationTime = System.currentTimeMillis();
    private long expireTime = -1L;

    public Cookie() {
        this.host = "";
        this.key = "";
        this.value = "";
    }

    public Cookie(String string, String string2, String string3) {
        this.host = string;
        this.key = string2;
        this.value = string3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Cookie cookie = (Cookie)object;
        if (this.host == null ? cookie.host != null : !this.host.equalsIgnoreCase(cookie.host)) {
            return false;
        }
        return !(this.key == null ? cookie.key != null : !this.key.equalsIgnoreCase(cookie.key));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.host == null ? 0 : this.host.toUpperCase().hashCode());
        n = 31 * n + (this.key == null ? 0 : this.key.toUpperCase().hashCode());
        return n;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getExpireDate() {
        return this.expireTime;
    }

    public String getHost() {
        return this.host;
    }

    public long getHostTime() {
        return this.hostTime;
    }

    public String getKey() {
        return this.key;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isExpired() {
        if (this.expireTime == -1L) {
            return false;
        }
        if (this.hostTime == -1L) {
            Log.L.severe("Cookie: no HostTime found! ExpireStatus cannot be checked " + this.host + " " + this.key);
            return false;
        }
        long l = System.currentTimeMillis() - this.creationTime + this.hostTime;
        return l > this.expireTime;
    }

    public void setCreationTime(long l) {
        this.creationTime = l;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public void setExpireDate(long l) {
        this.expireTime = l;
    }

    public void setExpires(String string) {
        if (string == null) {
            this.expireTime = -1L;
            return;
        }
        Date date = TimeFormatter.parseDateString(string);
        if (date != null) {
            this.expireTime = date.getTime();
            return;
        }
        this.expireTime = -1L;
        Log.L.severe("Cookie: no Format for " + string + " found!");
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setHostTime(long l) {
        this.hostTime = l;
    }

    public void setHostTime(String string) {
        if (string == null) {
            this.hostTime = -1L;
            return;
        }
        Date date = TimeFormatter.parseDateString(string);
        if (date != null) {
            this.hostTime = date.getTime();
            return;
        }
        this.hostTime = -1L;
        Log.L.severe("Cookie: no Format for " + string + " found!");
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String toString() {
        return this.key + "=" + this.value + " @" + this.host;
    }

    public void update(Cookie cookie) {
        this.setCreationTime(cookie.creationTime);
        this.setExpireDate(cookie.expireTime);
        this.setValue(cookie.value);
        this.setHostTime(cookie.creationTime);
    }
}

