/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.ipcheck;

import java.util.ArrayList;
import jd.controlling.reconnect.ipcheck.CustomWebIpCheck;
import jd.controlling.reconnect.ipcheck.ForbiddenIPException;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.controlling.reconnect.ipcheck.IPCheckProvider;
import jd.controlling.reconnect.ipcheck.IPConnectionState;
import jd.controlling.reconnect.ipcheck.InvalidProviderException;
import jd.controlling.reconnect.ipcheck.event.IPControllEvent;
import jd.controlling.reconnect.ipcheck.event.IPControllEventSender;
import org.appwork.utils.logging.Log;

public class IPController
extends ArrayList<IPConnectionState> {
    private static final long serialVersionUID = -6856149094542337379L;
    private static final IPController INSTANCE = new IPController();
    private boolean invalidated = false;
    private IPConnectionState latestConnectionState;
    private final Object LOCK = new Object();
    private final ArrayList<IPCheckProvider> badProviders = new ArrayList();
    private IPConnectionState invalidState = null;
    private IPControllEventSender eventSender = new IPControllEventSender();

    public static IPController getInstance() {
        return INSTANCE;
    }

    public IPControllEventSender getEventSender() {
        return this.eventSender;
    }

    private IPController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(IPConnectionState iPConnectionState) {
        if (iPConnectionState == null) {
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            IPConnectionState iPConnectionState2;
            if (this.size() > 0 && (iPConnectionState2 = (IPConnectionState)this.get(this.size() - 1)).equalsLog(iPConnectionState)) {
                return false;
            }
            iPConnectionState2 = this.latestConnectionState;
            this.latestConnectionState = iPConnectionState;
            this.eventSender.fireEvent(new IPControllEvent(IPControllEvent.Type.STATECHANGED, iPConnectionState2, iPConnectionState));
            return super.add(iPConnectionState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean changedIP() {
        if (this.invalidState == null) {
            return false;
        }
        if (this.size() == 0) {
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.fetchIP();
            IPConnectionState iPConnectionState = this.latestConnectionState;
            if (iPConnectionState.isOffline()) {
                return false;
            }
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.get(i) == this.invalidState) {
                    if (!this.invalidState.equalsLog(iPConnectionState)) {
                        this.eventSender.fireEvent(new IPControllEvent(IPControllEvent.Type.IP_CHANGED, this.invalidState, iPConnectionState));
                        return true;
                    }
                    return false;
                }
                if (!((IPConnectionState)this.get(i)).isOnline() || ((IPConnectionState)this.get(i)).equalsLog(iPConnectionState)) continue;
                this.eventSender.fireEvent(new IPControllEvent(IPControllEvent.Type.IP_CHANGED, this.invalidState, iPConnectionState));
                return true;
            }
        }
        return false;
    }

    protected IP fetchIP() {
        IPConnectionState iPConnectionState = null;
        IPCheckProvider iPCheckProvider = null;
        while (true) {
            try {
                iPCheckProvider = this.getIPCheckProvider();
                iPConnectionState = new IPConnectionState(iPCheckProvider.getExternalIP());
                System.out.println("IP: " + iPConnectionState.getExternalIp());
            }
            catch (InvalidProviderException invalidProviderException) {
                this.badProviders.add(iPCheckProvider);
                continue;
            }
            catch (IPCheckException iPCheckException) {
                iPConnectionState = new IPConnectionState(iPCheckException);
            }
            break;
        }
        IPConnectionState iPConnectionState2 = this.latestConnectionState;
        if (this.add(iPConnectionState)) {
            if (this.latestConnectionState.isOffline()) {
                this.eventSender.fireEvent(new IPControllEvent(IPControllEvent.Type.OFFLINE, new IPConnectionState[0]));
            }
            if ((iPConnectionState2 == null || iPConnectionState2.isOffline()) && !iPConnectionState.isOffline()) {
                this.eventSender.fireEvent(new IPControllEvent(IPControllEvent.Type.ONLINE, iPConnectionState));
            }
        }
        return this.latestConnectionState.getExternalIp();
    }

    public synchronized IPConnectionState getIpState() {
        if (this.latestConnectionState == null) {
            this.fetchIP();
        }
        return this.latestConnectionState;
    }

    public IP getIP() {
        return this.getIpState().getExternalIp();
    }

    private IPCheckProvider getIPCheckProvider() {
        CustomWebIpCheck customWebIpCheck = null;
        if (customWebIpCheck == null || this.badProviders.contains(customWebIpCheck)) {
            customWebIpCheck = CustomWebIpCheck.getInstance();
        }
        return customWebIpCheck;
    }

    public void invalidate() {
        if (this.invalidated) {
            return;
        }
        this.setInvalidated(true);
        this.invalidState = this.getIpState();
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public boolean validate() {
        if (!this.invalidated) {
            return true;
        }
        if (this.changedIP()) {
            this.setInvalidated(false);
            return true;
        }
        this.setInvalidated(true);
        return false;
    }

    private void setInvalidated(boolean bl) {
        if (bl == this.invalidated) {
            return;
        }
        this.invalidated = bl;
        if (bl) {
            this.eventSender.fireEvent(new IPControllEvent(IPControllEvent.Type.INVALIDATED, this.getIpState()));
        } else {
            this.eventSender.fireEvent(new IPControllEvent(IPControllEvent.Type.VALIDATED, this.invalidState, this.getIpState()));
        }
    }

    public boolean validateAndWait(int n, int n2, int n3) throws InterruptedException {
        if (!this.invalidated) {
            return true;
        }
        long l = System.currentTimeMillis() + (long)(n * 1000);
        long l2 = System.currentTimeMillis() + (long)(n2 * 1000);
        boolean bl = false;
        while (true) {
            this.validate();
            if (!this.isInvalidated()) {
                return true;
            }
            if (this.latestConnectionState.isOffline()) {
                bl = true;
            }
            if (this.latestConnectionState.getCause() != null) {
                try {
                    throw this.latestConnectionState.getCause();
                }
                catch (ForbiddenIPException forbiddenIPException) {
                    this.eventSender.fireEvent(new IPControllEvent(IPControllEvent.Type.FORBIDDEN_IP, this.getIpState()));
                    this.setInvalidated(true);
                    return false;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!bl && System.currentTimeMillis() >= l2) {
                Log.L.info("Not offline after " + l2 + " seconds");
                break;
            }
            if (System.currentTimeMillis() >= l) {
                Log.L.info("Not reconnected after " + l + " seconds");
                break;
            }
            Thread.sleep(Math.max(250, n3 * 1000));
        }
        return !this.isInvalidated();
    }

    public void waitUntilWeAreOnline() throws InterruptedException {
        while (IPController.getInstance().getIpState().isOffline()) {
            IPController.getInstance().invalidate();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            Thread.sleep(1000L);
            IPController.getInstance().validate();
        }
    }
}

