/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackageView;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.jdownloader.settings.GeneralSettings;

public class CrawledPackage
implements AbstractPackageNode<CrawledLink, CrawledPackage> {
    protected static final String PACKAGETAG = "<jd:packagename>";
    private boolean autoExtractionEnabled = true;
    private ArrayList<CrawledLink> children;
    private String comment = null;
    private PackageController<CrawledPackage, CrawledLink> controller = null;
    private long created = -1L;
    private String name = null;
    private String downloadFolder = JsonConfig.create(GeneralSettings.class).getDefaultDownloadFolder();
    private boolean downloadFolderSet = false;
    private boolean expanded = false;
    private HashSet<String> extractionPasswords = new HashSet();
    protected CrawledPackageView view;

    public CrawledPackage() {
        this.children = new ArrayList();
        this.view = new CrawledPackageView();
    }

    @Override
    public List<CrawledLink> getChildren() {
        return this.children;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public PackageController<CrawledPackage, CrawledLink> getControlledBy() {
        return this.controller;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public String getDownloadFolder() {
        return this.downloadFolder.replace(PACKAGETAG, this.getName());
    }

    public HashSet<String> getExtractionPasswords() {
        return this.extractionPasswords;
    }

    @Override
    public long getFinishedDate() {
        return 0L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getRawDownloadFolder() {
        return this.downloadFolder;
    }

    public boolean isAutoExtractionEnabled() {
        return this.autoExtractionEnabled;
    }

    public boolean isDownloadFolderSet() {
        return this.downloadFolderSet;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void notifyStructureChanges() {
    }

    public void setAutoExtractionEnabled(boolean bl) {
        this.autoExtractionEnabled = bl;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public void setControlledBy(PackageController<CrawledPackage, CrawledLink> packageController) {
        this.controller = packageController;
    }

    public void setCreated(long l) {
        this.created = l;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDownloadFolder(String string) {
        if (!StringUtils.isEmpty(string)) {
            this.downloadFolderSet = true;
            this.downloadFolder = string;
        } else {
            this.downloadFolder = JsonConfig.create(GeneralSettings.class).getDefaultDownloadFolder();
            this.downloadFolderSet = false;
        }
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    @Override
    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public CrawledPackageView getView() {
        return this.view;
    }

    @Override
    public boolean isEnabled() {
        return this.getView().isEnabled();
    }

    @Override
    public void nodeUpdated(CrawledLink crawledLink) {
        this.getView().updateInfo(crawledLink);
        this.notifyChanges();
    }

    private void notifyChanges() {
        PackageController<CrawledPackage, CrawledLink> packageController = this.getControlledBy();
        if (packageController != null) {
            packageController.nodeUpdated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(CrawledLink crawledLink) {
        CrawledPackage crawledPackage = this;
        synchronized (crawledPackage) {
            return this.children.indexOf(crawledLink);
        }
    }
}

