/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkchecker;

import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.JDLogger;
import jd.controlling.JDPluginLogger;
import jd.controlling.linkchecker.LinkCheckerConfig;
import jd.controlling.linkchecker.LinkCheckerEvent;
import jd.controlling.linkchecker.LinkCheckerEventSender;
import jd.controlling.linkchecker.LinkCheckerHandler;
import jd.controlling.linkcrawler.CheckableLink;
import jd.http.Browser;
import jd.http.BrowserSettingsThread;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.logging.Log;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;

public class LinkChecker<E extends CheckableLink> {
    private static AtomicInteger CHECKER = new AtomicInteger(0);
    private static AtomicInteger LINKCHECKER_THREAD_NUM = new AtomicInteger(0);
    private static final int MAX_THREADS;
    private static final int KEEP_ALIVE;
    private static HashMap<String, Thread> CHECK_THREADS;
    private static HashMap<String, ArrayList<LinkChecker<? extends CheckableLink>>> LINKCHECKER;
    private static final Object LOCK;
    private AtomicLong linksRequested = new AtomicLong(0L);
    private AtomicLong linksDone = new AtomicLong(0L);
    private HashMap<String, LinkedList<InternCheckableLink>> links2Check = new HashMap();
    private boolean forceRecheck = false;
    private LinkCheckerHandler<E> handler = null;
    private static int SPLITSIZE;
    private static LinkCheckerEventSender EVENTSENDER;
    protected AtomicInteger checkerGeneration = new AtomicInteger(0);

    public static LinkCheckerEventSender getEventSender() {
        return EVENTSENDER;
    }

    public LinkChecker() {
        this(false);
    }

    public LinkChecker(boolean bl) {
        this.forceRecheck = bl;
    }

    public boolean isForceRecheck() {
        return this.forceRecheck;
    }

    public void setLinkCheckHandler(LinkCheckerHandler<E> linkCheckerHandler) {
        this.handler = linkCheckerHandler;
    }

    public LinkCheckerHandler<E> getLinkCheckHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopChecking() {
        this.checkerGeneration.incrementAndGet();
        LinkChecker linkChecker = this;
        synchronized (linkChecker) {
            for (LinkedList<InternCheckableLink> linkedList : this.links2Check.values()) {
                this.linksDone.addAndGet(linkedList.size());
            }
            this.links2Check.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void linkChecked(InternCheckableLink internCheckableLink) {
        Object object;
        boolean bl;
        if (internCheckableLink == null) {
            return;
        }
        boolean bl2 = bl = this.linksDone.incrementAndGet() == this.linksRequested.get();
        if (bl) {
            object = CHECKER;
            synchronized (object) {
                CHECKER.decrementAndGet();
            }
            EVENTSENDER.fireEvent(new LinkCheckerEvent(this, LinkCheckerEvent.Type.STOPPED));
        }
        if ((object = this.handler) != null && internCheckableLink.linkCheckAllowed()) {
            object.linkCheckDone(internCheckableLink.getCheckableLink());
        }
    }

    public void check(List<E> list) {
        if (list == null) {
            throw new IllegalArgumentException("links is null?");
        }
        for (CheckableLink checkableLink : list) {
            this.check(checkableLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(E e) {
        AbstractList abstractList;
        String string;
        if (e == null || e.getDownloadLink() == null) {
            throw new IllegalArgumentException("links is null?");
        }
        DownloadLink downloadLink = e.getDownloadLink();
        String string2 = downloadLink.getHost();
        if (("ftp".equalsIgnoreCase(string2) || "DirectHTTP".equalsIgnoreCase(string2) || "http links".equalsIgnoreCase(string2)) && (string = Browser.getHost(downloadLink.getDownloadURL())) != null) {
            string2 = string;
        }
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            abstractList = this.links2Check.get(string2);
            if (abstractList == null) {
                abstractList = new LinkedList();
                this.links2Check.put(string2, (LinkedList<InternCheckableLink>)abstractList);
            }
            ((LinkedList)abstractList).add((InternCheckableLink)new InternCheckableLink((CheckableLink)e, this));
            if (this.linksRequested.get() == this.linksDone.get()) {
                bl = true;
            }
            this.linksRequested.incrementAndGet();
        }
        if (bl) {
            object = CHECKER;
            synchronized (object) {
                CHECKER.incrementAndGet();
            }
            EVENTSENDER.fireEvent(new LinkCheckerEvent(this, LinkCheckerEvent.Type.STARTED));
        }
        object = LOCK;
        synchronized (object) {
            abstractList = LINKCHECKER.get(string2);
            if (abstractList == null) {
                abstractList = new ArrayList();
                ((ArrayList)abstractList).add(this);
                LINKCHECKER.put(string2, (ArrayList<LinkChecker<? extends CheckableLink>>)abstractList);
            } else if (!((ArrayList)abstractList).contains(this)) {
                ((ArrayList)abstractList).add(this);
            }
            Thread thread = CHECK_THREADS.get(string2);
            if (thread == null || !thread.isAlive()) {
                LinkChecker.startNewThreads();
            }
        }
    }

    public boolean isRunning() {
        return this.linksRequested.get() != this.linksDone.get();
    }

    public long checksRequested() {
        return this.linksRequested.get();
    }

    public long checksDone() {
        return this.linksDone.get();
    }

    public static boolean isChecking() {
        return CHECKER.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForChecked() {
        while (this.isRunning()) {
            LinkChecker linkChecker = this;
            synchronized (linkChecker) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
        }
        return !this.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startNewThread(final String string) {
        Object object = LOCK;
        synchronized (object) {
            if (CHECK_THREADS.size() >= MAX_THREADS) {
                return;
            }
            BrowserSettingsThread browserSettingsThread = new BrowserSettingsThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int n = 1;
                    PluginForHost pluginForHost = null;
                    Browser browser = new Browser();
                    while (true) {
                        ArrayList arrayList;
                        Object object;
                        ArrayList arrayList2 = new ArrayList();
                        try {
                            Iterator iterator;
                            object = LOCK;
                            synchronized (object) {
                                arrayList = (ArrayList)LINKCHECKER.get(string);
                                if (arrayList != null) {
                                    for (Object object2 : arrayList) {
                                        iterator = object2;
                                        synchronized (iterator) {
                                            Object object3 = (LinkedList)((LinkChecker)object2).links2Check.get(string);
                                            if (object3 != null) {
                                                arrayList2.addAll(object3);
                                                Iterator iterator2 = ((AbstractSequentialList)object3).iterator();
                                                while (iterator2.hasNext()) {
                                                    InternCheckableLink internCheckableLink = (InternCheckableLink)iterator2.next();
                                                    if (!((LinkChecker)object2).isForceRecheck()) continue;
                                                    internCheckableLink.getCheckableLink().getDownloadLink().setAvailableStatus(DownloadLink.AvailableStatus.UNCHECKED);
                                                }
                                                ((LinkedList)object3).clear();
                                            }
                                        }
                                    }
                                    LINKCHECKER.remove(string);
                                }
                            }
                            int n2 = arrayList2.size();
                            for (int i = 0; i < n2; i += SPLITSIZE) {
                                Object object2;
                                List list = arrayList2.subList(i, Math.min(n2, i + SPLITSIZE));
                                if (list.size() <= 0) continue;
                                n = 1;
                                object2 = new ArrayList(list.size());
                                for (Object object3 : list) {
                                    if (!((InternCheckableLink)object3).linkCheckAllowed()) continue;
                                    ((ArrayList)object2).add(((InternCheckableLink)object3).getCheckableLink().getDownloadLink());
                                }
                                if (pluginForHost == null && ((ArrayList)object2).size() > 0) {
                                    iterator = HostPluginController.getInstance().get(((DownloadLink)((ArrayList)object2).get(0)).getDefaultPlugin().getHost());
                                    pluginForHost = ((LazyHostPlugin)((Object)iterator)).newInstance();
                                    pluginForHost.setBrowser(browser);
                                    pluginForHost.setLogger(new JDPluginLogger(((LazyPlugin)((Object)iterator)).getDisplayName() + ":LinkCheck"));
                                    pluginForHost.init();
                                }
                                Thread.currentThread().setContextClassLoader(pluginForHost.getLazyP().getClassLoader());
                                try {
                                    pluginForHost.checkLinks(((ArrayList)object2).toArray(new DownloadLink[((ArrayList)object2).size()]));
                                }
                                catch (Throwable throwable) {
                                    Log.exception(throwable);
                                }
                                finally {
                                    object2 = null;
                                }
                                for (Object object3 : list) {
                                    if (((InternCheckableLink)object3).linkCheckAllowed() && pluginForHost != null) {
                                        LinkChecker.updateAvailableStatus(pluginForHost, ((InternCheckableLink)object3).getCheckableLink().getDownloadLink());
                                    }
                                    ((InternCheckableLink)object3).getLinkChecker().linkChecked((InternCheckableLink)object3);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Log.exception(throwable);
                        }
                        try {
                            Thread.sleep(KEEP_ALIVE);
                        }
                        catch (InterruptedException interruptedException) {
                            Log.exception(interruptedException);
                            Object object4 = LOCK;
                            synchronized (object4) {
                                CHECK_THREADS.remove(string);
                                return;
                            }
                        }
                        object = LOCK;
                        synchronized (object) {
                            arrayList = (ArrayList)LINKCHECKER.get(string);
                            if ((arrayList == null || arrayList.size() == 0) && --n < 0) {
                                CHECK_THREADS.remove(string);
                                LinkChecker.startNewThreads();
                                return;
                            }
                        }
                    }
                }
            });
            browserSettingsThread.setName("LinkChecker: " + LINKCHECKER_THREAD_NUM.incrementAndGet() + ":" + string);
            browserSettingsThread.setDaemon(true);
            CHECK_THREADS.put(string, browserSettingsThread);
            browserSettingsThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startNewThreads() {
        Object object = LOCK;
        synchronized (object) {
            Set<Map.Entry<String, ArrayList<LinkChecker<? extends CheckableLink>>>> set = LINKCHECKER.entrySet();
            for (Map.Entry<String, ArrayList<LinkChecker<? extends CheckableLink>>> entry : set) {
                String string = entry.getKey();
                Thread thread = CHECK_THREADS.get(string);
                if (thread != null && thread.isAlive()) continue;
                CHECK_THREADS.remove(string);
                if (CHECK_THREADS.size() >= MAX_THREADS) break;
                LinkChecker.startNewThread(string);
            }
        }
    }

    private static void updateAvailableStatus(PluginForHost pluginForHost, DownloadLink downloadLink) {
        if (downloadLink.getAvailableStatus() != DownloadLink.AvailableStatus.UNCHECKED) {
            return;
        }
        DownloadLink.AvailableStatus availableStatus = null;
        try {
            pluginForHost.reset();
            availableStatus = pluginForHost.requestFileInformation(downloadLink);
            try {
                pluginForHost.getBrowser().getHttpConnection().disconnect();
            }
            catch (Throwable throwable) {}
        }
        catch (PluginException pluginException) {
            pluginException.fillLinkStatus(downloadLink.getLinkStatus());
            availableStatus = downloadLink.getLinkStatus().hasStatus(16) || downloadLink.getLinkStatus().hasStatus(4096) || downloadLink.getLinkStatus().hasStatus(2048) ? DownloadLink.AvailableStatus.UNCHECKABLE : DownloadLink.AvailableStatus.FALSE;
        }
        catch (Throwable throwable) {
            JDLogger.exception(throwable);
            availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
        }
        if (availableStatus == null) {
            availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
        }
        downloadLink.setAvailableStatus(availableStatus);
    }

    static {
        CHECK_THREADS = new HashMap();
        LINKCHECKER = new HashMap();
        LOCK = new Object();
        SPLITSIZE = 80;
        EVENTSENDER = new LinkCheckerEventSender();
        MAX_THREADS = Math.max(JsonConfig.create(LinkCheckerConfig.class).getMaxThreads(), 1);
        KEEP_ALIVE = Math.max(JsonConfig.create(LinkCheckerConfig.class).getThreadKeepAlive(), 100);
    }

    private static class InternCheckableLink {
        protected CheckableLink link = null;
        protected final int linkCheckerGeneration;
        private LinkChecker<? extends CheckableLink> checker;

        public InternCheckableLink(CheckableLink checkableLink, LinkChecker<? extends CheckableLink> linkChecker) {
            this.link = checkableLink;
            this.linkCheckerGeneration = linkChecker.checkerGeneration.get();
            this.checker = linkChecker;
        }

        public CheckableLink getCheckableLink() {
            return this.link;
        }

        public boolean linkCheckAllowed() {
            return this.linkCheckerGeneration == this.checker.checkerGeneration.get();
        }

        public LinkChecker<? extends CheckableLink> getLinkChecker() {
            return this.checker;
        }
    }
}

