/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.util.ArrayList;
import java.util.List;
import jd.controlling.downloadcontroller.DownloadSpeedManager;
import jd.plugins.DownloadLink;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.net.throttledconnection.ThrottledConnectionHandler;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class ManagedThrottledConnectionHandler
implements ThrottledConnectionHandler {
    private ArrayList<ThrottledConnection> connections = new ArrayList();
    private int limit = 0;
    private volatile long traffic = 0L;
    private final DownloadLink link;
    private DownloadSpeedManager managedBy = null;

    public ManagedThrottledConnectionHandler(DownloadLink downloadLink) {
        this.link = downloadLink;
    }

    public DownloadLink getLink() {
        return this.link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addThrottledConnection(ThrottledConnection throttledConnection) {
        if (this.connections.contains(throttledConnection)) {
            return;
        }
        Object object = this;
        synchronized (object) {
            ArrayList<ThrottledConnection> arrayList = new ArrayList<ThrottledConnection>(this.connections);
            arrayList.add(throttledConnection);
            this.connections = arrayList;
        }
        object = this.managedBy;
        if (object != null && ((DownloadSpeedManager)object).getLimit() > 0 || this.getLimit() > 0) {
            throttledConnection.setLimit(10);
        }
        throttledConnection.setHandler(this);
    }

    @Override
    public List<ThrottledConnection> getConnections() {
        return this.connections;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getSpeed() {
        ArrayList<ThrottledConnection> arrayList = this.connections;
        int n = 0;
        for (ThrottledConnection throttledConnection : arrayList) {
            n = (int)((long)n + ((SpeedMeterInterface)((Object)throttledConnection)).getSpeedMeter());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTraffic() {
        ArrayList<ThrottledConnection> arrayList = null;
        long l = 0L;
        ManagedThrottledConnectionHandler managedThrottledConnectionHandler = this;
        synchronized (managedThrottledConnectionHandler) {
            l = this.traffic;
            arrayList = this.connections;
        }
        for (ThrottledConnection throttledConnection : arrayList) {
            l += throttledConnection.transfered();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeThrottledConnection(ThrottledConnection throttledConnection) {
        if (!this.connections.contains(throttledConnection)) {
            return;
        }
        ManagedThrottledConnectionHandler managedThrottledConnectionHandler = this;
        synchronized (managedThrottledConnectionHandler) {
            ArrayList<ThrottledConnection> arrayList = new ArrayList<ThrottledConnection>(this.connections);
            arrayList.remove(throttledConnection);
            this.connections = arrayList;
            this.traffic += throttledConnection.transfered();
        }
        throttledConnection.setHandler(null);
    }

    @Override
    public void setLimit(int n) {
        this.limit = n;
    }

    @Override
    public int size() {
        return this.connections.size();
    }

    protected void setManagedBy(DownloadSpeedManager downloadSpeedManager) {
        this.managedBy = downloadSpeedManager;
    }
}

