/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.accountchecker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.AccountController;
import jd.controlling.accountchecker.AccountCheckerEvent;
import jd.controlling.accountchecker.AccountCheckerEventSender;
import jd.plugins.Account;
import jd.plugins.AccountInfo;

public class AccountChecker {
    private static AccountChecker INSTANCE = new AccountChecker();
    private HashMap<String, Thread> checkThreads = new HashMap();
    private HashMap<String, LinkedList<AccountCheckJob>> jobs = new HashMap();
    private ArrayList<Account> accountJobs = new ArrayList();
    private AtomicLong jobsRequested = new AtomicLong(0L);
    private AtomicLong jobsDone = new AtomicLong(0L);
    private AccountCheckerEventSender eventSender = new AccountCheckerEventSender();

    public AccountCheckerEventSender getEventSender() {
        return this.eventSender;
    }

    public static AccountChecker getInstance() {
        return INSTANCE;
    }

    private AccountChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountCheckJob check(Account account, boolean bl) {
        AccountCheckJob accountCheckJob = null;
        boolean bl2 = false;
        AccountChecker accountChecker = this;
        synchronized (accountChecker) {
            final String string = AccountController.getInstance().getHosterName(account);
            if (string == null) {
                return null;
            }
            LinkedList<AccountCheckJob> linkedList = this.jobs.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList();
                this.jobs.put(string, linkedList);
            }
            accountCheckJob = new AccountCheckJob(account, bl);
            this.jobsRequested.incrementAndGet();
            linkedList.add(accountCheckJob);
            Thread thread = this.checkThreads.get(string);
            if (thread == null || !thread.isAlive()) {
                bl2 = this.checkThreads.isEmpty();
                thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AccountCheckJob accountCheckJob = null;
                        boolean bl = false;
                        while (true) {
                            AccountChecker accountChecker = AccountChecker.this;
                            synchronized (accountChecker) {
                                LinkedList linkedList = (LinkedList)AccountChecker.this.jobs.get(string);
                                if (linkedList == null || linkedList.size() <= 0) {
                                    AccountChecker.this.jobs.remove(string);
                                    AccountChecker.this.checkThreads.remove(string);
                                    bl = AccountChecker.this.checkThreads.isEmpty();
                                    break;
                                }
                                accountCheckJob = (AccountCheckJob)linkedList.removeFirst();
                            }
                            try {
                                accountCheckJob.check();
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                        if (bl) {
                            AccountChecker.this.eventSender.fireEvent(new AccountCheckerEvent(AccountChecker.this, AccountCheckerEvent.Types.CHECK_STOPPED, null));
                        }
                    }
                });
                thread.setName("AccountChecker: " + string);
                thread.setDaemon(true);
                this.checkThreads.put(string, thread);
                thread.start();
            }
        }
        if (bl2) {
            this.eventSender.fireEvent(new AccountCheckerEvent(this, AccountCheckerEvent.Types.CHECK_STARTED, null));
        }
        return accountCheckJob;
    }

    public boolean isRunning() {
        return this.jobsRequested.get() != this.jobsDone.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Account account) {
        AccountChecker accountChecker = this;
        synchronized (accountChecker) {
            return this.accountJobs.contains(account);
        }
    }

    public class AccountCheckJob {
        private Account account;
        private boolean isChecked = false;
        private boolean isChecking = false;
        private boolean force = false;
        private AccountInfo ai = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AccountCheckJob(Account account, boolean bl) {
            this.account = account;
            this.force = bl;
            AccountCheckJob accountCheckJob = this;
            synchronized (accountCheckJob) {
                AccountChecker.this.accountJobs.add(account);
            }
        }

        public AccountCheckJob(Account account) {
            this(account, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void check() {
            this.isChecking = true;
            try {
                this.ai = AccountController.getInstance().updateAccountInfo(null, this.account, this.force);
            }
            finally {
                this.isChecking = false;
                AccountCheckJob accountCheckJob = this;
                synchronized (accountCheckJob) {
                    this.isChecked = true;
                    AccountChecker.this.accountJobs.remove(this.account);
                    this.notify();
                }
                AccountChecker.this.jobsDone.incrementAndGet();
            }
        }

        public boolean isChecked() {
            return this.isChecked;
        }

        public boolean isChecking() {
            return this.isChecking;
        }

        public AccountInfo getAccountInfo() {
            return this.ai;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AccountInfo waitChecked() {
            while (!this.isChecked) {
                AccountCheckJob accountCheckJob = this;
                synchronized (accountCheckJob) {
                    if (this.isChecked) {
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
            }
            return this.ai;
        }
    }
}

