/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jd.controlling.LogFormatter;
import jd.nutils.Formatter;
import jd.utils.JDUtilities;

public final class JDLogger {
    private static Logger LOGGER = null;
    public static final String LOGGER_NAME = "JDownloader";
    private static ConsoleHandler console;
    private static FileHandler filehandler;
    private static String logpath;

    private JDLogger() {
    }

    public static Logger getLogger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger(LOGGER_NAME);
            LogFormatter logFormatter = new LogFormatter();
            LOGGER.setUseParentHandlers(false);
            console = new ConsoleHandler();
            console.setLevel(Level.ALL);
            console.setFormatter(logFormatter);
            LOGGER.addHandler(console);
            LOGGER.setLevel(Level.ALL);
            try {
                logpath = JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath() + "/JDownloader.log";
                filehandler = new FileHandler(logpath);
                filehandler.setLevel(Level.ALL);
                filehandler.setFormatter(logFormatter);
                LOGGER.addHandler(filehandler);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return LOGGER;
    }

    public static void timestamp(String string) {
        JDLogger.getLogger().warning(Formatter.formatMilliseconds(System.currentTimeMillis()) + " : " + string);
    }

    public static void exception(Throwable throwable) {
        JDLogger.exception(Level.SEVERE, throwable);
    }

    public static void removeConsoleHandler() {
        if (console != null) {
            JDLogger.getLogger().removeHandler(console);
        }
        System.err.println("Removed Consolehandler. Start with -debug to see console output");
    }

    public static void addHeader(String string) {
        JDLogger.getLogger().info("\r\n\r\n--------------------------------------" + string + "-----------------------------------");
    }

    public static void exception(Level level, Throwable throwable) {
        JDLogger.getLogger().log(level, level.getName() + " Exception occurred", throwable);
    }

    public static void quickLog() {
        System.out.println("Footstep: " + new Exception().getStackTrace()[1]);
    }

    public static void warning(Object object) {
        JDLogger.getLogger().warning(object.toString());
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public static String getLog() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(logpath));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append('\n');
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder.toString();
    }
}

