/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jd.config.SubConfiguration;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.JDLogger;
import jd.controlling.JDPluginLogger;
import jd.controlling.accountchecker.AccountChecker;
import jd.http.Browser;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.utils.JDUtilities;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.Eventsender;
import org.appwork.utils.logging.Log;
import org.jdownloader.settings.AccountData;
import org.jdownloader.settings.AccountSettings;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class AccountController
implements AccountControllerListener {
    private static final long serialVersionUID = -7560087582989096645L;
    private static HashMap<String, ArrayList<Account>> hosteraccounts = null;
    private static HashMap<String, ArrayList<Account>> blockedAccounts = new HashMap();
    private static AccountController INSTANCE = new AccountController();
    private final Eventsender<AccountControllerListener, AccountControllerEvent> broadcaster = new Eventsender<AccountControllerListener, AccountControllerEvent>(){

        @Override
        protected void fireEvent(AccountControllerListener accountControllerListener, AccountControllerEvent accountControllerEvent) {
            accountControllerListener.onAccountControllerEvent(accountControllerEvent);
        }
    };
    private long waittimeAccountInfoUpdate = 900000L;
    private Logger logger = JDLogger.getLogger();
    private AccountSettings config = JsonConfig.create(AccountSettings.class);
    public static final Object ACCOUNT_LOCK = new Object();
    private static final Comparator<Account> COMPARE_MOST_TRAFFIC_LEFT = new Comparator<Account>(){

        @Override
        public int compare(Account account, Account account2) {
            long l;
            AccountInfo accountInfo = account.getAccountInfo();
            AccountInfo accountInfo2 = account2.getAccountInfo();
            long l2 = accountInfo == null ? 0L : accountInfo.getTrafficLeft();
            long l3 = l = accountInfo2 == null ? 0L : accountInfo2.getTrafficLeft();
            if (l2 < 0L) {
                l2 = Long.MAX_VALUE;
            }
            if (l < 0L) {
                l = Long.MAX_VALUE;
            }
            if (l2 == l) {
                return 0;
            }
            if (l2 < l) {
                return 1;
            }
            return -1;
        }
    };

    public long getUpdateTime() {
        return this.waittimeAccountInfoUpdate;
    }

    public void setUpdateTime(long l) {
        this.waittimeAccountInfoUpdate = l;
    }

    private AccountController() {
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public void run() {
                AccountController.this.save();
            }

            @Override
            public String toString() {
                return "save accounts...";
            }
        });
        hosteraccounts = this.loadAccounts();
        Collection<ArrayList<Account>> collection = hosteraccounts.values();
        for (ArrayList<Account> arrayList : collection) {
            for (Account account : arrayList) {
                account.setAccountController(this);
            }
        }
        this.broadcaster.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() {
        HashMap<String, ArrayList<AccountData>> hashMap = new HashMap<String, ArrayList<AccountData>>();
        HashMap<String, ArrayList<Account>> hashMap2 = hosteraccounts;
        synchronized (hashMap2) {
            for (Map.Entry<String, ArrayList<Account>> entry : hosteraccounts.entrySet()) {
                if (entry.getValue().size() <= 0) continue;
                ArrayList<AccountData> arrayList = new ArrayList<AccountData>();
                hashMap.put(entry.getKey(), arrayList);
                for (Account account : entry.getValue()) {
                    arrayList.add(AccountData.create(account));
                }
            }
        }
        this.config.setAccounts(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountInfo updateAccountInfo(String string, Account account, boolean bl) {
        String string2;
        String string3 = string2 = string != null ? string : this.getHosterName(account);
        if (string2 == null) {
            account.setAccountInfo(null);
            this.logger.severe("Cannot update AccountInfo, no Hostername available!");
            return null;
        }
        PluginForHost pluginForHost = JDUtilities.getNewPluginForHostInstance(string2);
        if (pluginForHost == null) {
            account.setAccountInfo(null);
            this.logger.severe("Cannot update AccountInfo, no HosterPlugin available!");
            return null;
        }
        pluginForHost.setLogger(new JDPluginLogger("AccountCheck:" + string2));
        pluginForHost.setBrowser(new Browser());
        AccountInfo accountInfo = account.getAccountInfo();
        if (!bl) {
            if (account.lastUpdateTime() != 0L && accountInfo != null && accountInfo.isExpired()) {
                account.setEnabled(false);
                this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 31, string2, account));
                return accountInfo;
            }
            if (!account.isValid() && account.lastUpdateTime() != 0L) {
                account.setEnabled(false);
                this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 30, string2, account));
                return accountInfo;
            }
            if (System.currentTimeMillis() - account.lastUpdateTime() < this.waittimeAccountInfoUpdate) {
                return accountInfo;
            }
        }
        try {
            account.setValid(true);
            accountInfo = account.getAccountInfo();
            if (accountInfo != null) {
                accountInfo.setExpired(false);
                accountInfo.setValidUntil(-1L);
            }
            try {
                accountInfo = pluginForHost.fetchAccountInfo(account);
            }
            finally {
                account.setUpdateTime(System.currentTimeMillis());
            }
            if (accountInfo == null) {
                account.setAccountInfo(null);
                this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 20, string2, account));
                return null;
            }
            Object object = ACCOUNT_LOCK;
            synchronized (object) {
                account.setAccountInfo(accountInfo);
            }
            if (accountInfo.isExpired()) {
                account.setEnabled(false);
                this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 31, string2, account));
            } else if (!account.isValid()) {
                account.setEnabled(false);
                this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 30, string2, account));
            } else {
                this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 20, string2, account));
            }
        }
        catch (IOException iOException) {
            this.logger.severe("AccountUpdate: " + string + " failed!");
        }
        catch (Throwable throwable) {
            if (throwable instanceof PluginException) {
                PluginException pluginException = (PluginException)throwable;
                accountInfo = account.getAccountInfo();
                if (accountInfo == null) {
                    accountInfo = new AccountInfo();
                    account.setAccountInfo(accountInfo);
                }
                if (pluginException.getLinkStatus() == 256) {
                    if (pluginException.getValue() == 0L) {
                        this.logger.severe("Premium Account " + account.getUser() + ": Traffic Limit reached");
                        account.setTempDisabled(true);
                        account.getAccountInfo().setTrafficLeft(0L);
                        this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 20, string2, account));
                        return accountInfo;
                    }
                    if (pluginException.getValue() == 1L) {
                        account.setEnabled(false);
                        account.setValid(false);
                        if (StringUtils.isEmpty(accountInfo.getStatus())) {
                            accountInfo.setStatus("Invalid Account!");
                        }
                        this.logger.severe("Premium Account " + account.getUser() + ": expired:");
                        this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 30, string2, account));
                        return accountInfo;
                    }
                }
            }
            this.logger.severe("AccountUpdate: " + string + " failed!");
            JDLogger.exception(throwable);
            account.setAccountInfo(null);
            account.setEnabled(false);
            account.setValid(false);
            this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 30, string2, account));
        }
        return accountInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHosterName(Account account) {
        if (account == null) {
            return null;
        }
        if (account.getHoster() != null) {
            return account.getHoster();
        }
        HashMap<String, ArrayList<Account>> hashMap = hosteraccounts;
        synchronized (hashMap) {
            for (String string : hosteraccounts.keySet()) {
                if (!hosteraccounts.get(string).contains(account)) continue;
                account.setHoster(string);
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, ArrayList<Account>> list() {
        HashMap<String, ArrayList<Account>> hashMap = hosteraccounts;
        synchronized (hashMap) {
            return new HashMap<String, ArrayList<Account>>(hosteraccounts);
        }
    }

    public static AccountController getInstance() {
        return INSTANCE;
    }

    public void addListener(AccountControllerListener accountControllerListener) {
        this.broadcaster.addListener(accountControllerListener);
    }

    public void removeListener(AccountControllerListener accountControllerListener) {
        this.broadcaster.removeListener(accountControllerListener);
    }

    private synchronized HashMap<String, ArrayList<Account>> loadAccounts() {
        HashMap<String, ArrayList<AccountData>> hashMap = this.config.getAccounts();
        if (hashMap == null) {
            try {
                hashMap = this.restore();
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
                hashMap = new HashMap();
            }
        }
        HashMap<String, ArrayList<Account>> hashMap2 = new HashMap<String, ArrayList<Account>>();
        for (Map.Entry<String, ArrayList<AccountData>> entry : hashMap.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            ArrayList<Account> arrayList = new ArrayList<Account>();
            hashMap2.put(entry.getKey(), arrayList);
            for (AccountData accountData : entry.getValue()) {
                Account account = accountData.toAccount();
                arrayList.add(account);
                account.setHoster(entry.getKey());
            }
        }
        return hashMap2;
    }

    private HashMap<String, ArrayList<AccountData>> restore() {
        SubConfiguration subConfiguration = SubConfiguration.getConfig("AccountController");
        HashMap hashMap = subConfiguration.getGenericProperty("accountlist", new HashMap());
        HashMap<String, ArrayList<AccountData>> hashMap2 = new HashMap<String, ArrayList<AccountData>>();
        for (Map.Entry entry : hashMap.entrySet()) {
            if (((ArrayList)entry.getValue()).size() <= 0) continue;
            ArrayList<AccountData> arrayList = new ArrayList<AccountData>();
            hashMap2.put((String)entry.getKey(), arrayList);
            for (HashMap hashMap3 : (ArrayList)entry.getValue()) {
                AccountData accountData = new AccountData();
                arrayList.add(accountData);
                accountData.setUser((String)hashMap3.get("user"));
                accountData.setPassword((String)hashMap3.get("pass"));
                accountData.setEnabled("true".equals(hashMap3.containsKey("enabled")));
            }
        }
        this.config.setAccounts(hashMap2);
        return hashMap2;
    }

    public void addAccount(PluginForHost pluginForHost, Account account) {
        this.addAccount(pluginForHost.getHost(), account);
        account.setAccountController(this);
    }

    public ArrayList<Account> getAllAccounts(PluginForHost pluginForHost) {
        return pluginForHost == null ? new ArrayList() : this.getAllAccounts(pluginForHost.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccountBlocked(Account account) {
        HashMap<String, ArrayList<Account>> hashMap = blockedAccounts;
        synchronized (hashMap) {
            String string = this.getHosterName(account);
            List list = blockedAccounts.get(string);
            return list != null && list.contains(account);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccountBlocked(Account account) {
        HashMap<String, ArrayList<Account>> hashMap = blockedAccounts;
        synchronized (hashMap) {
            if (this.isAccountBlocked(account)) {
                return;
            }
            String string = this.getHosterName(account);
            ArrayList<Account> arrayList = blockedAccounts.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                blockedAccounts.put(string, arrayList);
            }
            arrayList.add(account);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccountBlocked(Account account) {
        HashMap<String, ArrayList<Account>> hashMap = blockedAccounts;
        synchronized (hashMap) {
            if (!this.isAccountBlocked(account)) {
                return;
            }
            String string = this.getHosterName(account);
            ArrayList<Account> arrayList = blockedAccounts.get(string);
            if (arrayList != null) {
                arrayList.remove(account);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccountBlocked(String string) {
        HashMap<String, ArrayList<Account>> hashMap = blockedAccounts;
        synchronized (hashMap) {
            if (string == null) {
                blockedAccounts.clear();
            } else {
                blockedAccounts.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Account> getAllAccounts(String string) {
        ArrayList<Account> arrayList = new ArrayList<Account>();
        if (string == null) {
            return arrayList;
        }
        HashMap<String, ArrayList<Account>> hashMap = hosteraccounts;
        synchronized (hashMap) {
            if (hosteraccounts.containsKey(string)) {
                return hosteraccounts.get(string);
            }
            ArrayList<Account> arrayList2 = new ArrayList<Account>();
            hosteraccounts.put(string, arrayList2);
            return arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAccounts(String string) {
        HashMap<String, ArrayList<Account>> hashMap = hosteraccounts;
        synchronized (hashMap) {
            ArrayList<Account> arrayList = hosteraccounts.get(string);
            if (arrayList != null && arrayList.size() > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int validAccounts() {
        int n = 0;
        HashMap<String, ArrayList<Account>> hashMap = hosteraccounts;
        synchronized (hashMap) {
            for (ArrayList<Account> arrayList : hosteraccounts.values()) {
                for (Account account : arrayList) {
                    if (!account.isEnabled()) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAccount(String string, Account account) {
        if (string != null && account != null) {
            HashMap<String, ArrayList<Account>> hashMap = hosteraccounts;
            synchronized (hashMap) {
                if (hosteraccounts.containsKey(string)) {
                    ArrayList<Account> arrayList;
                    ArrayList<Account> arrayList2 = arrayList = hosteraccounts.get(string);
                    synchronized (arrayList2) {
                        boolean bl = arrayList.contains(account);
                        if (!bl) {
                            boolean bl2 = false;
                            ArrayList<Account> arrayList3 = new ArrayList<Account>(arrayList);
                            for (Account account2 : arrayList3) {
                                if (!account2.equals(account)) continue;
                                bl2 = true;
                                break;
                            }
                            if (!bl2) {
                                arrayList.add(account);
                                bl = true;
                            }
                        }
                        if (bl) {
                            this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 10, string, account));
                        }
                    }
                } else {
                    ArrayList<Account> arrayList = new ArrayList<Account>();
                    arrayList.add(account);
                    hosteraccounts.put(string, arrayList);
                    this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 10, string, account));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAccount(String string, Account account) {
        String string2;
        if (account == null) {
            return false;
        }
        String string3 = string2 = string == null ? this.getHosterName(account) : string;
        if (string2 == null) {
            return false;
        }
        HashMap<String, ArrayList<Account>> hashMap = hosteraccounts;
        synchronized (hashMap) {
            ArrayList<Account> arrayList;
            if (!hosteraccounts.containsKey(string2)) {
                return false;
            }
            ArrayList<Account> arrayList2 = arrayList = hosteraccounts.get(string2);
            synchronized (arrayList2) {
                boolean bl = arrayList.remove(account);
                if (!bl) {
                    ArrayList<Account> arrayList3 = new ArrayList<Account>(arrayList);
                    for (Account account2 : arrayList3) {
                        if (!account2.equals(account)) continue;
                        bl = arrayList.remove(account2);
                        break;
                    }
                }
                if (bl) {
                    this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 11, string2, account));
                }
                return bl;
            }
        }
    }

    public boolean removeAccount(PluginForHost pluginForHost, Account account) {
        if (account == null) {
            return false;
        }
        if (pluginForHost == null) {
            return this.removeAccount((String)null, account);
        }
        return this.removeAccount(pluginForHost.getHost(), account);
    }

    @Override
    public void onAccountControllerEvent(AccountControllerEvent accountControllerEvent) {
        Account account = null;
        switch (accountControllerEvent.getEventID()) {
            case 10: {
                account = accountControllerEvent.getAccount();
                if (account != null && System.currentTimeMillis() - account.lastUpdateTime() > 20000L) {
                    AccountChecker.getInstance().check(account, true);
                }
                CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.setValue(true);
                break;
            }
            case 20: {
                account = accountControllerEvent.getAccount();
                if (account == null || !account.isEnabled() || this != account.getAccountController()) break;
                AccountChecker.getInstance().check(account, false);
                break;
            }
            case 11: 
            case 30: 
            case 31: {
                break;
            }
        }
    }

    public void throwUpdateEvent(PluginForHost pluginForHost, Account account) {
        if (pluginForHost != null) {
            this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 20, pluginForHost.getHost(), account));
        } else {
            this.broadcaster.fireEvent(new AccountControllerEvent((Object)this, 20, null, account));
        }
    }

    public Account getValidAccount(PluginForHost pluginForHost) {
        return this.getValidAccount(pluginForHost.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasValidAccount(String string) {
        HashMap<String, ArrayList<Account>> hashMap = hosteraccounts;
        synchronized (hashMap) {
            ArrayList<Account> arrayList = hosteraccounts.get(string);
            if (arrayList != null) {
                for (Account account : arrayList) {
                    if (account.isTempDisabled() || !account.isEnabled() || !account.isValid()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getValidAccount(String string) {
        Account account = null;
        HashMap<String, ArrayList<Account>> hashMap = hosteraccounts;
        synchronized (hashMap) {
            ArrayList<Account> arrayList = new ArrayList<Account>(this.getAllAccounts(string));
            if (this.config.isUseAccountWithMostTrafficLeft()) {
                Collections.sort(arrayList, COMPARE_MOST_TRAFFIC_LEFT);
            }
            for (Account account2 : arrayList) {
                if (account2.isTempDisabled() || !account2.isEnabled() || !account2.isValid() || this.isAccountBlocked(account2)) continue;
                account = account2;
                break;
            }
        }
        return account;
    }
}

