/*
 * Decompiled with CFR 0.152.
 */
package de.savemytube.prog.gui;

import de.savemytube.prog.gui.ProgressDialog;
import de.savemytube.prog.gui.ProgressMonitor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressUtil {
    public static ProgressMonitor createModalProgressMonitor(Component component, int n, boolean bl, int n2) {
        ProgressMonitor progressMonitor = new ProgressMonitor(n, bl, n2);
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        progressMonitor.addChangeListener(new MonitorListener(window, progressMonitor));
        return progressMonitor;
    }

    static class MonitorListener
    implements ChangeListener,
    ActionListener {
        ProgressMonitor monitor;
        Window owner;
        Timer timer;

        public MonitorListener(Window window, ProgressMonitor progressMonitor) {
            this.owner = window;
            this.monitor = progressMonitor;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ProgressMonitor progressMonitor = (ProgressMonitor)changeEvent.getSource();
            if (progressMonitor.getCurrent() != progressMonitor.getTotal()) {
                if (this.timer == null) {
                    this.timer = new Timer(progressMonitor.getMilliSecondsToWait(), this);
                    this.timer.setRepeats(false);
                    this.timer.start();
                }
            } else {
                if (this.timer != null && this.timer.isRunning()) {
                    this.timer.stop();
                }
                progressMonitor.removeChangeListener(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.monitor.removeChangeListener(this);
            ProgressDialog progressDialog = null;
            progressDialog = this.owner instanceof Frame ? new ProgressDialog((Frame)this.owner, this.monitor) : new ProgressDialog((Dialog)this.owner, this.monitor);
            progressDialog.pack();
            progressDialog.setLocationRelativeTo(null);
            progressDialog.setVisible(true);
        }
    }
}

