/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Locale;
import net.jcip.annotations.Immutable;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;

@Immutable
public class RFC2109DomainHandler
implements CookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        if (setCookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (string == null) {
            throw new MalformedCookieException("Missing value for domain attribute");
        }
        if (string.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for domain attribute");
        }
        setCookie.setDomain(string);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (cookieOrigin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        String string = cookieOrigin.getHost();
        String string2 = cookie.getDomain();
        if (string2 == null) {
            throw new MalformedCookieException("Cookie domain may not be null");
        }
        if (!string2.equals(string)) {
            int n = string2.indexOf(46);
            if (n == -1) {
                throw new MalformedCookieException("Domain attribute \"" + string2 + "\" does not match the host \"" + string + "\"");
            }
            if (!string2.startsWith(".")) {
                throw new MalformedCookieException("Domain attribute \"" + string2 + "\" violates RFC 2109: domain must start with a dot");
            }
            n = string2.indexOf(46, 1);
            if (n < 0 || n == string2.length() - 1) {
                throw new MalformedCookieException("Domain attribute \"" + string2 + "\" violates RFC 2109: domain must contain an embedded dot");
            }
            if (!(string = string.toLowerCase(Locale.ENGLISH)).endsWith(string2)) {
                throw new MalformedCookieException("Illegal domain attribute \"" + string2 + "\". Domain of origin: \"" + string + "\"");
            }
            String string3 = string.substring(0, string.length() - string2.length());
            if (string3.indexOf(46) != -1) {
                throw new MalformedCookieException("Domain attribute \"" + string2 + "\" violates RFC 2109: host minus domain may not contain any dots");
            }
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (cookieOrigin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        String string = cookieOrigin.getHost();
        String string2 = cookie.getDomain();
        if (string2 == null) {
            return false;
        }
        return string.equals(string2) || string2.startsWith(".") && string.endsWith(string2);
    }
}

