/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import net.jcip.annotations.Immutable;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;

@Immutable
public class BasicPathHandler
implements CookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        if (setCookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (string == null || string.trim().length() == 0) {
            string = "/";
        }
        setCookie.setPath(string);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        if (!this.match(cookie, cookieOrigin)) {
            throw new MalformedCookieException("Illegal path attribute \"" + cookie.getPath() + "\". Path of origin: \"" + cookieOrigin.getPath() + "\"");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        boolean bl;
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (cookieOrigin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        String string = cookieOrigin.getPath();
        String string2 = cookie.getPath();
        if (string2 == null) {
            string2 = "/";
        }
        if (string2.length() > 1 && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((bl = string.startsWith(string2)) && string.length() != string2.length() && !string2.endsWith("/")) {
            bl = string.charAt(string2.length()) == '/';
        }
        return bl;
    }
}

