/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.util;

import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;

@Immutable
public class InetAddressUtils {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    private InetAddressUtils() {
    }

    public static boolean isIPv4Address(String string) {
        return IPV4_PATTERN.matcher(string).matches();
    }

    public static boolean isIPv6StdAddress(String string) {
        return IPV6_STD_PATTERN.matcher(string).matches();
    }

    public static boolean isIPv6HexCompressedAddress(String string) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(string).matches();
    }

    public static boolean isIPv6Address(String string) {
        return InetAddressUtils.isIPv6StdAddress(string) || InetAddressUtils.isIPv6HexCompressedAddress(string);
    }
}

