/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import net.jcip.annotations.NotThreadSafe;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.HostNameResolver;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

@NotThreadSafe
public class SSLSocketFactory
implements LayeredSocketFactory {
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";
    public static final String SSLV2 = "SSLv2";
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new AllowAllHostnameVerifier();
    public static final X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = new BrowserCompatHostnameVerifier();
    public static final X509HostnameVerifier STRICT_HOSTNAME_VERIFIER = new StrictHostnameVerifier();
    private static final SSLSocketFactory DEFAULT_FACTORY = new SSLSocketFactory();
    private final SSLContext sslcontext;
    private final javax.net.ssl.SSLSocketFactory socketfactory;
    private final HostNameResolver nameResolver;
    private volatile X509HostnameVerifier hostnameVerifier = BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;

    public static SSLSocketFactory getSocketFactory() {
        return DEFAULT_FACTORY;
    }

    public SSLSocketFactory(String string, KeyStore keyStore, String string2, KeyStore keyStore2, SecureRandom secureRandom, HostNameResolver hostNameResolver) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        if (string == null) {
            string = TLS;
        }
        KeyManager[] keyManagerArray = null;
        if (keyStore != null) {
            keyManagerArray = SSLSocketFactory.createKeyManagers(keyStore, string2);
        }
        TrustManager[] trustManagerArray = null;
        if (keyStore2 != null) {
            trustManagerArray = SSLSocketFactory.createTrustManagers(keyStore2);
        }
        this.sslcontext = SSLContext.getInstance(string);
        this.sslcontext.init(keyManagerArray, trustManagerArray, secureRandom);
        this.socketfactory = this.sslcontext.getSocketFactory();
        this.nameResolver = hostNameResolver;
    }

    public SSLSocketFactory(KeyStore keyStore, String string, KeyStore keyStore2) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, keyStore, string, keyStore2, null, null);
    }

    public SSLSocketFactory(KeyStore keyStore, String string) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, keyStore, string, null, null, null);
    }

    public SSLSocketFactory(KeyStore keyStore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, null, null, keyStore, null, null);
    }

    public SSLSocketFactory(SSLContext sSLContext, HostNameResolver hostNameResolver) {
        this.sslcontext = sSLContext;
        this.socketfactory = this.sslcontext.getSocketFactory();
        this.nameResolver = hostNameResolver;
    }

    public SSLSocketFactory(SSLContext sSLContext) {
        this(sSLContext, null);
    }

    private SSLSocketFactory() {
        this.sslcontext = null;
        this.socketfactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        this.nameResolver = null;
    }

    private static KeyManager[] createKeyManagers(KeyStore keyStore, String string) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keyStore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, string != null ? string.toCharArray() : null);
        return keyManagerFactory.getKeyManagers();
    }

    private static TrustManager[] createTrustManagers(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException {
        if (keyStore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    @Override
    public Socket createSocket() throws IOException {
        return (SSLSocket)this.socketfactory.createSocket();
    }

    @Override
    public Socket connectSocket(Socket socket, String string, int n, InetAddress inetAddress, int n2, HttpParams httpParams) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters may not be null.");
        }
        SSLSocket sSLSocket = (SSLSocket)(socket != null ? socket : this.createSocket());
        if (inetAddress != null || n2 > 0) {
            if (n2 < 0) {
                n2 = 0;
            }
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
            sSLSocket.bind(inetSocketAddress);
        }
        int n3 = HttpConnectionParams.getConnectionTimeout((HttpParams)httpParams);
        int n4 = HttpConnectionParams.getSoTimeout((HttpParams)httpParams);
        InetSocketAddress inetSocketAddress = this.nameResolver != null ? new InetSocketAddress(this.nameResolver.resolve(string), n) : new InetSocketAddress(string, n);
        try {
            sSLSocket.connect(inetSocketAddress, n3);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new ConnectTimeoutException("Connect to " + inetSocketAddress + " timed out");
        }
        sSLSocket.setSoTimeout(n4);
        try {
            this.hostnameVerifier.verify(string, sSLSocket);
        }
        catch (IOException iOException) {
            try {
                sSLSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
        return sSLSocket;
    }

    @Override
    public boolean isSecure(Socket socket) throws IllegalArgumentException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null.");
        }
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException("Socket not created by this factory.");
        }
        if (socket.isClosed()) {
            throw new IllegalArgumentException("Socket is closed.");
        }
        return true;
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        SSLSocket sSLSocket = (SSLSocket)this.socketfactory.createSocket(socket, string, n, bl);
        this.hostnameVerifier.verify(string, sSLSocket);
        return sSLSocket;
    }

    public void setHostnameVerifier(X509HostnameVerifier x509HostnameVerifier) {
        if (x509HostnameVerifier == null) {
            throw new IllegalArgumentException("Hostname verifier may not be null");
        }
        this.hostnameVerifier = x509HostnameVerifier;
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }
}

