/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import net.jcip.annotations.Immutable;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.conn.util.InetAddressUtils;

@Immutable
public abstract class AbstractVerifier
implements X509HostnameVerifier {
    private static final String[] BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};

    @Override
    public final void verify(String string, SSLSocket sSLSocket) throws IOException {
        Certificate[] certificateArray;
        if (string == null) {
            throw new NullPointerException("host to verify is null");
        }
        SSLSession sSLSession = sSLSocket.getSession();
        if (sSLSession == null) {
            certificateArray = sSLSocket.getInputStream();
            certificateArray.available();
            sSLSession = sSLSocket.getSession();
            if (sSLSession == null) {
                sSLSocket.startHandshake();
                sSLSession = sSLSocket.getSession();
            }
        }
        certificateArray = sSLSession.getPeerCertificates();
        X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
        this.verify(string, x509Certificate);
    }

    @Override
    public final boolean verify(String string, SSLSession sSLSession) {
        try {
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            this.verify(string, x509Certificate);
            return true;
        }
        catch (SSLException sSLException) {
            return false;
        }
    }

    @Override
    public final void verify(String string, X509Certificate x509Certificate) throws SSLException {
        String[] stringArray = AbstractVerifier.getCNs(x509Certificate);
        String[] stringArray2 = AbstractVerifier.getSubjectAlts(x509Certificate, string);
        this.verify(string, stringArray, stringArray2);
    }

    public final void verify(String string, String[] stringArray, String[] stringArray2, boolean bl) throws SSLException {
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            linkedList.add(stringArray[0]);
        }
        if (stringArray2 != null) {
            for (String object22 : stringArray2) {
                if (object22 == null) continue;
                linkedList.add(object22);
            }
        }
        if (linkedList.isEmpty()) {
            object = "Certificate for <" + string + "> doesn't contain CN or DNS subjectAlt";
            throw new SSLException((String)object);
        }
        object = new StringBuffer();
        String string2 = string.trim().toLowerCase(Locale.ENGLISH);
        int n = 0;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            String string3 = (String)iterator.next();
            string3 = string3.toLowerCase(Locale.ENGLISH);
            ((StringBuffer)object).append(" <");
            ((StringBuffer)object).append(string3);
            ((StringBuffer)object).append('>');
            if (iterator.hasNext()) {
                ((StringBuffer)object).append(" OR");
            }
            boolean bl3 = bl2 = string3.startsWith("*.") && string3.lastIndexOf(46) >= 0 && AbstractVerifier.acceptableCountryWildcard(string3) && !AbstractVerifier.isIPAddress(string);
            if (bl2) {
                n = string2.endsWith(string3.substring(1)) ? 1 : 0;
                if (n != 0 && bl) {
                    n = AbstractVerifier.countDots(string2) == AbstractVerifier.countDots(string3) ? 1 : 0;
                }
            } else {
                n = string2.equals(string3) ? 1 : 0;
            }
            if (n == 0) continue;
            break;
        }
        if (n == 0) {
            throw new SSLException("hostname in certificate didn't match: <" + string + "> !=" + object);
        }
    }

    public static boolean acceptableCountryWildcard(String string) {
        int n = string.length();
        if (n >= 7 && n <= 9 && string.charAt(n - 3) == '.') {
            String string2 = string.substring(2, n - 3);
            int n2 = Arrays.binarySearch(BAD_COUNTRY_2LDS, string2);
            return n2 < 0;
        }
        return true;
    }

    public static String[] getCNs(X509Certificate x509Certificate) {
        String[] stringArray;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = x509Certificate.getSubjectX500Principal().toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            int n = stringArray.indexOf("CN=");
            if (n < 0) continue;
            linkedList.add(stringArray.substring(n + 3));
        }
        if (!linkedList.isEmpty()) {
            stringArray = new String[linkedList.size()];
            linkedList.toArray(stringArray);
            return stringArray;
        }
        return null;
    }

    private static String[] getSubjectAlts(X509Certificate x509Certificate, String string) {
        int n = AbstractVerifier.isIPAddress(string) ? 7 : 2;
        LinkedList<String> linkedList = new LinkedList<String>();
        Collection<List<?>> collection = null;
        try {
            collection = x509Certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {
            Logger.getLogger(AbstractVerifier.class.getName()).log(Level.FINE, "Error parsing certificate.", certificateParsingException);
        }
        if (collection != null) {
            for (List list : collection) {
                List list2 = list;
                int n2 = (Integer)list2.get(0);
                if (n2 != n) continue;
                String string2 = (String)list2.get(1);
                linkedList.add(string2);
            }
        }
        if (!linkedList.isEmpty()) {
            String[] stringArray = new String[linkedList.size()];
            linkedList.toArray(stringArray);
            return stringArray;
        }
        return null;
    }

    public static String[] getDNSSubjectAlts(X509Certificate x509Certificate) {
        return AbstractVerifier.getSubjectAlts(x509Certificate, null);
    }

    public static int countDots(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            ++n;
        }
        return n;
    }

    private static boolean isIPAddress(String string) {
        return string != null && (InetAddressUtils.isIPv4Address(string) || InetAddressUtils.isIPv6Address(string));
    }

    static {
        Arrays.sort(BAD_COUNTRY_2LDS);
    }
}

