/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.scheme;

import java.util.Locale;
import net.jcip.annotations.Immutable;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.util.LangUtils;

@Immutable
public final class Scheme {
    private final String name;
    private final SocketFactory socketFactory;
    private final int defaultPort;
    private final boolean layered;
    private String stringRep;

    public Scheme(String string, SocketFactory socketFactory, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Scheme name may not be null");
        }
        if (socketFactory == null) {
            throw new IllegalArgumentException("Socket factory may not be null");
        }
        if (n <= 0 || n > 65535) {
            throw new IllegalArgumentException("Port is invalid: " + n);
        }
        this.name = string.toLowerCase(Locale.ENGLISH);
        this.socketFactory = socketFactory;
        this.defaultPort = n;
        this.layered = socketFactory instanceof LayeredSocketFactory;
    }

    public final int getDefaultPort() {
        return this.defaultPort;
    }

    public final SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isLayered() {
        return this.layered;
    }

    public final int resolvePort(int n) {
        return n <= 0 ? this.defaultPort : n;
    }

    public final String toString() {
        if (this.stringRep == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.name);
            stringBuilder.append(':');
            stringBuilder.append(Integer.toString(this.defaultPort));
            this.stringRep = stringBuilder.toString();
        }
        return this.stringRep;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Scheme)) {
            return false;
        }
        Scheme scheme = (Scheme)object;
        return this.name.equals(scheme.name) && this.defaultPort == scheme.defaultPort && this.layered == scheme.layered && this.socketFactory.equals(scheme.socketFactory);
    }

    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode((int)n, (int)this.defaultPort);
        n = LangUtils.hashCode((int)n, (Object)this.name);
        n = LangUtils.hashCode((int)n, (boolean)this.layered);
        n = LangUtils.hashCode((int)n, (Object)this.socketFactory);
        return n;
    }
}

