/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.routing;

import java.net.InetAddress;
import net.jcip.annotations.NotThreadSafe;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteInfo;

@NotThreadSafe
public final class RouteTracker
implements RouteInfo,
Cloneable {
    private final HttpHost targetHost;
    private final InetAddress localAddress;
    private boolean connected;
    private HttpHost[] proxyChain;
    private RouteInfo.TunnelType tunnelled;
    private RouteInfo.LayerType layered;
    private boolean secure;

    public RouteTracker(HttpHost httpHost, InetAddress inetAddress) {
        if (httpHost == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        this.targetHost = httpHost;
        this.localAddress = inetAddress;
        this.tunnelled = RouteInfo.TunnelType.PLAIN;
        this.layered = RouteInfo.LayerType.PLAIN;
    }

    public RouteTracker(HttpRoute httpRoute) {
        this(httpRoute.getTargetHost(), httpRoute.getLocalAddress());
    }

    public final void connectTarget(boolean bl) {
        if (this.connected) {
            throw new IllegalStateException("Already connected.");
        }
        this.connected = true;
        this.secure = bl;
    }

    public final void connectProxy(HttpHost httpHost, boolean bl) {
        if (httpHost == null) {
            throw new IllegalArgumentException("Proxy host may not be null.");
        }
        if (this.connected) {
            throw new IllegalStateException("Already connected.");
        }
        this.connected = true;
        this.proxyChain = new HttpHost[]{httpHost};
        this.secure = bl;
    }

    public final void tunnelTarget(boolean bl) {
        if (!this.connected) {
            throw new IllegalStateException("No tunnel unless connected.");
        }
        if (this.proxyChain == null) {
            throw new IllegalStateException("No tunnel without proxy.");
        }
        this.tunnelled = RouteInfo.TunnelType.TUNNELLED;
        this.secure = bl;
    }

    public final void tunnelProxy(HttpHost httpHost, boolean bl) {
        if (httpHost == null) {
            throw new IllegalArgumentException("Proxy host may not be null.");
        }
        if (!this.connected) {
            throw new IllegalStateException("No tunnel unless connected.");
        }
        if (this.proxyChain == null) {
            throw new IllegalStateException("No proxy tunnel without proxy.");
        }
        HttpHost[] httpHostArray = new HttpHost[this.proxyChain.length + 1];
        System.arraycopy(this.proxyChain, 0, httpHostArray, 0, this.proxyChain.length);
        httpHostArray[httpHostArray.length - 1] = httpHost;
        this.proxyChain = httpHostArray;
        this.secure = bl;
    }

    public final void layerProtocol(boolean bl) {
        if (!this.connected) {
            throw new IllegalStateException("No layered protocol unless connected.");
        }
        this.layered = RouteInfo.LayerType.LAYERED;
        this.secure = bl;
    }

    @Override
    public final HttpHost getTargetHost() {
        return this.targetHost;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public final int getHopCount() {
        int n = 0;
        if (this.connected) {
            n = this.proxyChain == null ? 1 : this.proxyChain.length + 1;
        }
        return n;
    }

    @Override
    public final HttpHost getHopTarget(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Hop index must not be negative: " + n);
        }
        int n2 = this.getHopCount();
        if (n >= n2) {
            throw new IllegalArgumentException("Hop index " + n + " exceeds tracked route length " + n2 + ".");
        }
        HttpHost httpHost = null;
        httpHost = n < n2 - 1 ? this.proxyChain[n] : this.targetHost;
        return httpHost;
    }

    @Override
    public final HttpHost getProxyHost() {
        return this.proxyChain == null ? null : this.proxyChain[0];
    }

    public final boolean isConnected() {
        return this.connected;
    }

    @Override
    public final RouteInfo.TunnelType getTunnelType() {
        return this.tunnelled;
    }

    @Override
    public final boolean isTunnelled() {
        return this.tunnelled == RouteInfo.TunnelType.TUNNELLED;
    }

    @Override
    public final RouteInfo.LayerType getLayerType() {
        return this.layered;
    }

    @Override
    public final boolean isLayered() {
        return this.layered == RouteInfo.LayerType.LAYERED;
    }

    @Override
    public final boolean isSecure() {
        return this.secure;
    }

    public final HttpRoute toRoute() {
        return !this.connected ? null : new HttpRoute(this.targetHost, this.localAddress, this.proxyChain, this.secure, this.tunnelled, this.layered);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RouteTracker)) {
            return false;
        }
        RouteTracker routeTracker = (RouteTracker)object;
        boolean bl = this.targetHost.equals((Object)routeTracker.targetHost);
        bl &= this.localAddress == routeTracker.localAddress || this.localAddress != null && this.localAddress.equals(routeTracker.localAddress);
        bl &= this.proxyChain == routeTracker.proxyChain || this.proxyChain != null && routeTracker.proxyChain != null && this.proxyChain.length == routeTracker.proxyChain.length;
        if ((bl &= this.connected == routeTracker.connected && this.secure == routeTracker.secure && this.tunnelled == routeTracker.tunnelled && this.layered == routeTracker.layered) && this.proxyChain != null) {
            for (int i = 0; bl && i < this.proxyChain.length; ++i) {
                bl = this.proxyChain[i].equals((Object)routeTracker.proxyChain[i]);
            }
        }
        return bl;
    }

    public final int hashCode() {
        int n = this.targetHost.hashCode();
        if (this.localAddress != null) {
            n ^= this.localAddress.hashCode();
        }
        if (this.proxyChain != null) {
            n ^= this.proxyChain.length;
            for (int i = 0; i < this.proxyChain.length; ++i) {
                n ^= this.proxyChain[i].hashCode();
            }
        }
        if (this.connected) {
            n ^= 0x11111111;
        }
        if (this.secure) {
            n ^= 0x22222222;
        }
        n ^= this.tunnelled.hashCode();
        return n ^= this.layered.hashCode();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(50 + this.getHopCount() * 30);
        stringBuilder.append("RouteTracker[");
        if (this.localAddress != null) {
            stringBuilder.append(this.localAddress);
            stringBuilder.append("->");
        }
        stringBuilder.append('{');
        if (this.connected) {
            stringBuilder.append('c');
        }
        if (this.tunnelled == RouteInfo.TunnelType.TUNNELLED) {
            stringBuilder.append('t');
        }
        if (this.layered == RouteInfo.LayerType.LAYERED) {
            stringBuilder.append('l');
        }
        if (this.secure) {
            stringBuilder.append('s');
        }
        stringBuilder.append("}->");
        if (this.proxyChain != null) {
            for (int i = 0; i < this.proxyChain.length; ++i) {
                stringBuilder.append(this.proxyChain[i]);
                stringBuilder.append("->");
            }
        }
        stringBuilder.append(this.targetHost);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

