/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.icc;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.icc.IccDirectory;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class IccReader
implements MetadataReader {
    @Override
    public void extract(@NotNull BufferReader bufferReader, @NotNull Metadata metadata) {
        IccDirectory iccDirectory = metadata.getOrCreateDirectory(IccDirectory.class);
        try {
            iccDirectory.setInt(0, bufferReader.getInt32(0));
            this.set4ByteString(iccDirectory, 4, bufferReader);
            this.setInt32(iccDirectory, 8, bufferReader);
            this.set4ByteString(iccDirectory, 12, bufferReader);
            this.set4ByteString(iccDirectory, 16, bufferReader);
            this.set4ByteString(iccDirectory, 20, bufferReader);
            this.setDate(iccDirectory, 24, bufferReader);
            this.set4ByteString(iccDirectory, 36, bufferReader);
            this.set4ByteString(iccDirectory, 40, bufferReader);
            this.setInt32(iccDirectory, 44, bufferReader);
            this.set4ByteString(iccDirectory, 48, bufferReader);
            int n = bufferReader.getInt32(52);
            if (n != 0) {
                if (n <= 0x20202020) {
                    iccDirectory.setInt(52, n);
                } else {
                    iccDirectory.setString(52, IccReader.getStringFromInt32(n));
                }
            }
            this.setInt32(iccDirectory, 64, bufferReader);
            this.setInt64(iccDirectory, 56, bufferReader);
            float[] fArray = new float[]{bufferReader.getS15Fixed16(68), bufferReader.getS15Fixed16(72), bufferReader.getS15Fixed16(76)};
            iccDirectory.setObject(68, fArray);
            int n2 = bufferReader.getInt32(128);
            iccDirectory.setInt(128, n2);
            for (int i = 0; i < n2; ++i) {
                int n3 = 132 + i * 12;
                int n4 = bufferReader.getInt32(n3);
                int n5 = bufferReader.getInt32(n3 + 4);
                int n6 = bufferReader.getInt32(n3 + 8);
                byte[] byArray = bufferReader.getBytes(n5, n6);
                iccDirectory.setByteArray(n4, byArray);
            }
        }
        catch (BufferBoundsException bufferBoundsException) {
            iccDirectory.addError(String.format("Reading ICC Header %s:%s", bufferBoundsException.getClass().getSimpleName(), bufferBoundsException.getMessage()));
        }
    }

    private void set4ByteString(@NotNull Directory directory, int n, @NotNull BufferReader bufferReader) throws BufferBoundsException {
        int n2 = bufferReader.getInt32(n);
        if (n2 != 0) {
            directory.setString(n, IccReader.getStringFromInt32(n2));
        }
    }

    private void setInt32(@NotNull Directory directory, int n, @NotNull BufferReader bufferReader) throws BufferBoundsException {
        int n2 = bufferReader.getInt32(n);
        if (n2 != 0) {
            directory.setInt(n, n2);
        }
    }

    private void setInt64(@NotNull Directory directory, int n, @NotNull BufferReader bufferReader) throws BufferBoundsException {
        long l = bufferReader.getInt64(n);
        if (l != 0L) {
            directory.setLong(n, l);
        }
    }

    private void setDate(@NotNull IccDirectory iccDirectory, int n, @NotNull BufferReader bufferReader) throws BufferBoundsException {
        int n2 = bufferReader.getUInt16(n);
        int n3 = bufferReader.getUInt16(n + 2);
        int n4 = bufferReader.getUInt16(n + 4);
        int n5 = bufferReader.getUInt16(n + 6);
        int n6 = bufferReader.getUInt16(n + 8);
        int n7 = bufferReader.getUInt16(n + 10);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(n2, n3, n4, n5, n6, n7);
        Date date = calendar.getTime();
        iccDirectory.setDate(n, date);
    }

    @NotNull
    public static String getStringFromInt32(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        return new String(byArray);
    }
}

