/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria.db;

import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.alexandria.db.LibraryDatabase;
import java.util.ArrayList;
import java.util.List;

public class PlaylistItemDB {
    private PlaylistItemDB() {
    }

    public static void fill(LibraryDatabase libraryDatabase, PlaylistItem playlistItem) {
        List<List<Object>> list = libraryDatabase.query("SELECT playlistItemId, filePath, fileName, fileSize, fileExtension, trackTitle, trackDurationInSecs, trackArtist, trackAlbum, coverArtPath, trackBitrate, trackComment, trackGenre, trackNumber, trackYear, starred FROM PlaylistItems WHERE playlistItemId = ?", playlistItem.getId());
        if (list.size() > 0) {
            List<Object> list2 = list.get(0);
            PlaylistItemDB.fill(list2, playlistItem);
        }
    }

    public static void fill(List<Object> list, PlaylistItem playlistItem) {
        int n = (Integer)list.get(0);
        String string = (String)list.get(1);
        String string2 = (String)list.get(2);
        long l = (Long)list.get(3);
        String string3 = (String)list.get(4);
        String string4 = (String)list.get(5);
        float f = ((Float)list.get(6)).floatValue();
        String string5 = (String)list.get(7);
        String string6 = (String)list.get(8);
        String string7 = (String)list.get(9);
        String string8 = (String)list.get(10);
        String string9 = (String)list.get(11);
        String string10 = (String)list.get(12);
        String string11 = (String)list.get(13);
        String string12 = (String)list.get(14);
        boolean bl = (Boolean)list.get(15);
        int n2 = list.size() < 17 || (Integer)list.get(16) == null ? 0 : (Integer)list.get(16);
        playlistItem.setId(n);
        playlistItem.setFilePath(string);
        playlistItem.setFileName(string2);
        playlistItem.setFileSize(l);
        playlistItem.setFileExtension(string3);
        playlistItem.setTrackTitle(string4);
        playlistItem.setTrackDurationInSecs(f);
        playlistItem.setTrackArtist(string5);
        playlistItem.setTrackAlbum(string6);
        playlistItem.setCoverArtPath(string7);
        playlistItem.setTrackBitrate(string8);
        playlistItem.setTrackComment(string9);
        playlistItem.setTrackGenre(string10);
        playlistItem.setTrackNumber(string11);
        playlistItem.setTrackYear(string12);
        playlistItem.setStarred(bl);
        playlistItem.setSortIndex(n2);
    }

    public static void save(LibraryDatabase libraryDatabase, PlaylistItem playlistItem) {
        if (playlistItem.getId() == -2 || playlistItem.getPlaylist() == null) {
            return;
        }
        if (playlistItem.getId() == -1) {
            playlistItem.setStarred(PlaylistItemDB.isStarred(libraryDatabase, playlistItem) || playlistItem.isStarred());
            Object[] objectArray = PlaylistItemDB.createPlaylistItemInsert(playlistItem);
            int n = libraryDatabase.insert((String)objectArray[0], (Object[])objectArray[1]);
            playlistItem.setId(n);
            objectArray = PlaylistItemDB.updateStarred(playlistItem);
            libraryDatabase.update((String)objectArray[0], (Object[])objectArray[1]);
        } else {
            Object[] objectArray = PlaylistItemDB.createPlaylistItemUpdate(playlistItem);
            libraryDatabase.update((String)objectArray[0], (Object[])objectArray[1]);
            objectArray = PlaylistItemDB.updateStarred(playlistItem);
            libraryDatabase.update((String)objectArray[0], (Object[])objectArray[1]);
        }
    }

    public static void delete(LibraryDatabase libraryDatabase, PlaylistItem playlistItem) {
        libraryDatabase.update("DELETE FROM PlaylistItems WHERE playlistItemId = ?", playlistItem.getId());
    }

    public static List<PlaylistItem> getPlaylistItems(LibraryDatabase libraryDatabase, Playlist playlist) {
        String string = "SELECT playlistItemId, filePath, fileName, fileSize, fileExtension, trackTitle, trackDurationInSecs, trackArtist, trackAlbum, coverArtPath, trackBitrate, trackComment, trackGenre, trackNumber, trackYear, starred, sortIndex FROM PlaylistItems WHERE playlistId = ? ORDER BY sortIndex ASC";
        List<List<Object>> list = libraryDatabase.query(string, playlist.getId());
        ArrayList<PlaylistItem> arrayList = new ArrayList<PlaylistItem>(list.size());
        for (List<Object> list2 : list) {
            PlaylistItem playlistItem = new PlaylistItem(playlist);
            PlaylistItemDB.fill(list2, playlistItem);
            arrayList.add(playlistItem);
        }
        return arrayList;
    }

    private static Object[] createPlaylistItemInsert(PlaylistItem playlistItem) {
        String string = "INSERT INTO PlaylistItems (playlistId, filePath, fileName, fileSize, fileExtension, trackTitle, trackDurationInSecs, trackArtist, trackAlbum, coverArtPath, trackBitrate, trackComment, trackGenre, trackNumber, trackYear, starred, sortIndex)  VALUES (?, LEFT(?, 10000), LEFT(?, 500), ?, LEFT(?, 10), LEFT(?, 500), ?, LEFT(?, 500), LEFT(?, 500), LEFT(?, 10000), LEFT(?, 10), LEFT(?, 500), LEFT(?, 20), LEFT(?, 6), LEFT(?, 6), ?, ?)";
        Object[] objectArray = new Object[]{playlistItem.getPlaylist().getId(), playlistItem.getFilePath(), playlistItem.getFileName(), playlistItem.getFileSize(), playlistItem.getFileExtension(), playlistItem.getTrackTitle(), Float.valueOf(playlistItem.getTrackDurationInSecs()), playlistItem.getTrackArtist(), playlistItem.getTrackAlbum(), playlistItem.getCoverArtPath(), playlistItem.getTrackBitrate(), playlistItem.getTrackComment(), playlistItem.getTrackGenre(), playlistItem.getTrackNumber(), playlistItem.getTrackYear(), playlistItem.isStarred(), playlistItem.getSortIndex()};
        return new Object[]{string, objectArray};
    }

    private static Object[] createPlaylistItemUpdate(PlaylistItem playlistItem) {
        String string = "UPDATE PlaylistItems SET filePath = LEFT(?, 10000), fileName = LEFT(?, 500), fileSize = ?, fileExtension = LEFT(?, 10), trackTitle = LEFT(?, 500), trackDurationInSecs = ?, trackArtist = LEFT(?, 500), trackAlbum = LEFT(?, 500), coverArtPath = LEFT(?, 10000), trackBitrate = LEFT(?, 10), trackComment = LEFT(?, 500), trackGenre = LEFT(?, 20), trackNumber = LEFT(?, 6), trackYear = LEFT(?, 6), starred = ?, sortIndex = ? WHERE playlistItemId = ?";
        Object[] objectArray = new Object[]{playlistItem.getFilePath(), playlistItem.getFileName(), playlistItem.getFileSize(), playlistItem.getFileExtension(), playlistItem.getTrackTitle(), Float.valueOf(playlistItem.getTrackDurationInSecs()), playlistItem.getTrackArtist(), playlistItem.getTrackAlbum(), playlistItem.getCoverArtPath(), playlistItem.getTrackBitrate(), playlistItem.getTrackComment(), playlistItem.getTrackGenre(), playlistItem.getTrackNumber(), playlistItem.getTrackYear(), playlistItem.isStarred(), playlistItem.getSortIndex(), playlistItem.getId()};
        return new Object[]{string, objectArray};
    }

    private static Object[] updateStarred(PlaylistItem playlistItem) {
        String string = "UPDATE PlaylistItems SET starred = ? WHERE filePath = LEFT(?, 10000)";
        Object[] objectArray = new Object[]{playlistItem.isStarred(), playlistItem.getFilePath()};
        return new Object[]{string, objectArray};
    }

    private static boolean isStarred(LibraryDatabase libraryDatabase, PlaylistItem playlistItem) {
        List<List<Object>> list = libraryDatabase.query("SELECT starred FROM PlaylistItems WHERE filePath = ? LIMIT 1", playlistItem.getFilePath());
        if (list.size() > 0) {
            return (Boolean)list.get(0).get(0);
        }
        return false;
    }
}

