/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria;

import com.frostwire.alexandria.InternetRadioStation;
import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.db.InternetRadioStationDB;
import com.frostwire.alexandria.db.LibraryDB;
import com.frostwire.alexandria.db.LibraryDatabase;
import com.frostwire.alexandria.db.LibraryDatabaseEntity;
import com.frostwire.alexandria.db.PlaylistDB;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Library
extends LibraryDatabaseEntity {
    private int _id;
    private String _name;
    private int _version;

    public Library(File file) {
        super(new LibraryDatabase(file));
        LibraryDB.fill(this.db, this);
    }

    public int getId() {
        return this._id;
    }

    public void setId(int n) {
        this._id = n;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int n) {
        this._version = n;
    }

    public void close() {
        this.db.close();
    }

    public List<Playlist> getPlaylists() {
        List<Playlist> list = PlaylistDB.getPlaylists(this.db);
        Collections.sort(list, new Comparator<Playlist>(){

            @Override
            public int compare(Playlist playlist, Playlist playlist2) {
                return playlist.getName().compareTo(playlist2.getName());
            }
        });
        return list;
    }

    public Playlist getPlaylist(String string) {
        return PlaylistDB.getPlaylist(this.db, string);
    }

    public List<InternetRadioStation> getInternetRadioStations() {
        return InternetRadioStationDB.getInternetRadioStations(this.db);
    }

    public Playlist newPlaylist(String string, String string2) {
        return new Playlist(this.db, -1, string, string2);
    }

    public InternetRadioStation newInternetRadioStation(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        return new InternetRadioStation(this.db, -1, string, string2, string3, string4, string5, string6, string7, string8, bl);
    }

    public void dump() {
        this.db.dump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public Playlist getStarredPlaylist() {
        return PlaylistDB.getStarredPlaylist(this.db);
    }

    public void updatePlaylistItemProperties(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        PlaylistDB.updatePlaylistItemProperties(this.db, string, string2, string3, string4, string5, string6, string7, string8);
    }

    public long getTotalRadioStations() {
        return InternetRadioStationDB.getTotalRadioStations(this.db);
    }

    public void restoreDefaultRadioStations() {
        InternetRadioStationDB.restoreDefaultRadioStations(this.db);
    }
}

