/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.vorbiscomment;

import java.io.UnsupportedEncodingException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentFieldKey;

public class VorbisCommentTagField
implements TagTextField {
    private boolean common;
    private String content;
    private String id;
    private static final String ERRONEOUS_ID = "ERRONEOUS";

    public VorbisCommentTagField(byte[] byArray) throws UnsupportedEncodingException {
        String string = new String(byArray, "UTF-8");
        int n = string.indexOf("=");
        if (n == -1) {
            this.id = ERRONEOUS_ID;
            this.content = string;
        } else {
            this.id = string.substring(0, n).toUpperCase();
            this.content = string.length() > n ? string.substring(n + 1) : "";
        }
        this.checkCommon();
    }

    public VorbisCommentTagField(String string, String string2) {
        this.id = string.toUpperCase();
        this.content = string2;
        this.checkCommon();
    }

    private void checkCommon() {
        this.common = this.id.equals(VorbisCommentFieldKey.TITLE.getFieldName()) || this.id.equals(VorbisCommentFieldKey.ALBUM.getFieldName()) || this.id.equals(VorbisCommentFieldKey.ARTIST.getFieldName()) || this.id.equals(VorbisCommentFieldKey.GENRE.getFieldName()) || this.id.equals(VorbisCommentFieldKey.TRACKNUMBER.getFieldName()) || this.id.equals(VorbisCommentFieldKey.DATE.getFieldName()) || this.id.equals(VorbisCommentFieldKey.DESCRIPTION.getFieldName()) || this.id.equals(VorbisCommentFieldKey.COMMENT.getFieldName());
    }

    protected void copy(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
    }

    @Override
    public void copyContent(TagField tagField) {
        if (tagField instanceof TagTextField) {
            this.content = ((TagTextField)tagField).getContent();
        }
    }

    protected byte[] getBytes(String string, String string2) throws UnsupportedEncodingException {
        return string.getBytes(string2);
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public byte[] getRawContent() throws UnsupportedEncodingException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = Utils.getDefaultBytes(this.id, "ISO-8859-1");
        byte[] byArray3 = this.getBytes(this.content, "UTF-8");
        byte[] byArray4 = new byte[4 + byArray2.length + 1 + byArray3.length];
        int n = byArray2.length + 1 + byArray3.length;
        byArray[3] = (byte)((n & 0xFF000000) >> 24);
        byArray[2] = (byte)((n & 0xFF0000) >> 16);
        byArray[1] = (byte)((n & 0xFF00) >> 8);
        byArray[0] = (byte)(n & 0xFF);
        int n2 = 0;
        this.copy(byArray, byArray4, n2);
        this.copy(byArray2, byArray4, n2 += 4);
        byArray4[n2 += byArray2.length] = 61;
        this.copy(byArray3, byArray4, ++n2);
        return byArray4;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public void isBinary(boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException("OggTagFields cannot be changed to binary.\nbinary data should be stored elsewhere according to Vorbis_I_spec.");
        }
    }

    @Override
    public boolean isCommon() {
        return this.common;
    }

    @Override
    public boolean isEmpty() {
        return this.content.equals("");
    }

    @Override
    public void setContent(String string) {
        this.content = string;
    }

    @Override
    public void setEncoding(String string) {
        if (string == null || !string.equalsIgnoreCase("UTF-8")) {
            throw new UnsupportedOperationException("The encoding of OggTagFields cannot be changed.(specified to be UTF-8)");
        }
    }

    @Override
    public String toString() {
        return this.getContent();
    }
}

