/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.mp4.Mp4TagField;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public class Mp4TagBinaryField
extends Mp4TagField {
    protected int dataSize;
    protected byte[] dataBytes;
    protected boolean isBinary = false;

    public Mp4TagBinaryField(String string) {
        super(string);
    }

    public Mp4TagBinaryField(String string, byte[] byArray) {
        super(string);
        this.dataBytes = byArray;
    }

    public Mp4TagBinaryField(String string, ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        super(string, byteBuffer);
    }

    @Override
    public Mp4FieldType getFieldType() {
        return Mp4FieldType.IMPLICIT;
    }

    @Override
    protected byte[] getDataBytes() throws UnsupportedEncodingException {
        return this.dataBytes;
    }

    @Override
    protected void build(ByteBuffer byteBuffer) {
        Mp4BoxHeader mp4BoxHeader = new Mp4BoxHeader(byteBuffer);
        this.dataSize = mp4BoxHeader.getDataLength();
        byteBuffer.position(byteBuffer.position() + 8);
        this.dataBytes = new byte[this.dataSize - 8];
        for (int i = 0; i < this.dataBytes.length; ++i) {
            this.dataBytes[i] = byteBuffer.get();
        }
    }

    @Override
    public boolean isBinary() {
        return this.isBinary;
    }

    @Override
    public boolean isEmpty() {
        return this.dataBytes.length == 0;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public byte[] getData() {
        return this.dataBytes;
    }

    public void setData(byte[] byArray) {
        this.dataBytes = byArray;
    }

    @Override
    public void copyContent(TagField tagField) {
        if (tagField instanceof Mp4TagBinaryField) {
            this.dataBytes = ((Mp4TagBinaryField)tagField).getData();
            this.isBinary = tagField.isBinary();
        }
    }
}

