/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.atom.Mp4DataBox;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextNumberField;
import org.jaudiotagger.tag.reference.GenreTypes;

public class Mp4GenreField
extends Mp4TagTextNumberField {
    public Mp4GenreField(String string, ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        super(string, byteBuffer);
    }

    public static boolean isValidGenre(String string) {
        try {
            short s = Short.parseShort(string);
            if (s - 1 <= GenreTypes.getMaxStandardGenreId()) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Integer n = GenreTypes.getInstanceOf().getIdForValue(string);
        return n != null && n <= GenreTypes.getMaxStandardGenreId();
    }

    public Mp4GenreField(String string) {
        super(Mp4FieldKey.GENRE.getFieldName(), string);
        try {
            short s = Short.parseShort(string);
            if (s - 1 <= GenreTypes.getMaxStandardGenreId()) {
                this.numbers = new ArrayList();
                this.numbers.add(s);
                return;
            }
            this.numbers = new ArrayList();
            this.numbers.add((short)1);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            Integer n = GenreTypes.getInstanceOf().getIdForValue(string);
            if (n != null && n <= GenreTypes.getMaxStandardGenreId()) {
                this.numbers = new ArrayList();
                this.numbers.add((short)(n + 1));
                return;
            }
            this.numbers = new ArrayList();
            this.numbers.add((short)1);
            return;
        }
    }

    @Override
    protected void build(ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        Mp4BoxHeader mp4BoxHeader = new Mp4BoxHeader(byteBuffer);
        Mp4DataBox mp4DataBox = new Mp4DataBox(mp4BoxHeader, byteBuffer);
        this.dataSize = mp4BoxHeader.getDataLength();
        this.numbers = mp4DataBox.getNumbers();
        if (this.numbers.size() > 0) {
            short s = (Short)this.numbers.get(0);
            this.content = GenreTypes.getInstanceOf().getValueForId(s - 1);
            if (this.content == null) {
                logger.warning(ErrorMessage.MP4_GENRE_OUT_OF_RANGE.getMsg(s));
            }
        } else {
            logger.warning(ErrorMessage.MP4_NO_GENREID_FOR_GENRE.getMsg(mp4BoxHeader.getDataLength()));
        }
    }
}

