/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ArtworkFactory;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.Mp4TagField;
import org.jaudiotagger.tag.mp4.Mp4TagFieldSubType;
import org.jaudiotagger.tag.mp4.field.Mp4DiscNoField;
import org.jaudiotagger.tag.mp4.field.Mp4GenreField;
import org.jaudiotagger.tag.mp4.field.Mp4TagByteField;
import org.jaudiotagger.tag.mp4.field.Mp4TagCoverField;
import org.jaudiotagger.tag.mp4.field.Mp4TagReverseDnsField;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextField;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextNumberField;
import org.jaudiotagger.tag.mp4.field.Mp4TrackField;

public class Mp4Tag
extends AbstractTag {
    private static final EnumMap<FieldKey, Mp4FieldKey> tagFieldToMp4Field = new EnumMap(FieldKey.class);

    private TagField createGenreField(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (TagOptionSingleton.getInstance().isWriteMp4GenresAsText()) {
            return new Mp4TagTextField(Mp4FieldKey.GENRE_CUSTOM.getFieldName(), string);
        }
        if (Mp4GenreField.isValidGenre(string)) {
            return new Mp4GenreField(string);
        }
        return new Mp4TagTextField(Mp4FieldKey.GENRE_CUSTOM.getFieldName(), string);
    }

    @Override
    protected boolean isAllowedEncoding(String string) {
        return string.equals("UTF-8");
    }

    @Override
    public String toString() {
        return "Mpeg4 " + super.toString();
    }

    @Override
    public boolean hasField(FieldKey fieldKey) {
        return this.getFields(fieldKey).size() != 0;
    }

    public boolean hasField(Mp4FieldKey mp4FieldKey) {
        return this.getFields(mp4FieldKey.getFieldName()).size() != 0;
    }

    @Override
    public List<TagField> getFields(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        Mp4FieldKey mp4FieldKey = tagFieldToMp4Field.get((Object)fieldKey);
        List<TagField> list = this.getFields(mp4FieldKey.getFieldName());
        ArrayList<TagField> arrayList = new ArrayList<TagField>();
        if (fieldKey == FieldKey.GENRE) {
            if (list.size() == 0) {
                list = this.getFields(Mp4FieldKey.GENRE_CUSTOM.getFieldName());
            }
            return list;
        }
        if (fieldKey == FieldKey.TRACK) {
            for (TagField tagField : list) {
                Mp4TrackField mp4TrackField = (Mp4TrackField)tagField;
                if (mp4TrackField.getTrackNo() <= 0) continue;
                arrayList.add(tagField);
            }
            return arrayList;
        }
        if (fieldKey == FieldKey.TRACK_TOTAL) {
            for (TagField tagField : list) {
                Mp4TrackField mp4TrackField = (Mp4TrackField)tagField;
                if (mp4TrackField.getTrackTotal() <= 0) continue;
                arrayList.add(tagField);
            }
            return arrayList;
        }
        if (fieldKey == FieldKey.DISC_NO) {
            for (TagField tagField : list) {
                Mp4DiscNoField mp4DiscNoField = (Mp4DiscNoField)tagField;
                if (mp4DiscNoField.getDiscNo() <= 0) continue;
                arrayList.add(tagField);
            }
            return arrayList;
        }
        if (fieldKey == FieldKey.DISC_TOTAL) {
            for (TagField tagField : list) {
                Mp4DiscNoField mp4DiscNoField = (Mp4DiscNoField)tagField;
                if (mp4DiscNoField.getDiscTotal() <= 0) continue;
                arrayList.add(tagField);
            }
            return arrayList;
        }
        return list;
    }

    @Override
    public List<String> getAll(FieldKey fieldKey) throws KeyNotFoundException {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<TagField> list = this.getFields(fieldKey);
        for (TagField tagField : list) {
            if (fieldKey == FieldKey.TRACK) {
                arrayList.add(((Mp4TrackField)tagField).getTrackNo().toString());
                continue;
            }
            if (fieldKey == FieldKey.TRACK_TOTAL) {
                arrayList.add(((Mp4TrackField)tagField).getTrackTotal().toString());
                continue;
            }
            if (fieldKey == FieldKey.DISC_NO) {
                arrayList.add(((Mp4DiscNoField)tagField).getDiscNo().toString());
                continue;
            }
            if (fieldKey == FieldKey.DISC_TOTAL) {
                arrayList.add(((Mp4DiscNoField)tagField).getDiscTotal().toString());
                continue;
            }
            arrayList.add(tagField.toString());
        }
        return arrayList;
    }

    public List<TagField> get(Mp4FieldKey mp4FieldKey) throws KeyNotFoundException {
        if (mp4FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getFields(mp4FieldKey.getFieldName());
    }

    @Override
    public String getValue(FieldKey fieldKey, int n) throws KeyNotFoundException {
        List<TagField> list = this.getFields(fieldKey);
        if (list.size() > n) {
            TagField tagField = list.get(n);
            if (fieldKey == FieldKey.TRACK) {
                return ((Mp4TrackField)tagField).getTrackNo().toString();
            }
            if (fieldKey == FieldKey.DISC_NO) {
                return ((Mp4DiscNoField)tagField).getDiscNo().toString();
            }
            if (fieldKey == FieldKey.TRACK_TOTAL) {
                return ((Mp4TrackField)tagField).getTrackTotal().toString();
            }
            if (fieldKey == FieldKey.DISC_TOTAL) {
                return ((Mp4DiscNoField)tagField).getDiscTotal().toString();
            }
            return tagField.toString();
        }
        return "";
    }

    public String getFirst(Mp4FieldKey mp4FieldKey) throws KeyNotFoundException {
        if (mp4FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getFirst(mp4FieldKey.getFieldName());
    }

    @Override
    public Mp4TagField getFirstField(FieldKey fieldKey) throws KeyNotFoundException {
        List<TagField> list = this.getFields(fieldKey);
        if (list.size() == 0) {
            return null;
        }
        return (Mp4TagField)list.get(0);
    }

    public Mp4TagField getFirstField(Mp4FieldKey mp4FieldKey) throws KeyNotFoundException {
        if (mp4FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return (Mp4TagField)super.getFirstField(mp4FieldKey.getFieldName());
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        String string = tagFieldToMp4Field.get((Object)fieldKey).getFieldName();
        if (fieldKey == FieldKey.TRACK) {
            String string2 = this.getFirst(FieldKey.TRACK_TOTAL);
            if (string2.length() == 0) {
                super.deleteField(string);
                return;
            }
            Mp4TrackField mp4TrackField = (Mp4TrackField)this.getFirstField(FieldKey.TRACK_TOTAL);
            mp4TrackField.setTrackNo(0);
            return;
        }
        if (fieldKey == FieldKey.TRACK_TOTAL) {
            String string3 = this.getFirst(FieldKey.TRACK);
            if (string3.length() == 0) {
                super.deleteField(string);
                return;
            }
            Mp4TrackField mp4TrackField = (Mp4TrackField)this.getFirstField(FieldKey.TRACK);
            mp4TrackField.setTrackTotal(0);
            return;
        }
        if (fieldKey == FieldKey.DISC_NO) {
            String string4 = this.getFirst(FieldKey.DISC_TOTAL);
            if (string4.length() == 0) {
                super.deleteField(string);
                return;
            }
            Mp4DiscNoField mp4DiscNoField = (Mp4DiscNoField)this.getFirstField(FieldKey.DISC_TOTAL);
            mp4DiscNoField.setDiscNo(0);
            return;
        }
        if (fieldKey == FieldKey.DISC_TOTAL) {
            String string5 = this.getFirst(FieldKey.DISC_NO);
            if (string5.length() == 0) {
                super.deleteField(string);
                return;
            }
            Mp4DiscNoField mp4DiscNoField = (Mp4DiscNoField)this.getFirstField(FieldKey.DISC_NO);
            mp4DiscNoField.setDiscTotal(0);
            return;
        }
        super.deleteField(string);
    }

    public void deleteField(Mp4FieldKey mp4FieldKey) throws KeyNotFoundException {
        if (mp4FieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.deleteField(mp4FieldKey.getFieldName());
    }

    public TagField createArtworkField(byte[] byArray) {
        return new Mp4TagCoverField(byArray);
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        return new Mp4TagCoverField(artwork.getBinaryData());
    }

    @Override
    public void addField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        if (fieldKey == FieldKey.TRACK || fieldKey == FieldKey.TRACK_TOTAL || fieldKey == FieldKey.DISC_NO || fieldKey == FieldKey.DISC_TOTAL) {
            this.setField(fieldKey, string);
        } else {
            TagField tagField = this.createField(fieldKey, string);
            this.addField(tagField);
        }
    }

    @Override
    public TagField createField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        if (fieldKey == FieldKey.TRACK || fieldKey == FieldKey.TRACK_TOTAL || fieldKey == FieldKey.DISC_NO || fieldKey == FieldKey.DISC_TOTAL) {
            try {
                int n = Integer.parseInt(string);
                if (fieldKey == FieldKey.TRACK) {
                    return new Mp4TrackField(n);
                }
                if (fieldKey == FieldKey.TRACK_TOTAL) {
                    return new Mp4TrackField(0, n);
                }
                if (fieldKey == FieldKey.DISC_NO) {
                    return new Mp4DiscNoField(n);
                }
                if (fieldKey == FieldKey.DISC_TOTAL) {
                    return new Mp4DiscNoField(0, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new FieldDataInvalidException("Value " + string + " is not a number as required", numberFormatException);
            }
        }
        return this.createField(tagFieldToMp4Field.get((Object)fieldKey), string);
    }

    @Override
    public void setField(TagField tagField) {
        if (tagField == null) {
            return;
        }
        if (tagField.getId().equals(Mp4FieldKey.TRACK.getFieldName())) {
            List list = (List)this.fields.get(tagField.getId());
            if (list == null || list.size() == 0) {
                super.setField(tagField);
            } else {
                Mp4TrackField mp4TrackField = (Mp4TrackField)list.get(0);
                Mp4TrackField mp4TrackField2 = (Mp4TrackField)tagField;
                Short s = mp4TrackField.getTrackNo();
                Short s2 = mp4TrackField.getTrackTotal();
                if (mp4TrackField2.getTrackNo() > 0) {
                    s = mp4TrackField2.getTrackNo();
                }
                if (mp4TrackField2.getTrackTotal() > 0) {
                    s2 = mp4TrackField2.getTrackTotal();
                }
                Mp4TrackField mp4TrackField3 = new Mp4TrackField(s.shortValue(), s2.shortValue());
                super.setField(mp4TrackField3);
            }
        } else if (tagField.getId().equals(Mp4FieldKey.DISCNUMBER.getFieldName())) {
            List list = (List)this.fields.get(tagField.getId());
            if (list == null || list.size() == 0) {
                super.setField(tagField);
            } else {
                Mp4DiscNoField mp4DiscNoField = (Mp4DiscNoField)list.get(0);
                Mp4DiscNoField mp4DiscNoField2 = (Mp4DiscNoField)tagField;
                Short s = mp4DiscNoField.getDiscNo();
                Short s3 = mp4DiscNoField.getDiscTotal();
                if (mp4DiscNoField2.getDiscNo() > 0) {
                    s = mp4DiscNoField2.getDiscNo();
                }
                if (mp4DiscNoField2.getDiscTotal() > 0) {
                    s3 = mp4DiscNoField2.getDiscTotal();
                }
                Mp4DiscNoField mp4DiscNoField3 = new Mp4DiscNoField(s.shortValue(), s3.shortValue());
                super.setField(mp4DiscNoField3);
            }
        } else {
            super.setField(tagField);
        }
    }

    public TagField createField(Mp4FieldKey mp4FieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (mp4FieldKey == null) {
            throw new KeyNotFoundException();
        }
        if (mp4FieldKey == Mp4FieldKey.COMPILATION) {
            if (string.equals("true")) {
                string = Mp4TagByteField.TRUE_VALUE;
            }
            return new Mp4TagByteField(mp4FieldKey, string, mp4FieldKey.getFieldLength());
        }
        if (mp4FieldKey == Mp4FieldKey.GENRE) {
            return this.createGenreField(string);
        }
        if (mp4FieldKey.getSubClassFieldType() == Mp4TagFieldSubType.DISC_NO) {
            return new Mp4DiscNoField(string);
        }
        if (mp4FieldKey.getSubClassFieldType() == Mp4TagFieldSubType.TRACK_NO) {
            return new Mp4TrackField(string);
        }
        if (mp4FieldKey.getSubClassFieldType() == Mp4TagFieldSubType.BYTE) {
            return new Mp4TagByteField(mp4FieldKey, string, mp4FieldKey.getFieldLength());
        }
        if (mp4FieldKey.getSubClassFieldType() == Mp4TagFieldSubType.NUMBER) {
            return new Mp4TagTextNumberField(mp4FieldKey.getFieldName(), string);
        }
        if (mp4FieldKey.getSubClassFieldType() == Mp4TagFieldSubType.REVERSE_DNS) {
            return new Mp4TagReverseDnsField(mp4FieldKey, string);
        }
        if (mp4FieldKey.getSubClassFieldType() == Mp4TagFieldSubType.ARTWORK) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        if (mp4FieldKey.getSubClassFieldType() == Mp4TagFieldSubType.TEXT) {
            return new Mp4TagTextField(mp4FieldKey.getFieldName(), string);
        }
        if (mp4FieldKey.getSubClassFieldType() == Mp4TagFieldSubType.UNKNOWN) {
            throw new UnsupportedOperationException(ErrorMessage.DO_NOT_KNOW_HOW_TO_CREATE_THIS_ATOM_TYPE.getMsg(mp4FieldKey.getFieldName()));
        }
        throw new UnsupportedOperationException(ErrorMessage.DO_NOT_KNOW_HOW_TO_CREATE_THIS_ATOM_TYPE.getMsg(mp4FieldKey.getFieldName()));
    }

    @Override
    public List<Artwork> getArtworkList() {
        List<TagField> list = this.get(Mp4FieldKey.ARTWORK);
        ArrayList<Artwork> arrayList = new ArrayList<Artwork>(list.size());
        for (TagField tagField : list) {
            Mp4TagCoverField mp4TagCoverField = (Mp4TagCoverField)tagField;
            Artwork artwork = ArtworkFactory.getNew();
            artwork.setBinaryData(mp4TagCoverField.getData());
            artwork.setMimeType(Mp4TagCoverField.getMimeTypeForImageType(mp4TagCoverField.getFieldType()));
            arrayList.add(artwork);
        }
        return arrayList;
    }

    static {
        tagFieldToMp4Field.put(FieldKey.ALBUM, Mp4FieldKey.ALBUM);
        tagFieldToMp4Field.put(FieldKey.ALBUM_ARTIST, Mp4FieldKey.ALBUM_ARTIST);
        tagFieldToMp4Field.put(FieldKey.ALBUM_ARTIST_SORT, Mp4FieldKey.ALBUM_ARTIST_SORT);
        tagFieldToMp4Field.put(FieldKey.ALBUM_SORT, Mp4FieldKey.ALBUM_SORT);
        tagFieldToMp4Field.put(FieldKey.AMAZON_ID, Mp4FieldKey.ASIN);
        tagFieldToMp4Field.put(FieldKey.ARTIST, Mp4FieldKey.ARTIST);
        tagFieldToMp4Field.put(FieldKey.ARTIST_SORT, Mp4FieldKey.ARTIST_SORT);
        tagFieldToMp4Field.put(FieldKey.ARTISTS, Mp4FieldKey.ARTISTS);
        tagFieldToMp4Field.put(FieldKey.BARCODE, Mp4FieldKey.BARCODE);
        tagFieldToMp4Field.put(FieldKey.BPM, Mp4FieldKey.BPM);
        tagFieldToMp4Field.put(FieldKey.CATALOG_NO, Mp4FieldKey.CATALOGNO);
        tagFieldToMp4Field.put(FieldKey.COMMENT, Mp4FieldKey.COMMENT);
        tagFieldToMp4Field.put(FieldKey.COMPOSER, Mp4FieldKey.COMPOSER);
        tagFieldToMp4Field.put(FieldKey.COMPOSER_SORT, Mp4FieldKey.COMPOSER_SORT);
        tagFieldToMp4Field.put(FieldKey.CONDUCTOR, Mp4FieldKey.CONDUCTOR);
        tagFieldToMp4Field.put(FieldKey.COVER_ART, Mp4FieldKey.ARTWORK);
        tagFieldToMp4Field.put(FieldKey.CUSTOM1, Mp4FieldKey.MM_CUSTOM_1);
        tagFieldToMp4Field.put(FieldKey.CUSTOM2, Mp4FieldKey.MM_CUSTOM_2);
        tagFieldToMp4Field.put(FieldKey.CUSTOM3, Mp4FieldKey.MM_CUSTOM_3);
        tagFieldToMp4Field.put(FieldKey.CUSTOM4, Mp4FieldKey.MM_CUSTOM_4);
        tagFieldToMp4Field.put(FieldKey.CUSTOM5, Mp4FieldKey.MM_CUSTOM_5);
        tagFieldToMp4Field.put(FieldKey.DISC_NO, Mp4FieldKey.DISCNUMBER);
        tagFieldToMp4Field.put(FieldKey.DISC_SUBTITLE, Mp4FieldKey.DISC_SUBTITLE);
        tagFieldToMp4Field.put(FieldKey.DISC_TOTAL, Mp4FieldKey.DISCNUMBER);
        tagFieldToMp4Field.put(FieldKey.ENCODER, Mp4FieldKey.ENCODER);
        tagFieldToMp4Field.put(FieldKey.FBPM, Mp4FieldKey.FBPM);
        tagFieldToMp4Field.put(FieldKey.GENRE, Mp4FieldKey.GENRE);
        tagFieldToMp4Field.put(FieldKey.GROUPING, Mp4FieldKey.GROUPING);
        tagFieldToMp4Field.put(FieldKey.ISRC, Mp4FieldKey.ISRC);
        tagFieldToMp4Field.put(FieldKey.IS_COMPILATION, Mp4FieldKey.COMPILATION);
        tagFieldToMp4Field.put(FieldKey.KEY, Mp4FieldKey.KEY);
        tagFieldToMp4Field.put(FieldKey.LANGUAGE, Mp4FieldKey.LANGUAGE);
        tagFieldToMp4Field.put(FieldKey.LYRICIST, Mp4FieldKey.LYRICIST);
        tagFieldToMp4Field.put(FieldKey.LYRICS, Mp4FieldKey.LYRICS);
        tagFieldToMp4Field.put(FieldKey.MEDIA, Mp4FieldKey.MEDIA);
        tagFieldToMp4Field.put(FieldKey.MOOD, Mp4FieldKey.MOOD);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_ARTISTID, Mp4FieldKey.MUSICBRAINZ_ARTISTID);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_DISC_ID, Mp4FieldKey.MUSICBRAINZ_DISCID);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_ORIGINAL_RELEASE_ID, Mp4FieldKey.MUSICBRAINZ_ORIGINALALBUMID);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_RELEASEARTISTID, Mp4FieldKey.MUSICBRAINZ_ALBUMARTISTID);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_RELEASEID, Mp4FieldKey.MUSICBRAINZ_ALBUMID);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_RELEASE_COUNTRY, Mp4FieldKey.RELEASECOUNTRY);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_RELEASE_GROUP_ID, Mp4FieldKey.MUSICBRAINZ_RELEASE_GROUPID);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_RELEASE_STATUS, Mp4FieldKey.MUSICBRAINZ_ALBUM_STATUS);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_RELEASE_TYPE, Mp4FieldKey.MUSICBRAINZ_ALBUM_TYPE);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_TRACK_ID, Mp4FieldKey.MUSICBRAINZ_TRACKID);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_WORK_ID, Mp4FieldKey.MUSICBRAINZ_WORKID);
        tagFieldToMp4Field.put(FieldKey.MUSICIP_ID, Mp4FieldKey.MUSICIP_PUID);
        tagFieldToMp4Field.put(FieldKey.OCCASION, Mp4FieldKey.MM_OCCASION);
        tagFieldToMp4Field.put(FieldKey.ORIGINAL_ALBUM, Mp4FieldKey.MM_ORIGINAL_ALBUM_TITLE);
        tagFieldToMp4Field.put(FieldKey.ORIGINAL_ARTIST, Mp4FieldKey.MM_ORIGINAL_ARTIST);
        tagFieldToMp4Field.put(FieldKey.ORIGINAL_LYRICIST, Mp4FieldKey.MM_ORIGINAL_LYRICIST);
        tagFieldToMp4Field.put(FieldKey.ORIGINAL_YEAR, Mp4FieldKey.MM_ORIGINAL_YEAR);
        tagFieldToMp4Field.put(FieldKey.QUALITY, Mp4FieldKey.MM_QUALITY);
        tagFieldToMp4Field.put(FieldKey.RATING, Mp4FieldKey.SCORE);
        tagFieldToMp4Field.put(FieldKey.RECORD_LABEL, Mp4FieldKey.LABEL);
        tagFieldToMp4Field.put(FieldKey.REMIXER, Mp4FieldKey.REMIXER);
        tagFieldToMp4Field.put(FieldKey.SCRIPT, Mp4FieldKey.SCRIPT);
        tagFieldToMp4Field.put(FieldKey.SUBTITLE, Mp4FieldKey.SUBTITLE);
        tagFieldToMp4Field.put(FieldKey.TAGS, Mp4FieldKey.TAGS);
        tagFieldToMp4Field.put(FieldKey.TEMPO, Mp4FieldKey.TEMPO);
        tagFieldToMp4Field.put(FieldKey.TITLE, Mp4FieldKey.TITLE);
        tagFieldToMp4Field.put(FieldKey.TITLE_SORT, Mp4FieldKey.TITLE_SORT);
        tagFieldToMp4Field.put(FieldKey.TRACK, Mp4FieldKey.TRACK);
        tagFieldToMp4Field.put(FieldKey.TRACK_TOTAL, Mp4FieldKey.TRACK);
        tagFieldToMp4Field.put(FieldKey.URL_DISCOGS_ARTIST_SITE, Mp4FieldKey.URL_DISCOGS_ARTIST_SITE);
        tagFieldToMp4Field.put(FieldKey.URL_DISCOGS_RELEASE_SITE, Mp4FieldKey.URL_DISCOGS_RELEASE_SITE);
        tagFieldToMp4Field.put(FieldKey.URL_LYRICS_SITE, Mp4FieldKey.URL_LYRICS_SITE);
        tagFieldToMp4Field.put(FieldKey.URL_OFFICIAL_ARTIST_SITE, Mp4FieldKey.URL_OFFICIAL_ARTIST_SITE);
        tagFieldToMp4Field.put(FieldKey.URL_OFFICIAL_RELEASE_SITE, Mp4FieldKey.URL_OFFICIAL_RELEASE_SITE);
        tagFieldToMp4Field.put(FieldKey.URL_WIKIPEDIA_ARTIST_SITE, Mp4FieldKey.URL_WIKIPEDIA_ARTIST_SITE);
        tagFieldToMp4Field.put(FieldKey.URL_WIKIPEDIA_RELEASE_SITE, Mp4FieldKey.URL_WIKIPEDIA_RELEASE_SITE);
        tagFieldToMp4Field.put(FieldKey.YEAR, Mp4FieldKey.DAY);
        tagFieldToMp4Field.put(FieldKey.ENGINEER, Mp4FieldKey.ENGINEER);
        tagFieldToMp4Field.put(FieldKey.PRODUCER, Mp4FieldKey.PRODUCER);
        tagFieldToMp4Field.put(FieldKey.DJMIXER, Mp4FieldKey.DJMIXER);
        tagFieldToMp4Field.put(FieldKey.MIXER, Mp4FieldKey.MIXER);
        tagFieldToMp4Field.put(FieldKey.ARRANGER, Mp4FieldKey.ARRANGER);
        tagFieldToMp4Field.put(FieldKey.ACOUSTID_FINGERPRINT, Mp4FieldKey.ACOUSTID_FINGERPRINT);
        tagFieldToMp4Field.put(FieldKey.ACOUSTID_ID, Mp4FieldKey.ACOUSTID_ID);
        tagFieldToMp4Field.put(FieldKey.COUNTRY, Mp4FieldKey.COUNTRY);
    }
}

