/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.images;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ImageHandler;

public class StandardImageHandler
implements ImageHandler {
    private static StandardImageHandler instance;

    public static StandardImageHandler getInstanceOf() {
        if (instance == null) {
            instance = new StandardImageHandler();
        }
        return instance;
    }

    private StandardImageHandler() {
    }

    @Override
    public void reduceQuality(Artwork artwork, int n) throws IOException {
        while (artwork.getBinaryData().length > n) {
            Image image = (Image)artwork.getImage();
            int n2 = image.getWidth(null);
            int n3 = n2 / 2;
            this.makeSmaller(artwork, n3);
        }
    }

    @Override
    public void makeSmaller(Artwork artwork, int n) throws IOException {
        Image image = (Image)artwork.getImage();
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        float f = (float)n / (float)n2;
        float f2 = (float)n / (float)n3;
        BufferedImage bufferedImage = new BufferedImage(n, n, 1);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(f, f2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, affineTransform, null);
        graphics2D.dispose();
        if (artwork.getMimeType() != null && this.isMimeTypeWritable(artwork.getMimeType())) {
            artwork.setBinaryData(this.writeImage(bufferedImage, artwork.getMimeType()));
        } else {
            artwork.setBinaryData(this.writeImageAsPng(bufferedImage));
        }
    }

    @Override
    public boolean isMimeTypeWritable(String string) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(string);
        return iterator.hasNext();
    }

    @Override
    public byte[] writeImage(BufferedImage bufferedImage, String string) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(string);
        if (iterator.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            imageWriter.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
            imageWriter.write(bufferedImage);
            return byteArrayOutputStream.toByteArray();
        }
        throw new IOException("Cannot write to this mimetype");
    }

    @Override
    public byte[] writeImageAsPng(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "image/png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void showReadFormats() {
        String[] stringArray;
        for (String string : stringArray = ImageIO.getReaderMIMETypes()) {
            System.out.println("r" + string);
        }
    }

    @Override
    public void showWriteFormats() {
        String[] stringArray;
        for (String string : stringArray = ImageIO.getWriterMIMETypes()) {
            System.out.println(string);
        }
    }
}

