/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.nio.ByteBuffer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.NumberFixedLength;
import org.jaudiotagger.tag.datatype.NumberVariableLength;
import org.jaudiotagger.tag.datatype.StringNullTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;

public class FrameBodyPOPM
extends AbstractID3v2FrameBody
implements ID3v24FrameBody,
ID3v23FrameBody {
    private static final int RATING_FIELD_SIZE = 1;
    private static final int COUNTER_MINIMUM_FIELD_SIZE = 0;
    public static final String MEDIA_MONKEY_NO_EMAIL = "no@email";

    public FrameBodyPOPM() {
        this.setObjectValue("Email", "");
        this.setObjectValue("Rating", 0L);
        this.setObjectValue("Counter", 0L);
    }

    public FrameBodyPOPM(FrameBodyPOPM frameBodyPOPM) {
        super(frameBodyPOPM);
    }

    public FrameBodyPOPM(String string, long l, long l2) {
        this.setObjectValue("Email", string);
        this.setObjectValue("Rating", l);
        this.setObjectValue("Counter", l2);
    }

    public FrameBodyPOPM(ByteBuffer byteBuffer, int n) throws InvalidTagException {
        super(byteBuffer, n);
    }

    public void setEmailToUser(String string) {
        this.setObjectValue("Email", string);
    }

    public String getEmailToUser() {
        return (String)this.getObjectValue("Email");
    }

    public long getRating() {
        return ((Number)this.getObjectValue("Rating")).longValue();
    }

    public void setRating(long l) {
        this.setObjectValue("Rating", l);
    }

    public long getCounter() {
        return ((Number)this.getObjectValue("Counter")).longValue();
    }

    public void setCounter(long l) {
        this.setObjectValue("Counter", l);
    }

    @Override
    public String getIdentifier() {
        return "POPM";
    }

    @Override
    public String getUserFriendlyValue() {
        return this.getEmailToUser() + ":" + this.getRating() + ":" + this.getCounter();
    }

    public void parseString(String string) {
        try {
            int n = Integer.parseInt(string);
            this.setRating(n);
            this.setEmailToUser(MEDIA_MONKEY_NO_EMAIL);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new StringNullTerminated("Email", this));
        this.objectList.add(new NumberFixedLength("Rating", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new NumberVariableLength("Counter", (AbstractTagFrameBody)this, 0));
    }
}

