/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.PaddingException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3Unsynchronization;
import org.jaudiotagger.tag.id3.ID3v22FieldKey;
import org.jaudiotagger.tag.id3.ID3v22Frame;
import org.jaudiotagger.tag.id3.ID3v22Frames;
import org.jaudiotagger.tag.id3.ID3v22PreferredFrameOrderComparator;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ArtworkFactory;
import org.jaudiotagger.tag.reference.PictureTypes;

public class ID3v22Tag
extends AbstractID3v2Tag {
    protected static final String TYPE_COMPRESSION = "compression";
    protected static final String TYPE_UNSYNCHRONISATION = "unsyncronisation";
    public static final int MASK_V22_UNSYNCHRONIZATION = 128;
    public static final int MASK_V22_COMPRESSION = 64;
    protected boolean compression = false;
    protected boolean unsynchronization = false;
    public static final byte RELEASE = 2;
    public static final byte MAJOR_VERSION = 2;
    public static final byte REVISION = 0;

    @Override
    public byte getRelease() {
        return 2;
    }

    @Override
    public byte getMajorVersion() {
        return 2;
    }

    @Override
    public byte getRevision() {
        return 0;
    }

    public ID3v22Tag() {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
    }

    @Override
    protected void copyPrimitives(AbstractID3v2Tag abstractID3v2Tag) {
        logger.config("Copying primitives");
        super.copyPrimitives(abstractID3v2Tag);
        if (abstractID3v2Tag instanceof ID3v22Tag) {
            ID3v22Tag iD3v22Tag = (ID3v22Tag)abstractID3v2Tag;
            this.compression = iD3v22Tag.compression;
            this.unsynchronization = iD3v22Tag.unsynchronization;
        } else if (abstractID3v2Tag instanceof ID3v23Tag) {
            ID3v23Tag iD3v23Tag = (ID3v23Tag)abstractID3v2Tag;
            this.compression = iD3v23Tag.compression;
            this.unsynchronization = iD3v23Tag.unsynchronization;
        } else if (abstractID3v2Tag instanceof ID3v24Tag) {
            ID3v24Tag iD3v24Tag = (ID3v24Tag)abstractID3v2Tag;
            this.compression = false;
            this.unsynchronization = iD3v24Tag.unsynchronization;
        }
    }

    public ID3v22Tag(ID3v22Tag iD3v22Tag) {
        super(iD3v22Tag);
        logger.config("Creating tag from another tag of same type");
        this.copyPrimitives(iD3v22Tag);
        this.copyFrames(iD3v22Tag);
    }

    public ID3v22Tag(AbstractTag abstractTag) {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
        logger.config("Creating tag from a tag of a different version");
        if (abstractTag != null) {
            if (!(abstractTag instanceof ID3v23Tag) && abstractTag instanceof ID3v22Tag) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v24Tag iD3v24Tag = abstractTag instanceof ID3v24Tag ? (ID3v24Tag)abstractTag : new ID3v24Tag(abstractTag);
            this.setLoggingFilename(iD3v24Tag.getLoggingFilename());
            this.copyPrimitives(iD3v24Tag);
            this.copyFrames(iD3v24Tag);
            logger.config("Created tag from a tag of a different version");
        }
    }

    public ID3v22Tag(ByteBuffer byteBuffer, String string) throws TagException {
        this.setLoggingFilename(string);
        this.read(byteBuffer);
    }

    public ID3v22Tag(ByteBuffer byteBuffer) throws TagException {
        this(byteBuffer, "");
    }

    @Override
    public String getIdentifier() {
        return "ID3v2_2.20";
    }

    @Override
    public int getSize() {
        int n = 10;
        return n += super.getSize();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ID3v22Tag)) {
            return false;
        }
        ID3v22Tag iD3v22Tag = (ID3v22Tag)object;
        if (this.compression != iD3v22Tag.compression) {
            return false;
        }
        return this.unsynchronization == iD3v22Tag.unsynchronization && super.equals(object);
    }

    @Override
    protected void addFrame(AbstractID3v2Frame abstractID3v2Frame) {
        try {
            if (abstractID3v2Frame.getIdentifier().equals("TDRC") && abstractID3v2Frame.getBody() instanceof FrameBodyTDRC) {
                this.translateFrame(abstractID3v2Frame);
            } else if (abstractID3v2Frame instanceof ID3v22Frame) {
                this.copyFrameIntoMap(abstractID3v2Frame.getIdentifier(), abstractID3v2Frame);
            } else {
                ID3v22Frame iD3v22Frame = new ID3v22Frame(abstractID3v2Frame);
                this.copyFrameIntoMap(iD3v22Frame.getIdentifier(), iD3v22Frame);
            }
        }
        catch (InvalidFrameException invalidFrameException) {
            logger.log(Level.SEVERE, "Unable to convert frame:" + abstractID3v2Frame.getIdentifier());
        }
    }

    private void readHeaderFlags(ByteBuffer byteBuffer) throws TagException {
        byte by = byteBuffer.get();
        this.unsynchronization = (by & 0x80) != 0;
        boolean bl = this.compression = (by & 0x40) != 0;
        if (this.unsynchronization) {
            logger.config(ErrorMessage.ID3_TAG_UNSYNCHRONIZED.getMsg(this.getLoggingFilename()));
        }
        if (this.compression) {
            logger.config(ErrorMessage.ID3_TAG_COMPRESSED.getMsg(this.getLoggingFilename()));
        }
        if ((by & 0x20) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 32));
        }
        if ((by & 0x10) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 16));
        }
        if ((by & 8) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 8));
        }
        if ((by & 4) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 4));
        }
        if ((by & 2) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 2));
        }
        if ((by & 1) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 8));
        }
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException("ID3v2.20 tag not found");
        }
        logger.config(this.getLoggingFilename() + ":" + "Reading tag from file");
        this.readHeaderFlags(byteBuffer);
        int n = ID3SyncSafeInteger.bufferToValue(byteBuffer);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        if (this.unsynchronization) {
            byteBuffer2 = ID3Unsynchronization.synchronize(byteBuffer2);
        }
        this.readFrames(byteBuffer2, n);
        logger.config(this.getLoggingFilename() + ":" + "Loaded Frames,there are:" + this.frameMap.keySet().size());
    }

    protected void readFrames(ByteBuffer byteBuffer, int n) {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
        this.fileReadSize = n;
        logger.finest(this.getLoggingFilename() + ":" + "Start of frame body at:" + byteBuffer.position() + ",frames sizes and padding is:" + n);
        while (byteBuffer.position() < n) {
            try {
                logger.finest(this.getLoggingFilename() + ":" + "looking for next frame at:" + byteBuffer.position());
                ID3v22Frame iD3v22Frame = new ID3v22Frame(byteBuffer, this.getLoggingFilename());
                String string = iD3v22Frame.getIdentifier();
                this.loadFrameIntoMap(string, iD3v22Frame);
            }
            catch (PaddingException paddingException) {
                logger.config(this.getLoggingFilename() + ":Found padding starting at:" + byteBuffer.position());
                break;
            }
            catch (EmptyFrameException emptyFrameException) {
                logger.warning(this.getLoggingFilename() + ":" + "Empty Frame:" + emptyFrameException.getMessage());
                this.emptyFrameBytes += 6;
            }
            catch (InvalidFrameIdentifierException invalidFrameIdentifierException) {
                logger.config(this.getLoggingFilename() + ":" + "Invalid Frame Identifier:" + invalidFrameIdentifierException.getMessage());
                ++this.invalidFrames;
                break;
            }
            catch (InvalidFrameException invalidFrameException) {
                logger.warning(this.getLoggingFilename() + ":" + "Invalid Frame:" + invalidFrameException.getMessage());
                ++this.invalidFrames;
                break;
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                logger.warning(this.getLoggingFilename() + ":Corrupt Frame:" + invalidDataTypeException.getMessage());
                ++this.invalidFrames;
            }
        }
    }

    protected void translateFrame(AbstractID3v2Frame abstractID3v2Frame) {
        ID3v22Frame iD3v22Frame;
        FrameBodyTDRC frameBodyTDRC = (FrameBodyTDRC)abstractID3v2Frame.getBody();
        if (frameBodyTDRC.getYear().length() != 0) {
            iD3v22Frame = new ID3v22Frame("TYE");
            ((AbstractFrameBodyTextInfo)iD3v22Frame.getBody()).setText(frameBodyTDRC.getYear());
            this.frameMap.put(iD3v22Frame.getIdentifier(), iD3v22Frame);
        }
        if (frameBodyTDRC.getTime().length() != 0) {
            iD3v22Frame = new ID3v22Frame("TIM");
            ((AbstractFrameBodyTextInfo)iD3v22Frame.getBody()).setText(frameBodyTDRC.getTime());
            this.frameMap.put(iD3v22Frame.getIdentifier(), iD3v22Frame);
        }
    }

    private ByteBuffer writeHeaderToBuffer(int n, int n2) throws IOException {
        this.compression = false;
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        byteBuffer.put(TAG_ID);
        byteBuffer.put(this.getMajorVersion());
        byteBuffer.put(this.getRevision());
        byte by = 0;
        if (this.unsynchronization) {
            by = (byte)(by | 0xFFFFFF80);
        }
        if (this.compression) {
            by = (byte)(by | 0x40);
        }
        byteBuffer.put(by);
        byteBuffer.put(ID3SyncSafeInteger.valueToBuffer(n + n2));
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public void write(File file, long l) throws IOException {
        this.setLoggingFilename(file.getName());
        logger.config("Writing tag to file:" + this.getLoggingFilename());
        byte[] byArray = this.writeFramesToBuffer().toByteArray();
        boolean bl = this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() && ID3Unsynchronization.requiresUnsynchronization(byArray);
        if (this.isUnsynchronization()) {
            byArray = ID3Unsynchronization.unsynchronize(byArray);
            logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + byArray.length);
        }
        int n = this.calculateTagSize(byArray.length + 10, (int)l);
        int n2 = n - (byArray.length + 10);
        logger.config(this.getLoggingFilename() + ":Current audiostart:" + l);
        logger.config(this.getLoggingFilename() + ":Size including padding:" + n);
        logger.config(this.getLoggingFilename() + ":Padding:" + n2);
        ByteBuffer byteBuffer = this.writeHeaderToBuffer(n2, byArray.length);
        this.writeBufferToFile(file, byteBuffer, byArray, n2, n, l);
    }

    @Override
    public void write(WritableByteChannel writableByteChannel) throws IOException {
        logger.config(this.getLoggingFilename() + ":Writing tag to channel");
        byte[] byArray = this.writeFramesToBuffer().toByteArray();
        logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizebeforeunsynchronisation:" + byArray.length);
        boolean bl = this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() && ID3Unsynchronization.requiresUnsynchronization(byArray);
        if (this.isUnsynchronization()) {
            byArray = ID3Unsynchronization.unsynchronize(byArray);
            logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + byArray.length);
        }
        ByteBuffer byteBuffer = this.writeHeaderToBuffer(0, byArray.length);
        writableByteChannel.write(byteBuffer);
        writableByteChannel.write(ByteBuffer.wrap(byArray));
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        super.createStructureHeader();
        MP3File.getStructureFormatter().openHeadingElement("header", "");
        MP3File.getStructureFormatter().addElement(TYPE_COMPRESSION, this.compression);
        MP3File.getStructureFormatter().addElement(TYPE_UNSYNCHRONISATION, this.unsynchronization);
        MP3File.getStructureFormatter().closeHeadingElement("header");
        super.createStructureBody();
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }

    public boolean isUnsynchronization() {
        return this.unsynchronization;
    }

    public boolean isCompression() {
        return this.compression;
    }

    @Override
    public ID3v22Frame createFrame(String string) {
        return new ID3v22Frame(string);
    }

    public TagField createField(ID3v22FieldKey iD3v22FieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        if (iD3v22FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.doCreateTagField(new AbstractID3v2Tag.FrameAndSubId(iD3v22FieldKey.getFrameId(), iD3v22FieldKey.getSubId()), string);
    }

    public String getFirst(ID3v22FieldKey iD3v22FieldKey) throws KeyNotFoundException {
        if (iD3v22FieldKey == null) {
            throw new KeyNotFoundException();
        }
        FieldKey fieldKey = ID3v22Frames.getInstanceOf().getGenericKeyFromId3(iD3v22FieldKey);
        if (fieldKey != null) {
            return super.getFirst(fieldKey);
        }
        AbstractID3v2Tag.FrameAndSubId frameAndSubId = new AbstractID3v2Tag.FrameAndSubId(iD3v22FieldKey.getFrameId(), iD3v22FieldKey.getSubId());
        return super.doGetValueAtIndex(frameAndSubId, 0);
    }

    public void deleteField(ID3v22FieldKey iD3v22FieldKey) throws KeyNotFoundException {
        if (iD3v22FieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(iD3v22FieldKey.getFrameId(), iD3v22FieldKey.getSubId()));
    }

    @Override
    public void deleteField(String string) {
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(string, null));
    }

    @Override
    protected AbstractID3v2Tag.FrameAndSubId getFrameAndSubIdFromGenericKey(FieldKey fieldKey) {
        if (fieldKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        ID3v22FieldKey iD3v22FieldKey = ID3v22Frames.getInstanceOf().getId3KeyFromGenericKey(fieldKey);
        if (iD3v22FieldKey == null) {
            throw new KeyNotFoundException(fieldKey.name());
        }
        return new AbstractID3v2Tag.FrameAndSubId(iD3v22FieldKey.getFrameId(), iD3v22FieldKey.getSubId());
    }

    @Override
    protected ID3Frames getID3Frames() {
        return ID3v22Frames.getInstanceOf();
    }

    @Override
    public Comparator getPreferredFrameOrderComparator() {
        return ID3v22PreferredFrameOrderComparator.getInstanceof();
    }

    @Override
    public List<Artwork> getArtworkList() {
        List<TagField> list = this.getFields(FieldKey.COVER_ART);
        ArrayList<Artwork> arrayList = new ArrayList<Artwork>(list.size());
        for (TagField tagField : list) {
            FrameBodyPIC frameBodyPIC = (FrameBodyPIC)((AbstractID3v2Frame)tagField).getBody();
            Artwork artwork = ArtworkFactory.getNew();
            artwork.setMimeType(ImageFormats.getMimeTypeForFormat(frameBodyPIC.getFormatType()));
            artwork.setPictureType(frameBodyPIC.getPictureType());
            if (frameBodyPIC.isImageUrl()) {
                artwork.setLinked(true);
                artwork.setImageUrl(frameBodyPIC.getImageUrl());
            } else {
                artwork.setBinaryData(frameBodyPIC.getImageData());
            }
            arrayList.add(artwork);
        }
        return arrayList;
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        ID3v22Frame iD3v22Frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        FrameBodyPIC frameBodyPIC = (FrameBodyPIC)iD3v22Frame.getBody();
        if (!artwork.isLinked()) {
            frameBodyPIC.setObjectValue("PictureData", artwork.getBinaryData());
            frameBodyPIC.setObjectValue("PictureType", artwork.getPictureType());
            frameBodyPIC.setObjectValue("ImageType", ImageFormats.getFormatForMimeType(artwork.getMimeType()));
            frameBodyPIC.setObjectValue("Description", "");
            return iD3v22Frame;
        }
        try {
            frameBodyPIC.setObjectValue("PictureData", artwork.getImageUrl().getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
        frameBodyPIC.setObjectValue("PictureType", artwork.getPictureType());
        frameBodyPIC.setObjectValue("ImageType", "-->");
        frameBodyPIC.setObjectValue("Description", "");
        return iD3v22Frame;
    }

    public TagField createArtworkField(byte[] byArray, String string) {
        ID3v22Frame iD3v22Frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        FrameBodyPIC frameBodyPIC = (FrameBodyPIC)iD3v22Frame.getBody();
        frameBodyPIC.setObjectValue("PictureData", byArray);
        frameBodyPIC.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
        frameBodyPIC.setObjectValue("ImageType", ImageFormats.getFormatForMimeType(string));
        frameBodyPIC.setObjectValue("Description", "");
        return iD3v22Frame;
    }
}

