/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.UnsupportedEncodingException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.id3.ID3v1FieldKey;

public class ID3v1TagField
implements TagTextField {
    private boolean common;
    private String content;
    private String id;

    public ID3v1TagField(byte[] byArray) throws UnsupportedEncodingException {
        String string = new String(byArray, "ISO-8859-1");
        int n = string.indexOf("=");
        if (n == -1) {
            this.id = "ERRONEOUS";
            this.content = string;
        } else {
            this.id = string.substring(0, n).toUpperCase();
            this.content = string.length() > n ? string.substring(n + 1) : "";
        }
        this.checkCommon();
    }

    public ID3v1TagField(String string, String string2) {
        this.id = string.toUpperCase();
        this.content = string2;
        this.checkCommon();
    }

    private void checkCommon() {
        this.common = this.id.equals(ID3v1FieldKey.TITLE.name()) || this.id.equals(ID3v1FieldKey.ALBUM.name()) || this.id.equals(ID3v1FieldKey.ARTIST.name()) || this.id.equals(ID3v1FieldKey.GENRE.name()) || this.id.equals(ID3v1FieldKey.YEAR.name()) || this.id.equals(ID3v1FieldKey.COMMENT.name()) || this.id.equals(ID3v1FieldKey.TRACK.name());
    }

    protected void copy(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
    }

    @Override
    public void copyContent(TagField tagField) {
        if (tagField instanceof TagTextField) {
            this.content = ((TagTextField)tagField).getContent();
        }
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getEncoding() {
        return "ISO-8859-1";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public byte[] getRawContent() throws UnsupportedEncodingException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = this.id.getBytes("ISO-8859-1");
        byte[] byArray3 = Utils.getDefaultBytes(this.content, "ISO-8859-1");
        byte[] byArray4 = new byte[4 + byArray2.length + 1 + byArray3.length];
        int n = byArray2.length + 1 + byArray3.length;
        byArray[3] = (byte)((n & 0xFF000000) >> 24);
        byArray[2] = (byte)((n & 0xFF0000) >> 16);
        byArray[1] = (byte)((n & 0xFF00) >> 8);
        byArray[0] = (byte)(n & 0xFF);
        int n2 = 0;
        this.copy(byArray, byArray4, n2);
        this.copy(byArray2, byArray4, n2 += 4);
        byArray4[n2 += byArray2.length] = 61;
        this.copy(byArray3, byArray4, ++n2);
        return byArray4;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public void isBinary(boolean bl) {
    }

    @Override
    public boolean isCommon() {
        return this.common;
    }

    @Override
    public boolean isEmpty() {
        return this.content.equals("");
    }

    @Override
    public void setContent(String string) {
        this.content = string;
    }

    @Override
    public void setEncoding(String string) {
    }

    @Override
    public String toString() {
        return this.getContent();
    }
}

