/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3v22Frames;
import org.jaudiotagger.tag.id3.ID3v23Frames;
import org.jaudiotagger.tag.id3.ID3v24Frames;

public class ID3Tags {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.id3");

    private ID3Tags() {
    }

    public static boolean isID3v22FrameIdentifier(String string) {
        if (string.length() < 3) {
            return false;
        }
        return string.length() == 3 && ID3v22Frames.getInstanceOf().getIdToValueMap().containsKey(string);
    }

    public static boolean isID3v23FrameIdentifier(String string) {
        return string.length() >= 4 && ID3v23Frames.getInstanceOf().getIdToValueMap().containsKey(string.substring(0, 4));
    }

    public static boolean isID3v24FrameIdentifier(String string) {
        return string.length() >= 4 && ID3v24Frames.getInstanceOf().getIdToValueMap().containsKey(string.substring(0, 4));
    }

    public static long getWholeNumber(Object object) {
        long l;
        if (object instanceof String) {
            l = Long.parseLong((String)object);
        } else if (object instanceof Byte) {
            l = ((Byte)object).byteValue();
        } else if (object instanceof Short) {
            l = ((Short)object).shortValue();
        } else if (object instanceof Integer) {
            l = ((Integer)object).intValue();
        } else if (object instanceof Long) {
            l = (Long)object;
        } else {
            throw new IllegalArgumentException("Unsupported value class: " + object.getClass().getName());
        }
        return l;
    }

    public static String convertFrameID22To23(String string) {
        if (string.length() < 3) {
            return null;
        }
        return ID3Frames.convertv22Tov23.get((String)string.subSequence(0, 3));
    }

    public static String convertFrameID22To24(String string) {
        if (string.length() < 3) {
            return null;
        }
        String string2 = ID3Frames.convertv22Tov23.get(string.substring(0, 3));
        if (string2 != null) {
            String string3 = ID3Frames.convertv23Tov24.get(string2);
            if (string3 == null) {
                if (ID3v24Frames.getInstanceOf().getIdToValueMap().get(string2) != null) {
                    return string2;
                }
                return null;
            }
            return string3;
        }
        return null;
    }

    public static String convertFrameID23To22(String string) {
        if (string.length() < 4) {
            return null;
        }
        if (ID3v23Frames.getInstanceOf().getIdToValueMap().containsKey(string)) {
            return ID3Frames.convertv23Tov22.get(string.substring(0, 4));
        }
        return null;
    }

    public static String convertFrameID23To24(String string) {
        if (string.length() < 4) {
            return null;
        }
        if (ID3v23Frames.getInstanceOf().getIdToValueMap().containsKey(string)) {
            if (ID3v24Frames.getInstanceOf().getIdToValueMap().containsKey(string)) {
                return string;
            }
            return ID3Frames.convertv23Tov24.get(string.substring(0, 4));
        }
        return null;
    }

    public static String forceFrameID22To23(String string) {
        return ID3Frames.forcev22Tov23.get(string);
    }

    public static String forceFrameID23To22(String string) {
        return ID3Frames.forcev23Tov22.get(string);
    }

    public static String forceFrameID23To24(String string) {
        return ID3Frames.forcev23Tov24.get(string);
    }

    public static String forceFrameID24To23(String string) {
        return ID3Frames.forcev24Tov23.get(string);
    }

    public static String convertFrameID24To23(String string) {
        if (string.length() < 4) {
            return null;
        }
        String string2 = ID3Frames.convertv24Tov23.get(string);
        if (string2 == null && ID3v23Frames.getInstanceOf().getIdToValueMap().containsKey(string)) {
            string2 = string;
        }
        return string2;
    }

    public static Object copyObject(Object object) {
        if (object == null) {
            return null;
        }
        try {
            Class[] classArray = new Class[]{object.getClass()};
            Constructor<?> constructor = object.getClass().getConstructor(classArray);
            Object[] objectArray = new Object[]{object};
            return constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("NoSuchMethodException: Error finding constructor to create copy:" + object.getClass().getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("IllegalAccessException: No access to run constructor to create copy" + object.getClass().getName());
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("InstantiationException: Unable to instantiate constructor to copy" + object.getClass().getName());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof Error) {
                throw (Error)invocationTargetException.getCause();
            }
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw new IllegalArgumentException("InvocationTargetException: Unable to invoke constructor to create copy");
        }
    }

    public static long findNumber(String string) throws TagException {
        return ID3Tags.findNumber(string, 0);
    }

    public static long findNumber(String string, int n) throws TagException {
        int n2;
        int n3;
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to image string is out of bounds: offset = " + n + ", string.length()" + string.length());
        }
        for (n3 = n; n3 < string.length() && (string.charAt(n3) < '0' || string.charAt(n3) > '9') && string.charAt(n3) != '-'; ++n3) {
        }
        for (n2 = n3 + 1; n2 < string.length() && string.charAt(n2) >= '0' && string.charAt(n2) <= '9'; ++n2) {
        }
        if (n2 > string.length() || n2 <= n3) {
            throw new TagException("Unable to find integer in string: " + string);
        }
        long l = Long.parseLong(string.substring(n3, n2));
        return l;
    }

    public static String stripChar(String string, char c) {
        if (string != null) {
            char[] cArray = new char[string.length()];
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == c) continue;
                cArray[n++] = string.charAt(i);
            }
            return new String(cArray, 0, n);
        }
        return null;
    }

    public static String truncate(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }
}

