/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrame;
import org.jaudiotagger.tag.id3.AbstractTagItem;
import org.jaudiotagger.tag.id3.ID3Tags;

public abstract class AbstractTagFrameBody
extends AbstractTagItem {
    private AbstractTagFrame header;
    protected ArrayList<AbstractDataType> objectList = new ArrayList();

    public void createStructure() {
    }

    public final byte getTextEncoding() {
        AbstractDataType abstractDataType = this.getObject("TextEncoding");
        if (abstractDataType != null) {
            Long l = (Long)abstractDataType.getValue();
            return l.byteValue();
        }
        return 0;
    }

    public final void setTextEncoding(byte by) {
        this.setObjectValue("TextEncoding", by);
    }

    protected AbstractTagFrameBody() {
        this.setupObjectList();
    }

    protected AbstractTagFrameBody(AbstractTagFrameBody abstractTagFrameBody) {
        for (int i = 0; i < abstractTagFrameBody.objectList.size(); ++i) {
            AbstractDataType abstractDataType = (AbstractDataType)ID3Tags.copyObject(abstractTagFrameBody.objectList.get(i));
            abstractDataType.setBody(this);
            this.objectList.add(abstractDataType);
        }
    }

    public String getUserFriendlyValue() {
        return this.toString();
    }

    public String getBriefDescription() {
        String string = "";
        for (AbstractDataType abstractDataType : this.objectList) {
            if (abstractDataType.toString() == null || abstractDataType.toString().length() <= 0) continue;
            string = string + abstractDataType.getIdentifier() + "=\"" + abstractDataType.toString() + "\"; ";
        }
        return string;
    }

    public final String getLongDescription() {
        String string = "";
        for (AbstractDataType abstractDataType : this.objectList) {
            if (abstractDataType.toString() == null || abstractDataType.toString().length() <= 0) continue;
            string = string + abstractDataType.getIdentifier() + " = " + abstractDataType.toString() + "\n";
        }
        return string;
    }

    public final void setObjectValue(String string, Object object) {
        ListIterator<AbstractDataType> listIterator = this.objectList.listIterator();
        while (listIterator.hasNext()) {
            AbstractDataType abstractDataType = (AbstractDataType)listIterator.next();
            if (!abstractDataType.getIdentifier().equals(string)) continue;
            abstractDataType.setValue(object);
        }
    }

    public final Object getObjectValue(String string) {
        return this.getObject(string).getValue();
    }

    public final AbstractDataType getObject(String string) {
        ListIterator<AbstractDataType> listIterator = this.objectList.listIterator();
        while (listIterator.hasNext()) {
            AbstractDataType abstractDataType = (AbstractDataType)listIterator.next();
            if (!abstractDataType.getIdentifier().equals(string)) continue;
            return abstractDataType;
        }
        return null;
    }

    @Override
    public int getSize() {
        int n = 0;
        ListIterator<AbstractDataType> listIterator = this.objectList.listIterator();
        while (listIterator.hasNext()) {
            AbstractDataType abstractDataType = (AbstractDataType)listIterator.next();
            n += abstractDataType.getSize();
        }
        return n;
    }

    @Override
    public boolean isSubsetOf(Object object) {
        if (!(object instanceof AbstractTagFrameBody)) {
            return false;
        }
        ArrayList<AbstractDataType> arrayList = ((AbstractTagFrameBody)object).objectList;
        for (AbstractDataType abstractDataType : this.objectList) {
            if (abstractDataType.getValue() == null || arrayList.contains(abstractDataType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AbstractTagFrameBody)) {
            return false;
        }
        AbstractTagFrameBody abstractTagFrameBody = (AbstractTagFrameBody)object;
        boolean bl = this.objectList.equals(abstractTagFrameBody.objectList) && super.equals(object);
        return bl;
    }

    public Iterator iterator() {
        return this.objectList.iterator();
    }

    public String toString() {
        return this.getBriefDescription();
    }

    protected abstract void setupObjectList();

    public AbstractTagFrame getHeader() {
        return this.header;
    }

    public void setHeader(AbstractTagFrame abstractTagFrame) {
        this.header = abstractTagFrame;
    }
}

