/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3Tags;

public class NumberVariableLength
extends AbstractDataType {
    private static final int MINIMUM_NO_OF_DIGITS = 1;
    private static final int MAXIMUM_NO_OF_DIGITS = 8;
    int minLength = 1;

    public NumberVariableLength(String string, AbstractTagFrameBody abstractTagFrameBody, int n) {
        super(string, abstractTagFrameBody);
        this.minLength = n;
    }

    public NumberVariableLength(NumberVariableLength numberVariableLength) {
        super(numberVariableLength);
        this.minLength = numberVariableLength.minLength;
    }

    public int getMaximumLenth() {
        return 8;
    }

    public int getMinimumLength() {
        return this.minLength;
    }

    public void setMinimumSize(int n) {
        if (n > 0) {
            this.minLength = n;
        }
    }

    @Override
    public int getSize() {
        if (this.value == null) {
            return 0;
        }
        long l = ID3Tags.getWholeNumber(this.value);
        int n = 0;
        for (int i = 1; i <= 8; ++i) {
            int n2 = (byte)l & 0xFF;
            if (n2 != 0) {
                n = i;
            }
            l >>= 8;
        }
        return this.minLength > n ? this.minLength : n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof NumberVariableLength)) {
            return false;
        }
        NumberVariableLength numberVariableLength = (NumberVariableLength)object;
        return this.minLength == numberVariableLength.minLength && super.equals(object);
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        if (byArray == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("negativer offset into an array offset:" + n);
        }
        if (n >= byArray.length) {
            if (this.minLength == 0) {
                this.value = 0L;
                return;
            }
            throw new InvalidDataTypeException("Offset to byte array is out of bounds: offset = " + n + ", array.length = " + byArray.length);
        }
        long l = 0L;
        for (int i = n; i < byArray.length; ++i) {
            l <<= 8;
            l += (long)(byArray[i] & 0xFF);
        }
        this.value = l;
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    @Override
    public byte[] writeByteArray() {
        byte[] byArray;
        int n = this.getSize();
        if (n == 0) {
            byArray = new byte[]{};
        } else {
            long l = ID3Tags.getWholeNumber(this.value);
            byArray = new byte[n];
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)(l & 0xFFL);
                l >>= 8;
            }
        }
        return byArray;
    }
}

