/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3Tags;

public class NumberFixedLength
extends AbstractDataType {
    public NumberFixedLength(String string, AbstractTagFrameBody abstractTagFrameBody, int n) {
        super(string, abstractTagFrameBody);
        if (n < 0) {
            throw new IllegalArgumentException("Length is less than zero: " + n);
        }
        this.size = n;
    }

    public NumberFixedLength(NumberFixedLength numberFixedLength) {
        super(numberFixedLength);
        this.size = numberFixedLength.size;
    }

    public void setSize(int n) {
        if (n > 0) {
            this.size = n;
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setValue(Object object) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("Invalid value type for NumberFixedLength:" + object.getClass());
        }
        super.setValue(object);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof NumberFixedLength)) {
            return false;
        }
        NumberFixedLength numberFixedLength = (NumberFixedLength)object;
        return this.size == numberFixedLength.size && super.equals(object);
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        if (byArray == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (n < 0 || n >= byArray.length) {
            throw new InvalidDataTypeException("Offset to byte array is out of bounds: offset = " + n + ", array.length = " + byArray.length);
        }
        if (n + this.size > byArray.length) {
            throw new InvalidDataTypeException("Offset plus size to byte array is out of bounds: offset = " + n + ", size = " + this.size + " + arr.length " + byArray.length);
        }
        long l = 0L;
        for (int i = n; i < n + this.size; ++i) {
            l <<= 8;
            l += (long)(byArray[i] & 0xFF);
        }
        this.value = l;
        logger.config("Read NumberFixedlength:" + this.value);
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    @Override
    public byte[] writeByteArray() {
        byte[] byArray = new byte[this.size];
        if (this.value != null) {
            long l = ID3Tags.getWholeNumber(this.value);
            for (int i = this.size - 1; i >= 0; --i) {
                byArray[i] = (byte)(l & 0xFFL);
                l >>= 8;
            }
        }
        return byArray;
    }
}

