/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class ID3v2LyricLine
extends AbstractDataType {
    String text = "";
    long timeStamp = 0L;

    public ID3v2LyricLine(String string, AbstractTagFrameBody abstractTagFrameBody) {
        super(string, abstractTagFrameBody);
    }

    public ID3v2LyricLine(ID3v2LyricLine iD3v2LyricLine) {
        super(iD3v2LyricLine);
        this.text = iD3v2LyricLine.text;
        this.timeStamp = iD3v2LyricLine.timeStamp;
    }

    @Override
    public int getSize() {
        return this.text.length() + 1 + 4;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ID3v2LyricLine)) {
            return false;
        }
        ID3v2LyricLine iD3v2LyricLine = (ID3v2LyricLine)object;
        if (!this.text.equals(iD3v2LyricLine.text)) {
            return false;
        }
        return this.timeStamp == iD3v2LyricLine.timeStamp && super.equals(object);
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        if (byArray == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (n < 0 || n >= byArray.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + n + ", array.length = " + byArray.length);
        }
        this.text = Utils.getString(byArray, n, byArray.length - n - 4, "ISO-8859-1");
        this.timeStamp = 0L;
        for (int i = byArray.length - 4; i < byArray.length; ++i) {
            this.timeStamp <<= 8;
            this.timeStamp += (long)byArray[i];
        }
    }

    public String toString() {
        return this.timeStamp + " " + this.text;
    }

    @Override
    public byte[] writeByteArray() {
        byte[] byArray = new byte[this.getSize()];
        for (int i = 0; i < this.text.length(); ++i) {
            byArray[i] = (byte)this.text.charAt(i);
        }
        byArray[i++] = 0;
        byArray[i++] = (byte)((this.timeStamp & 0xFFFFFFFFFF000000L) >> 24);
        byArray[i++] = (byte)((this.timeStamp & 0xFF0000L) >> 16);
        byArray[i++] = (byte)((this.timeStamp & 0xFF00L) >> 8);
        byArray[i++] = (byte)(this.timeStamp & 0xFFL);
        return byArray;
    }
}

