/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.asf;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.asf.AbstractAsfTagImageField;
import org.jaudiotagger.tag.asf.AsfFieldKey;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;

public class AsfTagCoverField
extends AbstractAsfTagImageField {
    public static final Logger LOGGER = Logger.getLogger("org.jaudiotagger.audio.asf.tag");
    private String description;
    private int endOfName = 0;
    private int imageDataSize;
    private String mimeType;
    private int pictureType;

    public AsfTagCoverField(byte[] byArray, int n, String string, String string2) {
        super(new MetadataDescriptor(AsfFieldKey.COVER_ART.getFieldName(), 1));
        this.getDescriptor().setBinaryValue(this.createRawContent(byArray, n, string, string2));
    }

    public AsfTagCoverField(MetadataDescriptor metadataDescriptor) {
        super(metadataDescriptor);
        if (!metadataDescriptor.getName().equals(AsfFieldKey.COVER_ART.getFieldName())) {
            throw new IllegalArgumentException("Descriptor description must be WM/Picture");
        }
        if (metadataDescriptor.getType() != 1) {
            throw new IllegalArgumentException("Descriptor type must be binary");
        }
        try {
            this.processRawContent();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private byte[] createRawContent(byte[] byArray, int n, String string, String string2) {
        byte[] byArray2;
        this.description = string;
        this.imageDataSize = byArray.length;
        this.pictureType = n;
        this.mimeType = string2;
        if (string2 == null && (string2 = ImageFormats.getMimeTypeForBinarySignature(byArray)) == null) {
            LOGGER.warning(ErrorMessage.GENERAL_UNIDENITIFED_IMAGE_FORMAT.getMsg());
            string2 = "image/png";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(Utils.getSizeLEInt32(byArray.length), 0, 4);
        try {
            byArray2 = string2.getBytes(AsfHeader.ASF_CHARSET.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to find encoding:" + AsfHeader.ASF_CHARSET.name());
        }
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        if (string != null && string.length() > 0) {
            byte[] byArray3;
            try {
                byArray3 = string.getBytes(AsfHeader.ASF_CHARSET.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Unable to find encoding:" + AsfHeader.ASF_CHARSET.name());
            }
            byteArrayOutputStream.write(byArray3, 0, byArray3.length);
        }
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        return byteArrayOutputStream.toByteArray();
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int getImageDataSize() {
        return this.imageDataSize;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getPictureType() {
        return this.pictureType;
    }

    @Override
    public byte[] getRawImageData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.getRawContent(), this.endOfName, this.toWrap.getRawDataSize() - this.endOfName);
        return byteArrayOutputStream.toByteArray();
    }

    private void processRawContent() throws UnsupportedEncodingException {
        this.pictureType = this.getRawContent()[0];
        this.imageDataSize = Utils.getIntLE(this.getRawContent(), 1, 2);
        this.mimeType = null;
        this.description = null;
        int n = 0;
        for (int i = 5; i < this.getRawContent().length - 1; i += 2) {
            if (this.getRawContent()[i] != 0 || this.getRawContent()[i + 1] != 0) continue;
            if (this.mimeType == null) {
                this.mimeType = new String(this.getRawContent(), 5, i - 5, "UTF-16LE");
                n = i + 2;
                continue;
            }
            if (this.description != null) continue;
            this.description = new String(this.getRawContent(), n, i - n, "UTF-16LE");
            this.endOfName = i + 2;
            break;
        }
    }
}

